/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.AsWrapperTypeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import org.drools.core.xml.jaxb.util.JaxbListAdapter;
import org.drools.core.xml.jaxb.util.JaxbListWrapper;
import org.drools.core.xml.jaxb.util.JaxbUnknownAdapter;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.marshalling.ModelWrapper;
import org.kie.server.api.marshalling.json.FallbackableTypeFactory;
import org.kie.server.api.marshalling.json.JSONMarshallerExtension;
import org.kie.server.api.model.Wrapped;
import org.kie.server.api.model.definition.QueryParam;
import org.kie.server.api.model.type.JaxbByteArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONMarshaller
implements Marshaller {
    private static final Logger logger = LoggerFactory.getLogger(MarshallerFactory.class);
    private static final boolean STRICT_ID_FORMAT = Boolean.getBoolean("org.kie.server.strict.id.format");
    private final boolean STRICT_JAVABEANS_SERIALIZERS = Boolean.getBoolean("org.kie.server.strict.javaBeans.serializers");
    private static final String FIELDS = "fields";
    private static final String NOT_NULL = "not_null";
    private boolean formatDate;
    private String dateFormatStr = System.getProperty("org.kie.server.json.date_format", "yyyy-MM-dd'T'hh:mm:ss.SSSZ");
    private boolean useStrictJavaBeans;
    private boolean fallbackClassLoaderEnabled = Boolean.parseBoolean(System.getProperty("org.kie.server.json.fallbackClassLoader.enabled", "false"));
    private boolean findDeserializerFirst = Boolean.parseBoolean(System.getProperty("org.kie.server.json.findDeserializerFirst.enabled", "true"));
    private ThreadLocal<JSONContext> jsonContext = ThreadLocal.withInitial(() -> new JSONContext());
    protected ClassLoader classLoader;
    protected ObjectMapper objectMapper;
    private ObjectMapper notNullObjectMapper;
    protected Set<Class<?>> classesSet;
    protected ObjectMapper deserializeObjectMapper;
    protected DateFormat dateFormat = new SimpleDateFormat(this.dateFormatStr);
    private static final List<JSONMarshallerExtension> EXTENSIONS;

    public JSONMarshaller(boolean formatDate) {
        this(null, null, formatDate, false);
    }

    public JSONMarshaller(Set<Class<?>> classes, ClassLoader classLoader) {
        this(classes, classLoader, Boolean.parseBoolean(System.getProperty("org.kie.server.json.format.date", "false")), false);
    }

    public JSONMarshaller(Set<Class<?>> classes, ClassLoader classLoader, boolean formatDate) {
        this(classes, classLoader, formatDate, false);
    }

    public JSONMarshaller(Set<Class<?>> classes, ClassLoader classLoader, boolean formatDate, boolean useStrictJavaBeans) {
        this.formatDate = formatDate;
        this.classLoader = classLoader;
        this.useStrictJavaBeans = useStrictJavaBeans | this.STRICT_JAVABEANS_SERIALIZERS;
        this.buildMarshaller(classes, classLoader);
        this.configureMarshaller(classes, classLoader);
        this.notNullObjectMapper = this.objectMapper.copy().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    protected void buildMarshaller(Set<Class<?>> classes, ClassLoader classLoader) {
        this.objectMapper = new ObjectMapper();
        this.deserializeObjectMapper = new ObjectMapper();
    }

    protected void configureMarshaller(Set<Class<?>> classes, ClassLoader classLoader) {
        ObjectMapper customSerializationMapper = new ObjectMapper();
        if (classes == null) {
            classes = new HashSet();
        }
        classes.add(JaxbByteArray.class);
        if (!this.formatDate) {
            classes.add(Date.class);
        }
        List<NamedType> customClasses = this.prepareCustomClasses(classes);
        ExtendedJaxbAnnotationIntrospector primary = new ExtendedJaxbAnnotationIntrospector(customClasses, customSerializationMapper);
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        AnnotationIntrospector introspectorPair = AnnotationIntrospector.pair((AnnotationIntrospector)primary, (AnnotationIntrospector)secondary);
        this.objectMapper.setConfig(((SerializationConfig)this.objectMapper.getSerializationConfig().with(introspectorPair)).with(SerializationFeature.INDENT_OUTPUT));
        this.deserializeObjectMapper.setConfig(((DeserializationConfig)this.objectMapper.getDeserializationConfig().with(introspectorPair)).with(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).without(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES));
        this.objectMapper.configure(MapperFeature.USE_STD_BEAN_NAMING, this.useStrictJavaBeans);
        this.deserializeObjectMapper.configure(MapperFeature.USE_STD_BEAN_NAMING, this.useStrictJavaBeans);
        customSerializationMapper.configure(MapperFeature.USE_STD_BEAN_NAMING, this.useStrictJavaBeans);
        customSerializationMapper.setConfig((DeserializationConfig)customSerializationMapper.getDeserializationConfig().with(introspectorPair));
        customSerializationMapper.setConfig(((SerializationConfig)customSerializationMapper.getSerializationConfig().with(introspectorPair)).with(SerializationFeature.INDENT_OUTPUT));
        if (classes != null && !classes.isEmpty()) {
            ObjectMapper customObjectMapper = new ObjectMapper();
            ObjectMapper.DefaultTypeResolverBuilder typer = new ObjectMapper.DefaultTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL){

                public boolean useForType(JavaType t) {
                    return JSONMarshaller.this.classesSet.contains(t.getRawClass());
                }
            };
            typer = typer.init(JsonTypeInfo.Id.CLASS, null);
            typer = typer.inclusion(JsonTypeInfo.As.WRAPPER_OBJECT);
            customObjectMapper.setDefaultTyping((TypeResolverBuilder)typer);
            customObjectMapper.setConfig(((SerializationConfig)customObjectMapper.getSerializationConfig().with(introspectorPair)).with(SerializationFeature.INDENT_OUTPUT));
            customObjectMapper.configure(MapperFeature.USE_STD_BEAN_NAMING, this.useStrictJavaBeans);
            SimpleModule mod = new SimpleModule("custom-object-mapper", Version.unknownVersion());
            CustomObjectSerializer customObjectSerializer = new CustomObjectSerializer(customObjectMapper);
            for (Class<?> clazz : classes) {
                mod.addSerializer(clazz, (JsonSerializer)customObjectSerializer);
            }
            this.objectMapper.registerModule((Module)mod);
            ObjectMapper.DefaultTypeResolverBuilder typer2 = new ObjectMapper.DefaultTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL){

                public boolean useForType(JavaType t) {
                    return JSONMarshaller.this.classesSet.contains(t.getRawClass());
                }

                public TypeDeserializer buildTypeDeserializer(DeserializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
                    if (this.useForType(baseType)) {
                        if (this._idType == JsonTypeInfo.Id.NONE) {
                            return null;
                        }
                        PolymorphicTypeValidator subTypeValidator = this.verifyBaseTypeValidity((MapperConfig)config, baseType);
                        TypeIdResolver idRes = this.idResolver((MapperConfig)config, baseType, subTypeValidator, subtypes, false, true);
                        switch (this._includeAs) {
                            case WRAPPER_OBJECT: {
                                return new CustomAsWrapperTypeDeserializer(baseType, idRes, this._typeProperty, true, baseType);
                            }
                        }
                    }
                    return super.buildTypeDeserializer(config, baseType, subtypes);
                }
            };
            typer2 = typer2.init(JsonTypeInfo.Id.CLASS, null);
            typer2 = typer2.inclusion(JsonTypeInfo.As.WRAPPER_OBJECT);
            this.deserializeObjectMapper.setDefaultTyping((TypeResolverBuilder)typer2);
            SimpleModule modDeser = new SimpleModule("custom-object-unmapper", Version.unknownVersion());
            modDeser.addDeserializer(Object.class, (JsonDeserializer)new CustomObjectDeserializer(classes));
            this.deserializeObjectMapper.registerModule((Module)modDeser);
            this.deserializeObjectMapper.setConfig((DeserializationConfig)this.deserializeObjectMapper.getDeserializationConfig().with(introspectorPair));
            if (this.fallbackClassLoaderEnabled) {
                this.deserializeObjectMapper.setTypeFactory((TypeFactory)FallbackableTypeFactory.defaultInstance().withFallbackClassLoader(classLoader));
            }
        }
        if (this.formatDate) {
            this.objectMapper.setDateFormat(this.dateFormat);
            customSerializationMapper.setDateFormat(this.dateFormat);
            this.deserializeObjectMapper.setDateFormat(this.dateFormat);
            this.deserializeObjectMapper.getDeserializationConfig().with(this.dateFormat);
            this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            customSerializationMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        }
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        this.objectMapper.registerModule((Module)javaTimeModule);
        this.deserializeObjectMapper.registerModule((Module)javaTimeModule);
        customSerializationMapper.registerModule((Module)javaTimeModule);
        this.classesSet = classes;
        for (JSONMarshallerExtension extension : EXTENSIONS) {
            extension.extend(this, this.objectMapper, this.deserializeObjectMapper);
            extension.extend(this, customSerializationMapper, customSerializationMapper);
        }
    }

    protected List<NamedType> prepareCustomClasses(Set<Class<?>> classes) {
        ArrayList<NamedType> customClasses = new ArrayList<NamedType>();
        if (classes != null) {
            for (Class<?> clazz : classes) {
                customClasses.add(new NamedType(clazz, clazz.getSimpleName()));
                customClasses.add(new NamedType(clazz, clazz.getName()));
            }
        }
        return customClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String marshall(Object input, Map<String, Object> parameters) {
        try {
            if (parameters.containsKey("strict")) {
                this.jsonContext.get().setWrap(Boolean.parseBoolean((String)parameters.get("strict")));
            }
            if (NOT_NULL.equals(parameters.get(FIELDS))) {
                this.jsonContext.get().setWriteNull(false);
            }
            String string = this.marshall(input);
            return string;
        }
        finally {
            this.jsonContext.get().reset();
        }
    }

    @Override
    public String marshall(Object objectInput) {
        try {
            return this.getMapper(this.objectMapper, this.notNullObjectMapper).writeValueAsString(this.wrap(objectInput));
        }
        catch (IOException e) {
            throw new MarshallingException("Error marshalling input", e);
        }
    }

    @Override
    public byte[] marshallAsBytes(Object objectInput) {
        try {
            return this.getMapper(this.objectMapper, this.notNullObjectMapper).writeValueAsBytes(this.wrap(objectInput));
        }
        catch (IOException e) {
            throw new MarshallingException("Error marshalling input", e);
        }
    }

    @Override
    public <T> T unmarshall(String serializedInput, Class<T> type) {
        try {
            Class actualType = this.classesSet.contains(type) ? Object.class : type;
            Object object = this.unwrap(this.deserializeObjectMapper.readValue(serializedInput, actualType));
            return (T)object;
        }
        catch (IOException e) {
            throw new MarshallingException("Error unmarshalling input", e);
        }
        finally {
            this.jsonContext.get().reset();
        }
    }

    @Override
    public <T> T unmarshall(byte[] serializedInput, Class<T> type) {
        try {
            Class actualType = this.classesSet.contains(type) ? Object.class : type;
            Object object = this.unwrap(this.deserializeObjectMapper.readValue(serializedInput, actualType));
            return (T)object;
        }
        catch (IOException e) {
            throw new MarshallingException("Error unmarshalling input", e);
        }
        finally {
            this.jsonContext.get().reset();
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public MarshallingFormat getFormat() {
        return MarshallingFormat.JSON;
    }

    protected Object wrap(Object data) {
        if (STRICT_ID_FORMAT || this.jsonContext.get().isWrap()) {
            data = ModelWrapper.wrap(data);
        } else if (data instanceof byte[]) {
            return new JaxbByteArray((byte[])data);
        }
        return data;
    }

    protected Object unwrap(Object data) {
        if (data instanceof Wrapped) {
            return ((Wrapped)data).unwrap();
        }
        return data;
    }

    private ObjectMapper getMapper(ObjectMapper alwaysMapper, ObjectMapper notNullMapper) {
        return this.jsonContext.get().isWriteNull() ? alwaysMapper : notNullMapper;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    static {
        logger.info("Marshaller extensions init");
        ServiceLoader<JSONMarshallerExtension> plugins = ServiceLoader.load(JSONMarshallerExtension.class);
        ArrayList loadedPlugins = new ArrayList();
        plugins.forEach(plugin -> {
            logger.info("JSONMarshallerExtension implementation found: {}", (Object)plugin.getClass().getName());
            loadedPlugins.add(plugin);
        });
        EXTENSIONS = Collections.unmodifiableList(loadedPlugins);
    }

    class CustomAsWrapperTypeDeserializer
    extends AsWrapperTypeDeserializer {
        public CustomAsWrapperTypeDeserializer(JavaType bt, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl) {
            super(bt, idRes, typePropertyName, typeIdVisible, defaultImpl);
        }

        protected CustomAsWrapperTypeDeserializer(AsWrapperTypeDeserializer src, BeanProperty property) {
            super(src, property);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object deserializeTypedFromArray(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            try {
                Object value;
                Thread.currentThread().setContextClassLoader(this._baseType.getRawClass().getClassLoader());
                JsonDeserializer deser = this._findDeserializer(ctxt, this.baseTypeName());
                Object object = value = deser.deserialize(jp, ctxt);
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object deserializeTypedFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            try {
                Object value;
                Thread.currentThread().setContextClassLoader(this._baseType.getRawClass().getClassLoader());
                if (JSONMarshaller.this.classesSet.contains(this._baseType.getRawClass()) && !((JSONContext)JSONMarshaller.this.jsonContext.get()).isStripped()) {
                    if (JSONMarshaller.this.findDeserializerFirst) {
                        Object object = this.deserializerFirstLookup(jp, ctxt);
                        return object;
                    }
                    Object object = this.classLoadingFirstLookup(jp, ctxt);
                    return object;
                }
                ((JSONContext)JSONMarshaller.this.jsonContext.get()).reset();
                JsonDeserializer deser = this._findDeserializer(ctxt, this.baseTypeName());
                Object object = value = deser.deserialize(jp, ctxt);
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
        }

        private Object deserializerFirstLookup(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String nextFieldName = jp.nextFieldName();
            if (!this.baseTypeName().equals(nextFieldName)) {
                JsonDeserializer deser = this._findDeserializer(ctxt, this.baseTypeName());
                Object value = deser.deserialize(jp, ctxt);
                return value;
            }
            return super.deserializeTypedFromObject(jp, ctxt);
        }

        private Object classLoadingFirstLookup(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                return super.deserializeTypedFromObject(jp, ctxt);
            }
            catch (Exception e) {
                JsonDeserializer deser = this._findDeserializer(ctxt, this.baseTypeName());
                Object value = deser.deserialize(jp, ctxt);
                return value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public Object deserializeTypedFromScalar(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            try {
                Object value;
                Thread.currentThread().setContextClassLoader(this._baseType.getRawClass().getClassLoader());
                if (JSONMarshaller.this.classesSet.contains(this._baseType.getRawClass())) {
                    try {
                        Object object = super.deserializeTypedFromScalar(jp, ctxt);
                        return object;
                    }
                    catch (Exception e) {
                        Object value2;
                        JsonDeserializer deser = this._findDeserializer(ctxt, this.baseTypeName());
                        Object object = value2 = deser.deserialize(jp, ctxt);
                        Thread.currentThread().setContextClassLoader(current);
                        return object;
                    }
                }
                JsonDeserializer deser = this._findDeserializer(ctxt, this.baseTypeName());
                Object object = value = deser.deserialize(jp, ctxt);
                return object;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public Object deserializeTypedFromAny(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            try {
                Object value;
                Thread.currentThread().setContextClassLoader(this._baseType.getRawClass().getClassLoader());
                if (JSONMarshaller.this.classesSet.contains(this._baseType.getRawClass())) {
                    try {
                        Object object = super.deserializeTypedFromAny(jp, ctxt);
                        return object;
                    }
                    catch (Exception e) {
                        Object value2;
                        JsonDeserializer deser = this._findDeserializer(ctxt, this.baseTypeName());
                        Object object = value2 = deser.deserialize(jp, ctxt);
                        Thread.currentThread().setContextClassLoader(current);
                        return object;
                    }
                }
                if (this._baseType.isMapLikeType() && jp.getCurrentToken() == JsonToken.START_ARRAY) {
                    Collection values;
                    LinkedHashMap data = new LinkedHashMap();
                    jp.nextToken();
                    if (jp.getCurrentToken() == JsonToken.END_ARRAY) {
                        LinkedHashMap deser = data;
                        return deser;
                    }
                    JsonDeserializer deser = this._findDeserializer(ctxt, LinkedHashMap.class.getName());
                    Map value3 = (Map)deser.deserialize(jp, ctxt);
                    jp.nextToken();
                    if (value3 != null && (values = value3.values()).size() == 2) {
                        Iterator it = values.iterator();
                        data.put(it.next(), it.next());
                        LinkedHashMap linkedHashMap = data;
                        return linkedHashMap;
                    }
                    Map map = value3;
                    return map;
                }
                JsonDeserializer deser = this._findDeserializer(ctxt, this.baseTypeName());
                Object object = value = deser.deserialize(jp, ctxt);
                return object;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
        }

        public TypeDeserializer forProperty(BeanProperty prop) {
            if (prop != null && (this.useForType(prop.getType()) || this.useForType(prop.getType().getContentType()))) {
                return new CustomAsWrapperTypeDeserializer(this, prop);
            }
            return super.forProperty(prop);
        }

        boolean useForType(JavaType t) {
            return JSONMarshaller.this.classesSet.contains(t.getRawClass());
        }
    }

    class CustomObjectDeserializer
    extends UntypedObjectDeserializer {
        private final Pattern VALID_JAVA_IDENTIFIER = Pattern.compile("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
        private static final long serialVersionUID = 7764405880012867708L;
        private Map<String, Class<?>> classes = new HashMap();

        public CustomObjectDeserializer(Set<Class<?>> classes) {
            for (Class<?> c : classes) {
                this.classes.put(c.getSimpleName(), c);
                this.classes.put(c.getName(), c);
            }
        }

        protected Object mapObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.START_OBJECT) {
                t = jp.nextToken();
            }
            if (t != JsonToken.FIELD_NAME) {
                return new LinkedHashMap(4);
            }
            String field1 = jp.getText();
            jp.nextToken();
            if (this.classes.containsKey(field1)) {
                ((JSONContext)JSONMarshaller.this.jsonContext.get()).setStripped(true);
                Object value = JSONMarshaller.this.deserializeObjectMapper.readValue(jp, this.classes.get(field1));
                jp.nextToken();
                return value;
            }
            if (this.isFullyQualifiedClassname(field1)) {
                try {
                    Object value = JSONMarshaller.this.deserializeObjectMapper.readValue(jp, JSONMarshaller.this.classLoader.loadClass(field1));
                    jp.nextToken();
                    return value;
                }
                catch (ClassNotFoundException value) {
                    // empty catch block
                }
            }
            Object value1 = this.deserialize(jp, ctxt);
            if (jp.nextToken() != JsonToken.FIELD_NAME) {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(4);
                result.put(field1, value1);
                return this.wrapCustomObject(result);
            }
            String field2 = jp.getText();
            jp.nextToken();
            Object value2 = this.deserialize(jp, ctxt);
            if (jp.nextToken() != JsonToken.FIELD_NAME) {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(4);
                result.put(field1, value1);
                result.put(field2, value2);
                return this.wrapCustomObject(result);
            }
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put(field1, value1);
            result.put(field2, value2);
            do {
                String fieldName = jp.getText();
                jp.nextToken();
                result.put(fieldName, this.deserialize(jp, ctxt));
            } while (jp.nextToken() != JsonToken.END_OBJECT);
            if (result.containsKey("type") && result.containsKey("componentType") && result.containsKey("element")) {
                JaxbListWrapper wrapper = new JaxbListWrapper();
                wrapper.setType(JaxbListWrapper.JaxbWrapperType.valueOf((String)((String)result.get("type"))));
                wrapper.setComponentType((String)result.get("componentType"));
                wrapper.setElements(this.toArray(result.get("element")));
                try {
                    Object data = null;
                    if (wrapper.getType().equals((Object)JaxbListWrapper.JaxbWrapperType.MAP)) {
                        LinkedHashMap tranformed = new LinkedHashMap();
                        for (Object element : wrapper.getElements()) {
                            Map map = (Map)element;
                            tranformed.put(map.get("key"), map.get("value"));
                        }
                        data = tranformed;
                    } else {
                        data = new JaxbListAdapter().unmarshal(wrapper);
                    }
                    return data;
                }
                catch (Exception data) {}
            } else if (result.containsKey("cond-operator")) {
                String column = (String)result.get("cond-column");
                String op = (String)result.get("cond-operator");
                List condValues = (List)result.get("cond-values");
                return new QueryParam(column, op, condValues);
            }
            return this.wrapCustomObject(result);
        }

        public Object wrapCustomObject(Map<String, Object> result) {
            if (result.containsKey("cond-operator")) {
                String column = (String)result.get("cond-column");
                String op = (String)result.get("cond-operator");
                List condValues = (List)result.get("cond-values");
                return new QueryParam(column, op, condValues);
            }
            return result;
        }

        private Object[] toArray(Object element) {
            if (element != null && element instanceof Collection) {
                return ((Collection)element).toArray();
            }
            return new Object[0];
        }

        private boolean isFullyQualifiedClassname(String classname) {
            if (!classname.contains(".")) {
                return false;
            }
            return this.VALID_JAVA_IDENTIFIER.matcher(classname).matches();
        }
    }

    class WrappingObjectSerializer
    extends JsonSerializer<Object> {
        private ObjectMapper customObjectMapper;
        private ObjectMapper notNullObjectMapper;

        public WrappingObjectSerializer(ObjectMapper customObjectMapper) {
            this.customObjectMapper = customObjectMapper;
            this.notNullObjectMapper = customObjectMapper.copy().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            String className = value.getClass().getName();
            if (value instanceof Collection) {
                String collectionJson = this.writeCollection((Collection)value, JSONMarshaller.this.getMapper(this.customObjectMapper, this.notNullObjectMapper));
                jgen.writeRawValue(collectionJson);
            } else if (value instanceof Map) {
                String mapJson = this.writeMap((Map)value, JSONMarshaller.this.getMapper(this.customObjectMapper, this.notNullObjectMapper));
                jgen.writeRawValue(mapJson);
            } else if (value instanceof Object[] || value.getClass().isArray()) {
                String arrayJson = this.writeArray((Object[])value, JSONMarshaller.this.getMapper(this.customObjectMapper, this.notNullObjectMapper));
                jgen.writeRawValue(arrayJson);
            } else {
                String json = JSONMarshaller.this.getMapper(this.customObjectMapper, this.notNullObjectMapper).writeValueAsString(value);
                if (!(className.startsWith("java.") || className.startsWith("javax.") || json.contains(className))) {
                    json = "{\"" + className + "\":" + json + "}";
                }
                jgen.writeRawValue(json);
            }
        }

        private String writeArray(Object[] value, ObjectMapper customObjectMapper) throws IOException {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            int size = Array.getLength(value);
            for (Object element : value) {
                --size;
                String elementClassName = element.getClass().getName();
                String json = customObjectMapper.writeValueAsString(element);
                if (!(elementClassName.startsWith("java.") || elementClassName.startsWith("javax.") || json.contains(elementClassName))) {
                    json = "{\"" + elementClassName + "\":" + json + "}";
                }
                builder.append(json);
                if (size <= 0) continue;
                builder.append(",");
            }
            builder.append("]");
            return builder.toString();
        }

        private String writeMap(Map value, ObjectMapper customObjectMapper) throws IOException {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            int size = value.size();
            for (Map.Entry entry : value.entrySet()) {
                --size;
                Object key = entry.getKey();
                String keyClassName = key.getClass().getName();
                String json = customObjectMapper.writeValueAsString(key);
                if (!(keyClassName.startsWith("java.") || keyClassName.startsWith("javax.") || json.contains(keyClassName))) {
                    json = "{\"" + keyClassName + "\":" + json + "}";
                }
                Object mValue = entry.getValue();
                String mValueClassName = mValue.getClass().getName();
                String jsonValue = customObjectMapper.writeValueAsString(mValue);
                if (!(mValueClassName.startsWith("java.") || mValueClassName.startsWith("javax.") || json.contains(mValueClassName))) {
                    jsonValue = "{\"" + mValueClassName + "\":" + jsonValue + "}";
                }
                builder.append(json);
                builder.append(" : ");
                builder.append(jsonValue);
                if (size <= 0) continue;
                builder.append(",");
            }
            builder.append("}");
            return builder.toString();
        }

        private String writeCollection(Collection<?> collection, ObjectMapper customObjectMapper) throws IOException {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            int size = collection.size();
            Iterator<?> it = collection.iterator();
            while (it.hasNext()) {
                --size;
                Object element = it.next();
                String elementClassName = element.getClass().getName();
                String json = customObjectMapper.writeValueAsString(element);
                if (!(elementClassName.startsWith("java.") || elementClassName.startsWith("javax.") || json.contains(elementClassName))) {
                    json = "{\"" + elementClassName + "\":" + json + "}";
                }
                builder.append(json);
                if (size <= 0) continue;
                builder.append(",");
            }
            builder.append("]");
            return builder.toString();
        }
    }

    class CustomObjectSerializer
    extends JsonSerializer<Object> {
        private ObjectMapper customObjectMapper;
        private ObjectMapper notNullObjectMapper;

        public CustomObjectSerializer(ObjectMapper customObjectMapper) {
            this.customObjectMapper = customObjectMapper;
            this.notNullObjectMapper = customObjectMapper.copy().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeRawValue(JSONMarshaller.this.getMapper(this.customObjectMapper, this.notNullObjectMapper).writeValueAsString(value));
        }
    }

    public static class PassThruMapStringObjectDeserializer
    extends JsonDeserializer<Map<String, Object>> {
        public Map<String, Object> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            HashMap result = (HashMap)p.readValueAs(HashMap.class);
            return result;
        }
    }

    public static class PassThruSerializer
    extends JsonSerializer<Object> {
        public void serialize(Object p0, JsonGenerator p1, SerializerProvider p2) throws IOException, JsonProcessingException {
            p1.writeObject(p0);
        }
    }

    class ExtendedJaxbAnnotationIntrospector
    extends JaxbAnnotationIntrospector {
        private List<NamedType> customClasses;
        private ObjectMapper customObjectMapper;

        public ExtendedJaxbAnnotationIntrospector(List<NamedType> customClasses, ObjectMapper anotherCustomObjectMapper) {
            this.customClasses = customClasses;
            this.customObjectMapper = anotherCustomObjectMapper;
        }

        public List<NamedType> findSubtypes(Annotated a) {
            List base = super.findSubtypes(a);
            ArrayList<NamedType> complete = new ArrayList<NamedType>();
            if (base != null) {
                complete.addAll(base);
            }
            if (this.customClasses != null) {
                complete.addAll(this.customClasses);
            }
            return complete;
        }

        public JsonSerializer<?> findSerializer(Annotated am) {
            XmlJavaTypeAdapter adapterInfo = this.findAnnotation(XmlJavaTypeAdapter.class, am, true, false, false);
            if (adapterInfo != null && adapterInfo.value().isAssignableFrom(JaxbUnknownAdapter.class)) {
                if (this.findAnnotation(JsonSerialize.class, am, true, false, false) != null) {
                    return super.findSerializer(am);
                }
                return new WrappingObjectSerializer(this.customObjectMapper);
            }
            return super.findSerializer(am);
        }

        public Object findSerializationConverter(Annotated a) {
            Class serType = this._rawSerializationType(a);
            XmlAdapter<Object, Object> adapter = this.findAdapter(a, true, serType);
            if (adapter != null) {
                return this._converter(adapter, true);
            }
            return null;
        }

        private <A extends Annotation> A findAnnotation(Class<A> annotationClass, Annotated annotated, boolean includePackage, boolean includeClass, boolean includeSuperclasses) {
            Annotation annotation = annotated.getAnnotation(annotationClass);
            if (annotation != null) {
                return (A)annotation;
            }
            Class memberClass = null;
            if (annotated instanceof AnnotatedParameter) {
                memberClass = ((AnnotatedParameter)annotated).getDeclaringClass();
            } else {
                AnnotatedElement pkg = annotated.getAnnotated();
                if (pkg instanceof Member) {
                    memberClass = ((Member)((Object)pkg)).getDeclaringClass();
                    if (includeClass && (annotation = memberClass.getAnnotation(annotationClass)) != null) {
                        return (A)annotation;
                    }
                } else {
                    if (!(pkg instanceof Class)) {
                        throw new IllegalStateException("Unsupported annotated member: " + annotated.getClass().getName());
                    }
                    memberClass = (Class)pkg;
                }
            }
            if (memberClass != null) {
                Package pkg2;
                if (includeSuperclasses) {
                    for (Class<?> pkg1 = memberClass.getSuperclass(); pkg1 != null && pkg1 != Object.class; pkg1 = pkg1.getSuperclass()) {
                        annotation = pkg1.getAnnotation(annotationClass);
                        if (annotation == null) continue;
                        return (A)annotation;
                    }
                }
                if (includePackage && (pkg2 = memberClass.getPackage()) != null) {
                    return memberClass.getPackage().getAnnotation(annotationClass);
                }
            }
            return null;
        }

        private XmlAdapter<Object, Object> findAdapter(Annotated am, boolean forSerialization, Class<?> type) {
            XmlAdapter<Object, Object> adapter;
            if (am instanceof AnnotatedClass) {
                return this.findAdapterForClass((AnnotatedClass)am, forSerialization);
            }
            XmlJavaTypeAdapter adapterInfo = this.findAnnotation(XmlJavaTypeAdapter.class, am, true, false, false);
            if (adapterInfo != null && (adapter = this.checkAdapter(adapterInfo, type, forSerialization)) != null) {
                return adapter;
            }
            XmlJavaTypeAdapters adapters = this.findAnnotation(XmlJavaTypeAdapters.class, am, true, false, false);
            if (adapters != null) {
                for (XmlJavaTypeAdapter info : adapters.value()) {
                    XmlAdapter<Object, Object> adapter2 = this.checkAdapter(info, type, forSerialization);
                    if (adapter2 == null) continue;
                    return adapter2;
                }
            }
            return null;
        }

        private final XmlAdapter<Object, Object> checkAdapter(XmlJavaTypeAdapter adapterInfo, Class<?> typeNeeded, boolean forSerialization) {
            Class adaptedType = adapterInfo.type();
            if (adapterInfo.value().isAssignableFrom(JaxbUnknownAdapter.class)) {
                return null;
            }
            if (adaptedType == XmlJavaTypeAdapter.DEFAULT.class) {
                JavaType[] params = this._typeFactory.findTypeParameters(adapterInfo.value(), XmlAdapter.class);
                adaptedType = params[1].getRawClass();
            }
            if (adaptedType.isAssignableFrom(typeNeeded)) {
                Class cls = adapterInfo.value();
                return (XmlAdapter)ClassUtil.createInstance((Class)cls, (boolean)true);
            }
            return null;
        }

        private XmlAdapter<Object, Object> findAdapterForClass(AnnotatedClass ac, boolean forSerialization) {
            XmlJavaTypeAdapter adapterInfo = ac.getAnnotated().getAnnotation(XmlJavaTypeAdapter.class);
            if (adapterInfo != null) {
                Class cls = adapterInfo.value();
                return (XmlAdapter)ClassUtil.createInstance((Class)cls, (boolean)true);
            }
            return null;
        }
    }

    public static class JSONContext {
        private boolean stripped;
        private boolean wrap;
        private boolean writeNull;

        public JSONContext() {
            this.reset();
        }

        public void reset() {
            this.stripped = false;
            this.wrap = false;
            this.writeNull = true;
        }

        public boolean isStripped() {
            return this.stripped;
        }

        public void setStripped(boolean stripped) {
            this.stripped = stripped;
        }

        public void setWrap(boolean wrap) {
            this.wrap = wrap;
        }

        public boolean isWrap() {
            return this.wrap;
        }

        public boolean isWriteNull() {
            return this.writeNull;
        }

        public void setWriteNull(boolean writeNull) {
            this.writeNull = writeNull;
        }
    }
}

