/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.api.model.runtime;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.model.runtime.ContainerKey;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="container-details")
public class Container
extends ContainerKey {
    @XmlElement(name="sever-instance-id")
    private String serverInstanceId;
    @XmlElement(name="container-release-id")
    private ReleaseId resolvedReleasedId;
    @XmlElement(name="messages")
    private Collection<Message> messages = new ArrayList<Message>();
    @XmlElement(name="status")
    private KieContainerStatus status = KieContainerStatus.STOPPED;

    public Container() {
    }

    public Container(String containerSpecId, String containerName, ServerInstanceKey serverInstanceKey, Collection<Message> messages, ReleaseId resolvedReleasedId, String url) {
        super(containerSpecId, containerName, serverInstanceKey);
        this.serverInstanceId = serverInstanceKey.getServerInstanceId();
        this.messages.addAll(messages);
        this.resolvedReleasedId = resolvedReleasedId;
        this.setUrl(url);
    }

    public String getServerInstanceId() {
        return this.serverInstanceId;
    }

    public Collection<Message> getMessages() {
        if (this.messages == null) {
            this.messages = new ArrayList<Message>();
        }
        return this.messages;
    }

    public ReleaseId getResolvedReleasedId() {
        return this.resolvedReleasedId;
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
    }

    public void setMessages(Collection<Message> messages) {
        this.messages = messages;
    }

    public void setResolvedReleasedId(ReleaseId resolvedReleasedId) {
        this.resolvedReleasedId = resolvedReleasedId;
    }

    public void addMessage(Message message) {
        this.messages.add(message);
    }

    public ServerInstanceKey getServerInstanceKey() {
        return new ServerInstanceKey(this.getServerTemplateId(), this.serverInstanceId, this.serverInstanceId, this.getUrl());
    }

    public KieContainerStatus getStatus() {
        return this.status;
    }

    public void setStatus(KieContainerStatus status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Container)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Container container = (Container)o;
        if (this.resolvedReleasedId != null ? !this.resolvedReleasedId.equals((Object)container.resolvedReleasedId) : container.resolvedReleasedId != null) {
            return false;
        }
        return !(this.serverInstanceId != null ? !this.serverInstanceId.equals(container.serverInstanceId) : container.serverInstanceId != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.serverInstanceId != null ? this.serverInstanceId.hashCode() : 0);
        result = 31 * result + (this.resolvedReleasedId != null ? this.resolvedReleasedId.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Container{serverInstanceId='" + this.serverInstanceId + '\'' + ", resolvedReleasedId=" + this.resolvedReleasedId + ", messages=" + this.messages + ", status=" + this.status + "} " + super.toString();
    }
}

