/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.IOException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.uberfire.java.nio.fs.jgit.util.Git;

public class GetFirstCommit {
    private final Git git;
    private final Ref ref;

    public GetFirstCommit(Git git, String branchName) {
        this(git, git.getRef(branchName));
    }

    public GetFirstCommit(Git git, Ref ref) {
        this.git = git;
        this.ref = ref;
    }

    public RevCommit execute() throws IOException {
        RevCommit revCommit;
        RevWalk rw = new RevWalk(this.git.getRepository());
        try {
            RevCommit root = rw.parseCommit((AnyObjectId)this.ref.getObjectId());
            rw.sort(RevSort.REVERSE);
            rw.markStart(root);
            revCommit = rw.next();
        }
        catch (Throwable throwable) {
            try {
                try {
                    rw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        rw.close();
        return revCommit;
    }
}

