/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.events;

import org.drools.core.process.instance.WorkItem;
import org.drools.core.process.instance.WorkItemManager;
import org.jbpm.services.task.events.DefaultTaskEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.model.Task;
import org.kie.internal.runtime.manager.InternalRuntimeEngine;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class WorkflowBridgeTaskLifeCycleEventListener
extends DefaultTaskEventListener {
    private RuntimeManager runtimeManager;

    public WorkflowBridgeTaskLifeCycleEventListener(RuntimeManager runtimeManager) {
        this.runtimeManager = runtimeManager;
    }

    @Override
    public void afterTaskSuspendedEvent(TaskEvent event) {
        this.executeWork(event.getTask(), "humanTaskNodeInstance:suspended");
    }

    @Override
    public void afterTaskResumedEvent(TaskEvent event) {
        this.executeWork(event.getTask(), "humanTaskNodeInstance:activated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWork(Task task, String signal) {
        Long processInstanceId = task.getTaskData().getProcessInstanceId();
        InternalRuntimeEngine runtimeEngine = (InternalRuntimeEngine)this.runtimeManager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        try {
            KieSession kieSession = runtimeEngine.getKieSession();
            WorkItem workItem = ((WorkItemManager)kieSession.getWorkItemManager()).getWorkItem(task.getTaskData().getWorkItemId());
            kieSession.signalEvent(signal, (Object)workItem, processInstanceId.longValue());
        }
        finally {
            this.runtimeManager.disposeRuntimeEngine((RuntimeEngine)runtimeEngine);
        }
    }
}

