/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.security;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jbpm.services.task.identity.adapter.UserGroupAdapter;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;

public class ElytronUserGroupAdapter
implements UserGroupAdapter {
    public List<String> getGroupsForUser(String userId) {
        SecurityIdentity identity;
        Optional<SecurityIdentity> identityOptional = this.getCurrentSecurityIdentity();
        if (identityOptional.isPresent() && (identity = identityOptional.get()).getPrincipal().getName().equals(userId)) {
            return StreamSupport.stream(identity.getRoles().spliterator(), false).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Optional<SecurityIdentity> getCurrentSecurityIdentity() {
        SecurityDomain securityDomain = SecurityDomain.getCurrent();
        if (securityDomain == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(securityDomain.getCurrentSecurityIdentity());
    }
}

