/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.abstractrecords;

import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ParticipantStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.abstractrecords.CadaverRecord;
import com.arjuna.ats.internal.arjuna.abstractrecords.StateManagerFriend;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import java.io.IOException;
import java.io.PrintWriter;

public class DisposeRecord
extends CadaverRecord {
    private Uid objectUid;
    private String typeName;

    public DisposeRecord(ParticipantStore participantStore, StateManager sm) {
        super(null, participantStore, sm);
        this.targetParticipantStore = participantStore;
        if (sm != null) {
            this.objectUid = sm.get_uid();
            this.typeName = sm.type();
        } else {
            this.objectUid = Uid.nullUid();
            this.typeName = null;
        }
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("DisposeRecord::DisposeRecord(" + participantStore + ", " + this.objectUid + ")"));
        }
    }

    @Override
    public boolean propagateOnAbort() {
        return false;
    }

    @Override
    public int typeIs() {
        return 211;
    }

    @Override
    public int nestedAbort() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("DisposeRecord::nestedAbort() for " + this.order()));
        }
        return 7;
    }

    @Override
    public int nestedCommit() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("DisposeRecord::nestedCommit() for " + this.order()));
        }
        return 7;
    }

    @Override
    public int nestedPrepare() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("DisposeRecord::nestedPrepare() for " + this.order()));
        }
        if (this.targetParticipantStore != null && this.objectUid.notEquals(Uid.nullUid())) {
            return 0;
        }
        return 1;
    }

    @Override
    public int topLevelAbort() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("DisposeRecord::topLevelAbort() for " + this.order()));
        }
        return 7;
    }

    @Override
    public int topLevelCommit() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("DisposeRecord::topLevelCommit() for " + this.order()));
        }
        if (this.targetParticipantStore != null && this.objectUid.notEquals(Uid.nullUid())) {
            try {
                if (this.targetParticipantStore.remove_committed(this.objectUid, this.typeName)) {
                    if (this.objectAddr != null) {
                        StateManagerFriend.destroyed(this.objectAddr);
                    }
                    return 7;
                }
            }
            catch (Throwable e) {
                tsLogger.i18NLogger.warn_DisposeRecord_5(e);
            }
        }
        return 8;
    }

    @Override
    public int topLevelPrepare() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("DisposeRecord::topLevelPrepare() for " + this.order()));
        }
        if (this.targetParticipantStore != null && this.objectUid.notEquals(Uid.nullUid())) {
            this.shadowForced();
            return 0;
        }
        return 1;
    }

    @Override
    public void print(PrintWriter strm) {
        strm.println("Dispose for:");
        super.print(strm);
    }

    @Override
    public boolean doSave() {
        return true;
    }

    @Override
    public boolean save_state(OutputObjectState os, int ot) {
        boolean res = true;
        if (this.targetParticipantStore != null && this.objectUid.notEquals(Uid.nullUid())) {
            try {
                UidHelper.packInto(this.objectUid, os);
                os.packString(this.typeName);
                res = res && super.save_state(os, ot);
            }
            catch (IOException e) {
                tsLogger.i18NLogger.warn_DisposeRecord_2();
                res = false;
            }
        } else {
            tsLogger.i18NLogger.warn_DisposeRecord_3();
            res = false;
        }
        return res;
    }

    @Override
    public boolean restore_state(InputObjectState os, int ot) {
        boolean res = true;
        try {
            this.objectUid = UidHelper.unpackFrom(os);
            this.typeName = os.unpackString();
            res = res && super.restore_state(os, ot);
        }
        catch (Exception e) {
            res = false;
        }
        return res;
    }

    @Override
    public String type() {
        return "/StateManager/AbstractRecord/RecoveryRecord/PersistenceRecord/CadaverRecord/DisposeRecord";
    }

    @Override
    public boolean shouldAdd(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldReplace(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    public DisposeRecord() {
        this.objectUid = new Uid(Uid.nullUid());
        this.typeName = null;
        this.targetParticipantStore = null;
    }
}

