/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.compiler.dto;

import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.compiler.api.dto.AbstractSpecificCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.models.regression.model.enums.REGRESSION_NORMALIZATION_METHOD;

public class RegressionCompilationDTO
extends AbstractSpecificCompilationDTO<RegressionModel> {
    private static final long serialVersionUID = 640809755551594031L;
    private final List<RegressionTable> regressionTables;
    private final RegressionModel.NormalizationMethod defaultNormalizationMethod;
    private final RegressionModel.NormalizationMethod modelNormalizationMethod;

    private RegressionCompilationDTO(CompilationDTO<RegressionModel> source, List<RegressionTable> regressionTables, RegressionModel.NormalizationMethod defaultNormalizationMethod) {
        super(source);
        this.regressionTables = regressionTables;
        this.defaultNormalizationMethod = defaultNormalizationMethod;
        this.modelNormalizationMethod = ((RegressionModel)source.getModel()).getNormalizationMethod();
    }

    private RegressionCompilationDTO(CompilationDTO<RegressionModel> source) {
        this(source, ((RegressionModel)source.getModel()).getRegressionTables(), ((RegressionModel)source.getModel()).getNormalizationMethod());
    }

    public static RegressionCompilationDTO fromCompilationDTORegressionTablesAndNormalizationMethod(CompilationDTO<RegressionModel> source, List<RegressionTable> regressionTables, RegressionModel.NormalizationMethod defaultNormalizationMethod) {
        return new RegressionCompilationDTO(source, regressionTables, defaultNormalizationMethod);
    }

    public static RegressionCompilationDTO fromCompilationDTO(CompilationDTO<RegressionModel> source) {
        return new RegressionCompilationDTO(source);
    }

    public List<RegressionTable> getRegressionTables() {
        return this.regressionTables;
    }

    public RegressionModel.NormalizationMethod getDefaultNormalizationMethod() {
        return this.defaultNormalizationMethod;
    }

    public REGRESSION_NORMALIZATION_METHOD getDefaultREGRESSION_NORMALIZATION_METHOD() {
        return REGRESSION_NORMALIZATION_METHOD.byName((String)this.defaultNormalizationMethod.value());
    }

    public RegressionModel.NormalizationMethod getModelNormalizationMethod() {
        return this.modelNormalizationMethod;
    }

    public OP_TYPE getOP_TYPE() {
        OpType opType = this.getOpType();
        return opType != null ? OP_TYPE.byName((String)opType.value()) : null;
    }

    public boolean isBinary(int tableSize) {
        return Objects.equals(OpType.CATEGORICAL, this.getOpType()) && tableSize == 2;
    }

    public boolean isRegression() {
        DataField targetDataField = this.getTargetDataField();
        OpType targetOpType = targetDataField != null ? targetDataField.getOpType() : null;
        return Objects.equals(MiningFunction.REGRESSION, this.getMiningFunction()) && (targetDataField == null || Objects.equals(OpType.CONTINUOUS, targetOpType));
    }
}

