/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.server.api.exception.KieServicesException;
import org.kie.server.api.model.taskassigning.LocalDateTimeValue;
import org.kie.server.api.model.taskassigning.PlanningExecutionResult;
import org.kie.server.api.model.taskassigning.PlanningItemList;
import org.kie.server.api.model.taskassigning.TaskDataList;
import org.kie.server.api.model.taskassigning.TaskInputVariablesReadMode;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.TaskAssigningRuntimeClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class TaskAssigningRuntimeClientImpl
extends AbstractKieServicesClientImpl
implements TaskAssigningRuntimeClient {
    public TaskAssigningRuntimeClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public TaskAssigningRuntimeClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public PlanningExecutionResult executePlanning(PlanningItemList planningItemList, String userId) {
        if (this.config.isRest()) {
            String uri = "taskassigning/runtime/executeplanning?user=" + userId;
            return this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)uri, Collections.emptyMap()), planningItemList, PlanningExecutionResult.class);
        }
        throw new KieServicesException("JMS protocol is not implemented for this service.");
    }

    @Override
    public TaskDataList findTasks(Long fromTaskId, List<String> status, LocalDateTime fromLastModificationDate, Integer page, Integer pageSize, TaskInputVariablesReadMode inputVariablesReadMode) {
        Map<String, Object> params = TaskQueryParamsBuilder.builder().fromTaskId(fromTaskId).status(status).fromLastModificationDate(fromLastModificationDate).page(page).pageSize(pageSize).taskInputVariablesReadMode(inputVariablesReadMode).build();
        return this.executeFindTasksQuery(params);
    }

    @Override
    public TaskDataList findTasks(Long fromTaskId, List<String> status, LocalDateTime fromLastModificationDate, Integer page, Integer pageSize) {
        return this.findTasks(fromTaskId, status, fromLastModificationDate, page, pageSize, TaskInputVariablesReadMode.DONT_READ);
    }

    private TaskDataList executeFindTasksQuery(Map<String, Object> params) {
        if (this.config.isRest()) {
            String uri = "taskassigning/runtime/queries/taskdata";
            return this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"taskassigning/runtime/queries/taskdata", Collections.emptyMap()), params, TaskDataList.class);
        }
        throw new KieServicesException("JMS protocol is not implemented for this service.");
    }

    public KieServicesConfiguration getConfig() {
        return this.config;
    }

    static class TaskQueryParamsBuilder {
        private Map<String, Object> params = new HashMap<String, Object>();

        private TaskQueryParamsBuilder() {
        }

        public static TaskQueryParamsBuilder builder() {
            return new TaskQueryParamsBuilder();
        }

        public TaskQueryParamsBuilder fromTaskId(Long taskId) {
            this.params.put("fromTaskId", taskId);
            return this;
        }

        public TaskQueryParamsBuilder status(List<String> status) {
            this.params.put("status", status);
            return this;
        }

        public TaskQueryParamsBuilder fromLastModificationDate(LocalDateTime lastModificationDate) {
            this.params.put("fromLastModificationDate", LocalDateTimeValue.from((LocalDateTime)lastModificationDate));
            return this;
        }

        public TaskQueryParamsBuilder page(Integer page) {
            this.params.put("page", page);
            return this;
        }

        public TaskQueryParamsBuilder pageSize(Integer pageSize) {
            this.params.put("pageSize", pageSize);
            return this;
        }

        public TaskQueryParamsBuilder taskInputVariablesReadMode(TaskInputVariablesReadMode inputVariablesReadMode) {
            if (inputVariablesReadMode != null) {
                this.params.put("inputVariablesMode", inputVariablesReadMode.name());
            }
            return this;
        }

        public Map<String, Object> build() {
            return this.params;
        }
    }
}

