/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.dmn;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.text.MessageFormat;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.dmn.ModelEvaluatorServiceBase;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="DMN models")
@Path(value="server/containers/{containerId}/dmn")
public class ModelEvaluatorResource {
    public static final Logger LOG = LoggerFactory.getLogger(ModelEvaluatorResource.class);
    private ModelEvaluatorServiceBase modelEvaluatorService;
    private MarshallerHelper marshallerHelper;

    public ModelEvaluatorResource() {
    }

    public ModelEvaluatorResource(ModelEvaluatorServiceBase modelEvaluatorService) {
        this.modelEvaluatorService = modelEvaluatorService;
        this.marshallerHelper = new MarshallerHelper(modelEvaluatorService.getKieServerRegistry());
    }

    @ApiOperation(value="Retrieves DMN model for given container", response=ServiceResponse.class, code=200, notes="Please reference the documentation for usage of the KIE Server REST API for DMN (doc ref: \"Executing a DMN service using the KIE Server REST API\" section in the Getting started with decision services).")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Models or container not found"), @ApiResponse(code=200, response=String.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"type\" : \"SUCCESS\",\n  \"msg\" : \"OK models successfully retrieved from container 'Traffic-Violation_1.0.0-SNAPSHOT'\",\n  \"result\" : {\n    \"dmn-model-info-list\" : {\n      \"models\" : [ {\n        \"model-namespace\" : \"https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8\",\n        \"model-name\" : \"Traffic Violation\",\n        \"model-id\" : \"_2CD7D1AA-BD84-4B43-AD21-B0342ADE655A\",\n        \"decisions\" : [ {\n          \"decision-id\" : \"_23428EE8-DC8B-4067-8E67-9D7C53EC975F\",\n          \"decision-name\" : \"Fine\"\n        }, {\n          \"decision-id\" : \"_B5EEE2B1-915C-44DC-BE43-C244DC066FD8\",\n          \"decision-name\" : \"Should the driver be suspended?\"\n        } ],\n        \"inputs\" : [ {\n          \"inputdata-id\" : \"_CEB959CD-3638-4A87-93BA-03CD0FB63AE3\",\n          \"inputdata-name\" : \"Violation\",\n          \"inputdata-typeRef\" : {\n            \"namespace-uri\" : \"https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8\",\n            \"local-part\" : \"tViolation\",\n            \"prefix\" : \"\"\n          }\n        }, {\n          \"inputdata-id\" : \"_B0E810E6-7596-430A-B5CF-67CE16863B6C\",\n          \"inputdata-name\" : \"Driver\",\n          \"inputdata-typeRef\" : {\n            \"namespace-uri\" : \"https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8\",\n            \"local-part\" : \"tDriver\",\n            \"prefix\" : \"\"\n          }\n        } ],\n        \"itemDefinitions\" : [ {\n          \"itemdefinition-id\" : \"_13C7EFD8-B85C-43BF-94D3-14FABE39A4A0\",\n          \"itemdefinition-name\" : \"tDriver\",\n          \"itemdefinition-typeRef\" : null,\n          \"itemdefinition-itemComponent\" : [ {\n            \"itemdefinition-id\" : \"_EC11744C-4160-4549-9610-2C757F40DFE8\",\n            \"itemdefinition-name\" : \"Name\",\n            \"itemdefinition-typeRef\" : {\n              \"namespace-uri\" : \"https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8\",\n              \"local-part\" : \"string\",\n              \"prefix\" : \"\"\n            },\n            \"itemdefinition-itemComponent\" : [ ],\n            \"itemdefinition-isCollection\" : false\n          }, {\n            \"itemdefinition-id\" : \"_E95BE3DB-4A51-4658-A166-02493EAAC9D2\",\n            \"itemdefinition-name\" : \"Age\",\n            \"itemdefinition-typeRef\" : {\n              \"namespace-uri\" : \"https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8\",\n              \"local-part\" : \"number\",\n              \"prefix\" : \"\"\n            },\n            \"itemdefinition-itemComponent\" : [ ],\n            \"itemdefinition-isCollection\" : false\n          }, {\n            \"itemdefinition-id\" : \"_7B3023E2-BC44-4BF3-BF7E-773C240FB9AD\",\n            \"itemdefinition-name\" : \"State\",\n            \"itemdefinition-typeRef\" : {\n              \"namespace-uri\" : \"https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8\",\n              \"local-part\" : \"string\",\n              \"prefix\" : \"\"\n            },\n            \"itemdefinition-itemComponent\" : [ ],\n            \"itemdefinition-isCollection\" : false\n          }, {\n            \"itemdefinition-id\" : \"_3D4B49DD-700C-4925-99A7-3B2B873F7800\",\n            \"itemdefinition-name\" : \"City\",\n            \"itemdefinition-typeRef\" : {\n              \"namespace-uri\" : \"https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8\",\n              \"local-part\" : \"string\",\n              \"prefix\" : \"\"\n            },\n            \"itemdefinition-itemComponent\" : [ ],\n            \"itemdefinition-isCollection\" : false\n          }, {\n            \"itemdefinition-id\" : \"_B37C49E8-B0D9-4B20-9DC6-D655BB1CA7B1\",\n            \"itemdefinition-name\" : \"Points\",\n            \"itemdefinition-typeRef\" : {\n              \"namespace-uri\" : \"https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8\",\n              \"local-part\" : \"number\",\n              \"prefix\" : \"\"\n            },\n            \"itemdefinition-itemComponent\" : [ ],\n            \"itemdefinition-isCollection\" : false\n          } ],\n          \"itemdefinition-isCollection\" : false\n        }, {\n          \"itemdefinition-id\" : \"_A4077C7E-B57A-4DEE-9C65-7769636316F3\",\n          \"itemdefinition-name\" : \"tFine\",\n          \"itemdefinition-typeRef\" : null,\n          \"itemdefinition-itemComponent\" : [ {\n            \"itemdefinition-id\" : \"_79B152A8-DE83-4001-B88B-52DFF0D73B2D\",\n            \"itemdefinition-name\" : \"Amount\",\n            \"itemdefinition-typeRef\" : {\n              \"namespace-uri\" : \"https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8\",\n              \"local-part\" : \"number\",\n              \"prefix\" : \"\"\n            },\n            \"itemdefinition-itemComponent\" : [ ],\n            \"itemdefinition-isCollection\" : false\n          }, {\n            \"itemdefinition-id\" : \"_D7CB5F9C-9D55-48C2-83EE-D47045EC90D0\",\n            \"itemdefinition-name\" : \"Points\",\n            \"itemdefinition-typeRef\" : {\n              \"namespace-uri\" : \"https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8\",\n              \"local-part\" : \"number\",\n              \"prefix\" : \"\"\n            },\n            \"itemdefinition-itemComponent\" : [ ],\n            \"itemdefinition-isCollection\" : false\n          } ],\n          \"itemdefinition-isCollection\" : false\n        }, {\n          \"itemdefinition-id\" : \"_9C758F4A-7D72-4D0F-B63F-2F5B8405980E\",\n          \"itemdefinition-name\" : \"tViolation\",\n          \"itemdefinition-typeRef\" : null,\n          \"itemdefinition-itemComponent\" : [ {\n            \"itemdefinition-id\" : \"_0B6FF1E2-ACE9-4FB3-876B-5BB30B88009B\",\n            \"itemdefinition-name\" : \"Code\",\n            \"itemdefinition-typeRef\" : {\n              \"namespace-uri\" : \"https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8\",\n              \"local-part\" : \"string\",\n              \"prefix\" : \"\"\n            },\n            \"itemdefinition-itemComponent\" : [ ],\n            \"itemdefinition-isCollection\" : false\n          }, {\n            \"itemdefinition-id\" : \"_27A5DA18-3CA7-4C06-81B7-CF7F2F050E29\",\n            \"itemdefinition-name\" : \"Date\",\n            \"itemdefinition-typeRef\" : {\n              \"namespace-uri\" : \"https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8\",\n              \"local-part\" : \"date\",\n              \"prefix\" : \"\"\n            },\n            \"itemdefinition-itemComponent\" : [ ],\n            \"itemdefinition-isCollection\" : false\n          }, {\n            \"itemdefinition-id\" : \"_8961969A-8A80-4F12-B568-346920C0F038\",\n            \"itemdefinition-name\" : \"Type\",\n            \"itemdefinition-typeRef\" : {\n              \"namespace-uri\" : \"https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8\",\n              \"local-part\" : \"string\",\n              \"prefix\" : \"\"\n            },\n            \"itemdefinition-itemComponent\" : [ ],\n            \"itemdefinition-isCollection\" : false\n          }, {\n            \"itemdefinition-id\" : \"_7450F12A-3E95-4D5E-8DCE-2CB1FAC2BDD4\",\n            \"itemdefinition-name\" : \"Speed Limit\",\n            \"itemdefinition-typeRef\" : {\n              \"namespace-uri\" : \"https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8\",\n              \"local-part\" : \"number\",\n              \"prefix\" : \"\"\n            },\n            \"itemdefinition-itemComponent\" : [ ],\n            \"itemdefinition-isCollection\" : false\n          }, {\n            \"itemdefinition-id\" : \"_0A9A6F26-6C14-414D-A9BF-765E5850429A\",\n            \"itemdefinition-name\" : \"Actual Speed\",\n            \"itemdefinition-typeRef\" : {\n              \"namespace-uri\" : \"https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8\",\n              \"local-part\" : \"number\",\n              \"prefix\" : \"\"\n            },\n            \"itemdefinition-itemComponent\" : [ ],\n            \"itemdefinition-isCollection\" : false\n          } ],\n          \"itemdefinition-isCollection\" : false\n        } ],\n        \"decisionServices\" : [ ]\n      } ]\n    }\n  }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<response type=\"SUCCESS\" msg=\"Ok models successfully retrieved from container 'traffic-violation_1.0.0-SNAPSHOT'\">\n    <dmn-model-info-list>\n        <model>\n            <model-namespace>https://github.com/kiegroup/drools/kie-dmn/_60b01f4d-e407-43f7-848e-258723b5fac8</model-namespace>\n            <model-name>Traffic Violation</model-name>\n            <model-id>_2CD7D1AA-BD84-4B43-AD21-B0342ADE655A</model-id>\n            <decisions>\n                <dmn-decision-info>\n                    <decision-id>_23428EE8-DC8B-4067-8E67-9D7C53EC975F</decision-id>\n                    <decision-name>Fine</decision-name>\n                </dmn-decision-info>\n                <dmn-decision-info>\n                    <decision-id>_B5EEE2B1-915C-44DC-BE43-C244DC066FD8</decision-id>\n                    <decision-name>Should the driver be suspended?</decision-name>\n                </dmn-decision-info>\n            </decisions>\n            <inputs>\n                <dmn-inputdata-info>\n                    <inputdata-id>_CEB959CD-3638-4A87-93BA-03CD0FB63AE3</inputdata-id>\n                    <inputdata-name>Violation</inputdata-name>\n                    <inputdata-typeref>\n                        <namespace-uri>https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8</namespace-uri>\n                        <local-part>tViolation</local-part>\n                        <prefix></prefix>\n                    </inputdata-typeref>\n                </dmn-inputdata-info>\n                <dmn-inputdata-info>\n                    <inputdata-id>_B0E810E6-7596-430A-B5CF-67CE16863B6C</inputdata-id>\n                    <inputdata-name>Driver</inputdata-name>\n                    <inputdata-typeref>\n                        <namespace-uri>https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8</namespace-uri>\n                        <local-part>tDriver</local-part>\n                        <prefix></prefix>\n                    </inputdata-typeref>\n                </dmn-inputdata-info>\n            </inputs>\n            <itemdefinitions>\n                <dmn-itemdefinition-info>\n                    <itemdefinition-id>_9C758F4A-7D72-4D0F-B63F-2F5B8405980E</itemdefinition-id>\n                    <itemdefinition-name>tViolation</itemdefinition-name>\n                    <itemdefinition-itemcomponent>\n                        <dmn-itemdefinition-info>\n                            <itemdefinition-id>_0B6FF1E2-ACE9-4FB3-876B-5BB30B88009B</itemdefinition-id>\n                            <itemdefinition-name>Code</itemdefinition-name>\n                            <itemdefinition-typeref>\n                                <namespace-uri>https://github.com/kiegroup/drools/kie-dmn/_60b01f4d-e407-43f7-848e-258723b5fac8</namespace-uri>\n                                <local-part>string</local-part>\n                                <prefix></prefix>\n                            </itemdefinition-typeref>\n                            <itemdefinition-itemcomponent/>\n                            <itemdefinition-iscollection>false</itemdefinition-iscollection>\n                        </dmn-itemdefinition-info>\n                        <dmn-itemdefinition-info>\n                            <itemdefinition-id>_27A5DA18-3CA7-4C06-81B7-CF7F2F050E29</itemdefinition-id>\n                            <itemdefinition-name>date</itemdefinition-name>\n                            <itemdefinition-typeref>\n                                <namespace-uri>https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8</namespace-uri>\n                                <local-part>date</local-part>\n                                <prefix></prefix>\n                            </itemdefinition-typeref>\n                            <itemdefinition-itemcomponent/>\n                            <itemdefinition-iscollection>false</itemdefinition-iscollection>\n                        </dmn-itemdefinition-info>\n                        <dmn-itemdefinition-info>\n                            <itemdefinition-id>_8961969A-8A80-4F12-B568-346920C0F038</itemdefinition-id>\n                            <itemdefinition-name>type</itemdefinition-name>\n                            <itemdefinition-typeref>\n                                <namespace-uri>https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8</namespace-uri>\n                                <local-part>string</local-part>\n                                <prefix></prefix>\n                            </itemdefinition-typeref>\n                            <itemdefinition-itemcomponent/>\n                            <itemdefinition-iscollection>false</itemdefinition-iscollection>\n                        </dmn-itemdefinition-info>\n                        <dmn-itemdefinition-info>\n                            <itemdefinition-id>_7450F12A-3E95-4D5E-8DCE-2CB1FAC2BDD4</itemdefinition-id>\n                            <itemdefinition-name>speed limit</itemdefinition-name>\n                            <itemdefinition-typeref>\n                                <namespace-uri>https://github.com/kiegroup/drools/kie-dmn/_60b01f4d-e407-43f7-848e-258723b5fac8</namespace-uri>\n                                <local-part>number</local-part>\n                                <prefix></prefix>\n                            </itemdefinition-typeref>\n                            <itemdefinition-itemcomponent/>\n                            <itemdefinition-iscollection>false</itemdefinition-iscollection>\n                        </dmn-itemdefinition-info>\n                        <dmn-itemdefinition-info>\n                            <itemdefinition-id>_0A9A6F26-6C14-414D-A9BF-765E5850429A</itemdefinition-id>\n                            <itemdefinition-name>Actual Speed</itemdefinition-name>\n                            <itemdefinition-typeref>\n                                <namespace-uri>https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8</namespace-uri>\n                                <local-part>number</local-part>\n                                <prefix></prefix>\n                            </itemdefinition-typeref>\n                            <itemdefinition-itemcomponent/>\n                            <itemdefinition-iscollection>false</itemdefinition-iscollection>\n                        </dmn-itemdefinition-info>\n                    </itemdefinition-itemcomponent>\n                    <itemdefinition-iscollection>false</itemdefinition-iscollection>\n                </dmn-itemdefinition-info>\n                <dmn-itemdefinition-info>\n                    <itemdefinition-id>_13C7EFD8-B85C-43BF-94D3-14FABE39A4A0</itemdefinition-id>\n                    <itemdefinition-name>tDriver</itemdefinition-name>\n                    <itemdefinition-itemcomponent>\n                        <dmn-itemdefinition-info>\n                            <itemdefinition-id>_EC11744C-4160-4549-9610-2C757F40DFE8</itemdefinition-id>\n                            <itemdefinition-name>Name</itemdefinition-name>\n                            <itemdefinition-typeref>\n                                <namespace-uri>https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8</namespace-uri>\n                                <local-part>string</local-part>\n                                <prefix></prefix>\n                            </itemdefinition-typeref>\n                            <itemdefinition-itemcomponent/>\n                            <itemdefinition-iscollection>false</itemdefinition-iscollection>\n                        </dmn-itemdefinition-info>\n                        <dmn-itemdefinition-info>\n                            <itemdefinition-id>_E95BE3DB-4A51-4658-A166-02493EAAC9D2</itemdefinition-id>\n                            <itemdefinition-name>Age</itemdefinition-name>\n                            <itemdefinition-typeref>\n                                <namespace-uri>https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8</namespace-uri>\n                                <local-part>number</local-part>\n                                <prefix></prefix>\n                            </itemdefinition-typeref>\n                            <itemdefinition-itemcomponent/>\n                            <itemdefinition-iscollection>false</itemdefinition-iscollection>\n                        </dmn-itemdefinition-info>\n                        <dmn-itemdefinition-info>\n                            <itemdefinition-id>_7B3023E2-BC44-4BF3-BF7E-773C240FB9AD</itemdefinition-id>\n                            <itemdefinition-name>State</itemdefinition-name>\n                            <itemdefinition-typeref>\n                                <namespace-uri>https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8</namespace-uri>\n                                <local-part>string</local-part>\n                                <prefix></prefix>\n                            </itemdefinition-typeref>\n                            <itemdefinition-itemcomponent/>\n                            <itemdefinition-iscollection>false</itemdefinition-iscollection>\n                        </dmn-itemdefinition-info>\n                        <dmn-itemdefinition-info>\n                            <itemdefinition-id>_3D4B49DD-700C-4925-99A7-3B2B873F7800</itemdefinition-id>\n                            <itemdefinition-name>city</itemdefinition-name>\n                            <itemdefinition-typeref>\n                                <namespace-uri>https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8</namespace-uri>\n                                <local-part>string</local-part>\n                                <prefix></prefix>\n                            </itemdefinition-typeref>\n                            <itemdefinition-itemcomponent/>\n                            <itemdefinition-iscollection>false</itemdefinition-iscollection>\n                        </dmn-itemdefinition-info>\n                        <dmn-itemdefinition-info>\n                            <itemdefinition-id>_B37C49E8-B0D9-4B20-9DC6-D655BB1CA7B1</itemdefinition-id>\n                            <itemdefinition-name>Points</itemdefinition-name>\n                            <itemdefinition-typeref>\n                                <namespace-uri>https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8</namespace-uri>\n                                <local-part>number</local-part>\n                                <prefix></prefix>\n                            </itemdefinition-typeref>\n                            <itemdefinition-itemcomponent/>\n                            <itemdefinition-iscollection>false</itemdefinition-iscollection>\n                        </dmn-itemdefinition-info>\n                    </itemdefinition-itemcomponent>\n                    <itemdefinition-iscollection>false</itemdefinition-iscollection>\n                </dmn-itemdefinition-info>\n                <dmn-itemdefinition-info>\n                    <itemdefinition-id>_A4077C7E-B57A-4DEE-9C65-7769636316F3</itemdefinition-id>\n                    <itemdefinition-name>tFine</itemdefinition-name>\n                    <itemdefinition-itemcomponent>\n                        <dmn-itemdefinition-info>\n                            <itemdefinition-id>_79B152A8-DE83-4001-B88B-52DFF0D73B2D</itemdefinition-id>\n                            <itemdefinition-name>Amount</itemdefinition-name>\n                            <itemdefinition-typeref>\n                                <namespace-uri>https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8</namespace-uri>\n                                <local-part>number</local-part>\n                                <prefix></prefix>\n                            </itemdefinition-typeref>\n                            <itemdefinition-itemcomponent/>\n                            <itemdefinition-iscollection>false</itemdefinition-iscollection>\n                        </dmn-itemdefinition-info>\n                        <dmn-itemdefinition-info>\n                            <itemdefinition-id>_D7CB5F9C-9D55-48C2-83EE-D47045EC90D0</itemdefinition-id>\n                            <itemdefinition-name>Points</itemdefinition-name>\n                            <itemdefinition-typeref>\n                                <namespace-uri>https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8</namespace-uri>\n                                <local-part>number</local-part>\n                                <prefix></prefix>\n                            </itemdefinition-typeref>\n                            <itemdefinition-itemcomponent/>\n                            <itemdefinition-iscollection>false</itemdefinition-iscollection>\n                        </dmn-itemdefinition-info>\n                    </itemdefinition-itemcomponent>\n                    <itemdefinition-iscollection>false</itemdefinition-iscollection>\n                </dmn-itemdefinition-info>\n            </itemdefinitions>\n            <decisionservices/>\n        </model>\n    </dmn-model-info-list>\n</response>")}))})
    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getModels(@Context HttpHeaders headers, @ApiParam(value="Container id that models should be loaded from", required=true, example="traffic-violation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.modelEvaluatorService.getKieServerRegistry(), (HttpHeaders)headers);
        try {
            ServiceResponse result = this.modelEvaluatorService.getModels(containerId);
            if (result.getType() == KieServiceResponse.ResponseType.SUCCESS) {
                return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
            }
            return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.NOT_FOUND, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            LOG.error("Unexpected error retrieving models. Message: '{}'", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("ERROR", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Evaluates decisions for given input", response=ServiceResponse.class, code=200, notes="Please reference the documentation for usage of the KIE Server REST API for DMN (doc ref: \"Executing a DMN service using the KIE Server REST API\" section in the Getting started with decision services).")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Container not found"), @ApiResponse(code=200, response=String.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"type\": \"SUCCESS\",\n  \"msg\": \"OK from container 'Traffic-Violation_1.0.0-SNAPSHOT'\",\n  \"result\": {\n      \"dmn-evaluation-result\": {\n          \"messages\": [],\n          \"model-namespace\": \"https://github.com/kiegroup/drools/kie-dmn/_7D8116DE-ADF5-4560-A116-FE1A2EAFFF48\",\n          \"model-name\": \"Traffic Violation\",\n          \"decision-name\": [],\n          \"dmn-context\": {\n              \"Violation\": {\n                \"Type\": \"speed\",\n                \"Speed Limit\": 100,\n                \"Actual Speed\": 135\n              },\n              \"Should Driver be Suspended?\": \"Yes\",\n                \"Driver\": {\n                  \"Points\": 15\n                },\n                \"Fine\": {\n                  \"Points\": 7,\n                  \"Amount\": 1000\n                }\n            },\n      \"decision-results\": {\n          \"_E1AF5AC2-E259-455C-96E4-596E30D3BC86\": {\n              \"messages\": [],\n              \"decision-id\": \"_E1AF5AC2-E259-455C-96E4-596E30D3BC86\",\n              \"decision-name\": \"Should the Driver be Suspended?\",\n              \"result\": \"Yes\",\n              \"status\": \"SUCCEEDED\"\n            },\n          \"_D7F02CE0-AF50-4505-AB80-C7D6DE257920\": {\n              \"messages\": [],\n              \"decision-id\": \"_D7F02CE0-AF50-4505-AB80-C7D6DE257920\",\n              \"decision-name\": \"Fine\",\n              \"result\": {\n                \"Points\": 7,\n                \"Amount\": 1000\n              },\n          \"status\": \"SUCCEEDED\"\n        }\n      }\n    }\n  }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<response type=\"SUCCESS\" msg=\"OK from container 'Traffic_1.0.0-SNAPSHOT'\">\n    <dmn-evaluation-result>\n        <model-namespace>https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF</model-namespace>\n        <model-name>Traffic Violation</model-name>\n        <dmn-context xsi:type=\"jaxbListWrapper\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n            <type>MAP</type>\n            <element xsi:type=\"jaxbStringObjectPair\" key=\"Violation\">\n                <value xsi:type=\"jaxbListWrapper\">\n                    <type>MAP</type>\n                    <element xsi:type=\"jaxbStringObjectPair\" key=\"Type\">\n                        <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">speed</value>\n                    </element>\n                    <element xsi:type=\"jaxbStringObjectPair\" key=\"Speed Limit\">\n                        <value xsi:type=\"xs:decimal\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">100</value>\n                    </element>\n                    <element xsi:type=\"jaxbStringObjectPair\" key=\"Actual Speed\">\n                        <value xsi:type=\"xs:decimal\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">135</value>\n                    </element>\n                </value>\n            </element>\n            <element xsi:type=\"jaxbStringObjectPair\" key=\"Driver\">\n                <value xsi:type=\"jaxbListWrapper\">\n                    <type>MAP</type>\n                    <element xsi:type=\"jaxbStringObjectPair\" key=\"Points\">\n                        <value xsi:type=\"xs:decimal\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">15</value>\n                    </element>\n                </value>\n            </element>\n            <element xsi:type=\"jaxbStringObjectPair\" key=\"Fine\">\n                <value xsi:type=\"jaxbListWrapper\">\n                    <type>MAP</type>\n                    <element xsi:type=\"jaxbStringObjectPair\" key=\"Points\">\n                        <value xsi:type=\"xs:decimal\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">7</value>\n                    </element>\n                    <element xsi:type=\"jaxbStringObjectPair\" key=\"Amount\">\n                        <value xsi:type=\"xs:decimal\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">1000</value>\n                    </element>\n                </value>\n            </element>\n            <element xsi:type=\"jaxbStringObjectPair\" key=\"Should the driver be suspended?\">\n                <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">Yes</value>\n            </element>\n        </dmn-context>\n        <messages/>\n        <decisionResults>\n            <entry>\n                <key>_4055D956-1C47-479C-B3F4-BAEB61F1C929</key>\n                <value>\n                    <decision-id>_4055D956-1C47-479C-B3F4-BAEB61F1C929</decision-id>\n                    <decision-name>Fine</decision-name>\n                    <result xsi:type=\"jaxbListWrapper\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                        <type>MAP</type>\n                        <element xsi:type=\"jaxbStringObjectPair\" key=\"Points\">\n                            <value xsi:type=\"xs:decimal\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">7</value>\n                        </element>\n                        <element xsi:type=\"jaxbStringObjectPair\" key=\"Amount\">\n                            <value xsi:type=\"xs:decimal\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">1000</value>\n                        </element>\n                    </result>\n                    <messages/>\n                    <status>SUCCEEDED</status>\n                </value>\n            </entry>\n            <entry>\n                <key>_8A408366-D8E9-4626-ABF3-5F69AA01F880</key>\n                <value>\n                    <decision-id>_8A408366-D8E9-4626-ABF3-5F69AA01F880</decision-id>\n                    <decision-name>Should the driver be suspended?</decision-name>\n                    <result xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">Yes</result>\n                    <messages/>\n                    <status>SUCCEEDED</status>\n                </value>\n            </entry>\n        </decisionResults>\n    </dmn-evaluation-result>\n</response>")}))})
    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response evaluateDecisions(@Context HttpHeaders headers, @ApiParam(value="Container id to be used to evaluate decisions on", required=true, example="traffic-violation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="DMN context to be used while evaluation decisions as DMNContextKS type", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"model-namespace\" : \"https://github.com/kiegroup/drools/kie-dmn/_60B01F4D-E407-43F7-848E-258723B5FAC8\",\n  \"model-name\" : \"Traffic Violation\",\n  \"dmn-context\" :\n  {\n    \"Driver\" :\n    {\n       \"Points\" : 15\n    },\n    \"Violation\" :\n    {\n        \"Type\" : \"speed\",\n        \"Actual Speed\" : 135,\n        \"Speed Limit\" : 100\n    }\n  }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<dmn-evaluation-context>\n    <dmn-context xsi:type=\"jaxbListWrapper\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n        <type>MAP</type>\n        <element xsi:type=\"jaxbStringObjectPair\" key=\"Violation\">\n            <value xsi:type=\"jaxbListWrapper\">\n                <type>MAP</type>\n                <element xsi:type=\"jaxbStringObjectPair\" key=\"Type\">\n                    <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">speed</value>\n                </element>\n                <element xsi:type=\"jaxbStringObjectPair\" key=\"Speed Limit\">\n                    <value xsi:type=\"xs:decimal\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">100</value>\n                </element>\n                <element xsi:type=\"jaxbStringObjectPair\" key=\"Actual Speed\">\n                    <value xsi:type=\"xs:decimal\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">135</value>\n                </element>\n            </value>\n        </element>\n        <element xsi:type=\"jaxbStringObjectPair\" key=\"Driver\">\n            <value xsi:type=\"jaxbListWrapper\">\n                <type>MAP</type>\n                <element xsi:type=\"jaxbStringObjectPair\" key=\"Points\">\n                    <value xsi:type=\"xs:decimal\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">15</value>\n                </element>\n            </value>\n        </element>\n    </dmn-context>\n</dmn-evaluation-context>")})) String payload) {
        LOG.debug("About to evaluateDecisions() on container {}", (Object)containerId);
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.modelEvaluatorService.getKieServerRegistry(), (HttpHeaders)headers);
        try {
            String contentType = RestUtils.getContentType((HttpHeaders)headers);
            LOG.debug("Payload received: {}", (Object)payload);
            ServiceResponse result = this.modelEvaluatorService.evaluateDecisions(containerId, payload, contentType);
            if (result.getType() == KieServiceResponse.ResponseType.SUCCESS) {
                return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
            }
            return RestUtils.createCorrectVariant((MarshallerHelper)this.marshallerHelper, (String)containerId, (Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.NOT_FOUND, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            LOG.error("Unexpected error retrieving models. Message: '{}'", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("ERROR", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @Path(value="models/{modelId}")
    @ApiOperation(value="Model-specific DMN evaluation", notes="This is a techincal endpoint not directly documented here; this endpoint instead is documented in another Swagger/OAS definitions. Please reference container-specific generated Swagger/OAS definitions, as described in the documentation (doc ref: \"REST endpoints for specific DMN models\", req refs: BAPL-1787, DROOLS-6047).")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response evaluateModel(@ApiParam(value="Container id to be used to evaluate decisions on", required=true) @PathParam(value="containerId") String containerId, @ApiParam(value="Reference container-specific Swagger/OAS definitions", required=true) @PathParam(value="modelId") String modelId, @ApiParam(value="Reference container-specific Swagger/OAS definitions", required=true) String payload) {
        LOG.debug("About to evaluateModel() on container {}", (Object)containerId);
        return this.modelEvaluatorService.evaluateModel(containerId, modelId, payload, false, null);
    }

    @Path(value="models/{modelId}")
    @ApiOperation(value="Model-specific definitions", notes="This is a techincal endpoint not directly documented here; this endpoint instead is documented in another Swagger/OAS definitions. Please reference container-specific generated Swagger/OAS definitions, as described in the documentation (doc ref: \"REST endpoints for specific DMN models\", req refs: BAPL-1787, DROOLS-6047).")
    @GET
    @Produces(value={"application/xml"})
    public Response getModel(@ApiParam(value="Container id to retrieve the Model-specific definitions", required=true) @PathParam(value="containerId") String containerId, @ApiParam(value="Reference container-specific Swagger/OAS definitions", required=true) @PathParam(value="modelId") String modelId) {
        LOG.debug("About to evaluateModel() on container {}", (Object)containerId);
        return this.modelEvaluatorService.getModel(containerId, modelId);
    }

    @Path(value="models/{modelId}/dmnresult")
    @ApiOperation(value="Model-specific DMN evaluation", notes="This is a techincal endpoint not directly documented here; this endpoint instead is documented in another Swagger/OAS definitions. Please reference container-specific generated Swagger/OAS definitions, as described in the documentation (doc ref: \"REST endpoints for specific DMN models\", req refs: BAPL-1787, DROOLS-6047).")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response evaluateModelAsDmnResult(@ApiParam(value="Container id to be used to evaluate decisions on", required=true) @PathParam(value="containerId") String containerId, @ApiParam(value="Reference container-specific Swagger/OAS definitions", required=true) @PathParam(value="modelId") String modelId, @ApiParam(value="Reference container-specific Swagger/OAS definitions", required=true) String payload) {
        LOG.debug("About to evaluateModelAsDmnResult() on container {}", (Object)containerId);
        return this.modelEvaluatorService.evaluateModel(containerId, modelId, payload, true, null);
    }

    @Path(value="models/{modelId}/{decisionServiceId}")
    @ApiOperation(value="Model-specific DMN evaluation", notes="This is a techincal endpoint not directly documented here; this endpoint instead is documented in another Swagger/OAS definitions. Please reference container-specific generated Swagger/OAS definitions, as described in the documentation (doc ref: \"REST endpoints for specific DMN models\", req refs: BAPL-1787, DROOLS-6047).")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response evaluateModelDS(@ApiParam(value="Container id to be used to evaluate decisions on", required=true) @PathParam(value="containerId") String containerId, @ApiParam(value="Reference container-specific Swagger/OAS definitions", required=true) @PathParam(value="modelId") String modelId, @ApiParam(value="Reference container-specific Swagger/OAS definitions", required=true) @PathParam(value="decisionServiceId") String decisionServiceId, @ApiParam(value="Reference container-specific Swagger/OAS definitions", required=true) String payload) {
        LOG.debug("About to evaluateModelDS() on container {}", (Object)containerId);
        return this.modelEvaluatorService.evaluateModel(containerId, modelId, payload, false, decisionServiceId);
    }

    @Path(value="models/{modelId}/{decisionServiceId}/dmnresult")
    @ApiOperation(value="Model-specific DMN evaluation", notes="This is a techincal endpoint not directly documented here; this endpoint instead is documented in another Swagger/OAS definitions. Please reference container-specific generated Swagger/OAS definitions, as described in the documentation (doc ref: \"REST endpoints for specific DMN models\", req refs: BAPL-1787, DROOLS-6047).")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response evaluateModelDSAsDmnResult(@ApiParam(value="Container id to be used to evaluate decisions on", required=true) @PathParam(value="containerId") String containerId, @ApiParam(value="Reference container-specific Swagger/OAS definitions", required=true) @PathParam(value="modelId") String modelId, @ApiParam(value="Reference container-specific Swagger/OAS definitions", required=true) @PathParam(value="decisionServiceId") String decisionServiceId, @ApiParam(value="Reference container-specific Swagger/OAS definitions", required=true) String payload) {
        LOG.debug("About to evaluateModelDSAsDmnResult() on container {}", (Object)containerId);
        return this.modelEvaluatorService.evaluateModel(containerId, modelId, payload, true, decisionServiceId);
    }

    @Path(value="openapi.{type:json|yaml}")
    @ApiOperation(value="Model-specific definitions", notes="Retrieves the Model-specific Swagger/OAS definitions, for the given Container id. Please reference container-specific generated Swagger/OAS definitions, as described in the documentation (doc ref: \"REST endpoints for specific DMN models\", req refs: BAPL-1787, DROOLS-6047).")
    @GET
    @Produces(value={"application/json", "application/yaml"})
    public Response getOASType(@ApiParam(value="Container id to retrieve the Model-specific definitions", required=true) @PathParam(value="containerId") String containerId, @PathParam(value="type") String type) {
        LOG.debug("About to getOASType() on container {}", (Object)containerId);
        if (type != null && type.equals("yaml")) {
            return this.modelEvaluatorService.getOAS(containerId, false);
        }
        return this.modelEvaluatorService.getOAS(containerId, true);
    }

    @Path(value="openapi")
    @ApiOperation(value="Model-specific definitions", notes="Retrieves the Model-specific Swagger/OAS definitions, for the given Container id. Please reference container-specific generated Swagger/OAS definitions, as described in the documentation (doc ref: \"REST endpoints for specific DMN models\", req refs: BAPL-1787, DROOLS-6047).")
    @GET
    @Produces(value={"application/json", "application/yaml"})
    public Response getOAS(@ApiParam(value="Container id to retrieve the Model-specific definitions", required=true) @PathParam(value="containerId") String containerId) {
        LOG.debug("About to getOAS() on container {}", (Object)containerId);
        return this.getOASType(containerId, "json");
    }
}

