/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder.dialect.mvel;

import java.util.function.BiFunction;
import java.util.regex.Matcher;
import org.drools.mvel.MVELSafeHelper;
import org.jbpm.process.builder.dialect.mvel.MVELResolverFactory;
import org.jbpm.process.instance.impl.AssignmentAction;
import org.jbpm.process.instance.impl.AssignmentProducer;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessContext;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MVELAssignmentAction
implements AssignmentAction {
    private static final Logger logger = LoggerFactory.getLogger(MVELAssignmentAction.class);
    private String to;
    private String from;
    private String srcExpr;
    private String targetExpr;
    private AssignmentProducer producer;
    private BiFunction<ProcessContext, NodeInstance, Object> src;
    private BiFunction<ProcessContext, NodeInstance, Object> target;
    private static final String THIS = "this";

    public MVELAssignmentAction(Assignment assignment, String sourceExpr, String targetExpr, BiFunction<ProcessContext, NodeInstance, Object> source, BiFunction<ProcessContext, NodeInstance, Object> target, AssignmentProducer producer) {
        Matcher fromMatcher = PatternConstants.PARAMETER_MATCHER.matcher(assignment.getFrom());
        Matcher toMatcher = PatternConstants.PARAMETER_MATCHER.matcher(assignment.getTo());
        this.from = fromMatcher.find() ? fromMatcher.group(1) : assignment.getFrom();
        this.to = toMatcher.find() ? toMatcher.group(1) : assignment.getTo();
        this.src = source;
        this.target = target;
        this.srcExpr = sourceExpr;
        this.targetExpr = targetExpr;
        this.producer = producer;
    }

    public void execute(NodeInstance nodeInstance, ProcessContext context) {
        Object srcObject;
        Object targetObject = this.targetExpr != null ? this.target.apply(context, nodeInstance) : null;
        Object object = srcObject = this.srcExpr != null ? this.src.apply(context, nodeInstance) : null;
        if (this.targetExpr != null && targetObject == null || this.notEvalTarget()) {
            Object object2 = targetObject = this.notEvalSrc() ? srcObject : MVELSafeHelper.getEvaluator().eval(this.from, srcObject, (VariableResolverFactory)new NodeInstanceResolverFactory((org.jbpm.workflow.instance.NodeInstance)nodeInstance));
            if (this.targetExpr != null) {
                this.producer.accept(context, nodeInstance, targetObject);
            }
        } else {
            String lValue = MVELAssignmentAction.ensureLocated(this.targetExpr, this.to);
            String rootName = this.targetExpr != null ? this.targetExpr : this.getRootValue(lValue);
            MVELResolverFactory resolver = new MVELResolverFactory((org.jbpm.workflow.instance.NodeInstance)nodeInstance, rootName);
            if (this.srcExpr != null) {
                resolver.addExtraParameter(this.srcExpr, srcObject);
            }
            if (this.targetExpr != null) {
                resolver.addExtraParameter(this.targetExpr, targetObject);
            }
            String expr = lValue.concat("=").concat(MVELAssignmentAction.ensureLocated(this.srcExpr, this.from));
            logger.debug("Executing mvel assignment {}", (Object)expr);
            MVELSafeHelper.getEvaluator().eval(expr, (VariableResolverFactory)resolver);
            context.setVariable(rootName, resolver.getVariable());
        }
    }

    private String getRootValue(String lValue) {
        int indexOf = lValue.indexOf(".");
        if (indexOf > 0) {
            lValue = lValue.substring(0, indexOf);
        }
        if ((indexOf = lValue.indexOf(91)) > 0) {
            lValue = lValue.substring(0, indexOf);
        }
        return lValue;
    }

    private static boolean isThis(String assignmentExpr) {
        return assignmentExpr.equals(".") || assignmentExpr.equals(THIS);
    }

    private static boolean notEval(String assignmentExpr, String expr) {
        return MVELAssignmentAction.isThis(assignmentExpr) || assignmentExpr.equals(expr);
    }

    private static String ensureLocated(String prefix, String suffix) {
        if (prefix == null) {
            return suffix;
        }
        if (MVELAssignmentAction.isThis(suffix)) {
            return prefix;
        }
        if (suffix.startsWith(prefix)) {
            return suffix;
        }
        StringBuilder sb = new StringBuilder(prefix);
        if (suffix.startsWith(THIS)) {
            sb.append(suffix.substring(THIS.length()));
        } else {
            if (!suffix.startsWith("[")) {
                sb.append(".");
            }
            sb.append(suffix);
        }
        return sb.toString();
    }

    private boolean notEvalSrc() {
        return MVELAssignmentAction.notEval(this.from, this.srcExpr);
    }

    private boolean notEvalTarget() {
        return MVELAssignmentAction.notEval(this.to, this.targetExpr);
    }
}

