/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.group;

import java.util.Collections;
import java.util.List;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.engine.DataSetHandler;
import org.dashbuilder.dataset.engine.group.IntervalBuilder;
import org.dashbuilder.dataset.engine.group.IntervalList;
import org.dashbuilder.dataset.engine.group.IntervalListDayOfWeek;
import org.dashbuilder.dataset.engine.group.IntervalListHour;
import org.dashbuilder.dataset.engine.group.IntervalListMinute;
import org.dashbuilder.dataset.engine.group.IntervalListMonth;
import org.dashbuilder.dataset.engine.group.IntervalListQuarter;
import org.dashbuilder.dataset.engine.group.IntervalListSecond;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.Interval;

public class IntervalBuilderFixedDate
implements IntervalBuilder {
    @Override
    public IntervalList build(DataSetHandler ctx, ColumnGroup columnGroup) {
        IntervalList intervalList = this._build(columnGroup);
        String columnId = columnGroup.getSourceId();
        List values = ctx.getDataSet().getColumnById(columnId).getValues();
        List<Integer> rows = ctx.getRows();
        intervalList.indexValues(values, rows);
        return intervalList;
    }

    @Override
    public IntervalList build(DataColumn dataColumn) {
        ColumnGroup columnGroup = dataColumn.getColumnGroup();
        return this._build(columnGroup);
    }

    protected IntervalList _build(ColumnGroup columnGroup) {
        IntervalList intervalList = this.createIntervalList(columnGroup);
        boolean asc = columnGroup.isAscendingOrder();
        if (!asc) {
            Collections.reverse(intervalList);
            intervalList.add(0, (Interval)intervalList.remove(intervalList.size() - 1));
        }
        return intervalList;
    }

    public IntervalList createIntervalList(ColumnGroup columnGroup) {
        DateIntervalType type = DateIntervalType.getByName((String)columnGroup.getIntervalSize());
        if (DateIntervalType.QUARTER.equals((Object)type)) {
            return new IntervalListQuarter(columnGroup);
        }
        if (DateIntervalType.MONTH.equals((Object)type)) {
            return new IntervalListMonth(columnGroup);
        }
        if (DateIntervalType.DAY_OF_WEEK.equals((Object)type)) {
            return new IntervalListDayOfWeek(columnGroup);
        }
        if (DateIntervalType.HOUR.equals((Object)type)) {
            return new IntervalListHour(columnGroup);
        }
        if (DateIntervalType.MINUTE.equals((Object)type)) {
            return new IntervalListMinute(columnGroup);
        }
        if (DateIntervalType.SECOND.equals((Object)type)) {
            return new IntervalListSecond(columnGroup);
        }
        throw new IllegalArgumentException("Interval size '" + columnGroup.getIntervalSize() + "' not supported for fixed date intervals. The only supported sizes are: " + this.join(DateIntervalType.FIXED_INTERVALS_SUPPORTED, ","));
    }

    public String join(List array, String separator) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < array.size(); ++i) {
            if (i > 0) {
                builder.append(separator);
            }
            builder.append(array.get(i));
        }
        return builder.toString();
    }
}

