/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.util;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbpm.process.core.timer.BusinessCalendar;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.kie.api.runtime.Environment;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.EmailNotification;
import org.kie.internal.task.api.model.EmailNotificationHeader;
import org.kie.internal.task.api.model.Escalation;
import org.kie.internal.task.api.model.InternalI18NText;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.kie.internal.task.api.model.Language;
import org.kie.internal.task.api.model.Notification;
import org.kie.internal.task.api.model.Reassignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanTaskHandlerHelper {
    private static final Logger logger = LoggerFactory.getLogger(HumanTaskHandlerHelper.class);
    private static final String COMPONENT_SEPARATOR = "\\^";
    private static final String ELEMENT_SEPARATOR = "@";
    private static final String ATTRIBUTES_SEPARATOR = "\\|";
    private static final String ATTRIBUTES_ELEMENTS_SEPARATOR = ",";
    private static final String KEY_VALUE_SEPARATOR = ":";
    private static final String[] KNOWN_KEYS = new String[]{"users", "groups", "from", "tousers", "togroups", "replyto", "subject", "body", "toemails"};

    public static Deadlines setDeadlines(Map<String, Object> parameters, List<OrganizationalEntity> businessAdministrators, Environment environment) {
        return HumanTaskHandlerHelper.setDeadlines(parameters, businessAdministrators, environment, false);
    }

    public static Deadlines setDeadlines(Map<String, Object> parameters, List<OrganizationalEntity> businessAdministrators, Environment environment, boolean unboundRepeatableOnly) {
        String notStartedReassign = (String)parameters.get("NotStartedReassign");
        String notStartedNotify = (String)parameters.get("NotStartedNotify");
        String notCompletedReassign = (String)parameters.get("NotCompletedReassign");
        String notCompletedNotify = (String)parameters.get("NotCompletedNotify");
        Deadlines deadlinesTotal = TaskModelProvider.getFactory().newDeadlines();
        ArrayList<Deadline> startDeadlines = new ArrayList<Deadline>();
        startDeadlines.addAll(HumanTaskHandlerHelper.parseDeadlineString(notStartedNotify, businessAdministrators, environment, unboundRepeatableOnly));
        startDeadlines.addAll(HumanTaskHandlerHelper.parseDeadlineString(notStartedReassign, businessAdministrators, environment, unboundRepeatableOnly));
        ArrayList<Deadline> endDeadlines = new ArrayList<Deadline>();
        endDeadlines.addAll(HumanTaskHandlerHelper.parseDeadlineString(notCompletedNotify, businessAdministrators, environment, unboundRepeatableOnly));
        endDeadlines.addAll(HumanTaskHandlerHelper.parseDeadlineString(notCompletedReassign, businessAdministrators, environment, unboundRepeatableOnly));
        if (!startDeadlines.isEmpty()) {
            deadlinesTotal.setStartDeadlines(startDeadlines);
        }
        if (!endDeadlines.isEmpty()) {
            deadlinesTotal.setEndDeadlines(endDeadlines);
        }
        return deadlinesTotal;
    }

    public static List<Deadline> parseDeadlineString(String deadlineInfo, List<OrganizationalEntity> businessAdministrators, Environment environment, boolean unboundRepeatableOnly) {
        if (deadlineInfo == null || deadlineInfo.length() == 0) {
            return new ArrayList<Deadline>();
        }
        ArrayList<Deadline> deadlines = new ArrayList<Deadline>();
        String[] allComponents = deadlineInfo.split(COMPONENT_SEPARATOR);
        BusinessCalendar businessCalendar = null;
        if (environment != null && environment.get("jbpm.business.calendar") != null) {
            businessCalendar = (BusinessCalendar)environment.get("jbpm.business.calendar");
        }
        for (String component : allComponents) {
            Pattern pattern = Pattern.compile("\\[(.*)\\]@\\[(.*)\\]", 32);
            Matcher matcher = pattern.matcher(component);
            if (!matcher.find()) {
                logger.warn("Incorrect syntax of deadline property {}", (Object)deadlineInfo);
                continue;
            }
            String actionComponent = matcher.group(1);
            String expireComponents = matcher.group(2);
            if (actionComponent != null && expireComponents != null) {
                String[] expireElements;
                for (String expiresAt : expireElements = expireComponents.split(ATTRIBUTES_ELEMENTS_SEPARATOR)) {
                    if (unboundRepeatableOnly && !expiresAt.startsWith("R/")) continue;
                    if (businessCalendar != null) {
                        deadlines.add(HumanTaskHandlerHelper.getNewDeadline(expiresAt, businessCalendar.calculateBusinessTimeAsDate(expiresAt.trim()), actionComponent, businessAdministrators));
                        continue;
                    }
                    if (DateTimeUtils.isRepeatable((String)expiresAt.trim())) {
                        int repeatLimit = HumanTaskHandlerHelper.getDeadlineRepeatLimit(expiresAt.trim());
                        if (repeatLimit > 0) {
                            for (int i = 0; i < repeatLimit; ++i) {
                                Date durationDate = HumanTaskHandlerHelper.getDeadlineDurationDate(expiresAt.trim(), i);
                                deadlines.add(HumanTaskHandlerHelper.getNewDeadline(expiresAt, durationDate, actionComponent, businessAdministrators));
                            }
                            continue;
                        }
                        deadlines.add(HumanTaskHandlerHelper.getNewDeadline(expiresAt, HumanTaskHandlerHelper.getDeadlineDurationDate(expiresAt.trim(), 0), actionComponent, businessAdministrators));
                        continue;
                    }
                    deadlines.add(HumanTaskHandlerHelper.getNewDeadline(expiresAt, HumanTaskHandlerHelper.getDeadlineDurationDate(expiresAt.trim(), 0), actionComponent, businessAdministrators));
                }
                continue;
            }
            logger.warn("Incorrect syntax of deadline property {}", (Object)deadlineInfo);
        }
        return deadlines;
    }

    protected static Deadline getNewDeadline(String expiresAt, Date deadlineDate, String actionComponent, List<OrganizationalEntity> businessAdministrators) {
        logger.debug("Expires at is {}", (Object)expiresAt);
        Deadline taskDeadline = TaskModelProvider.getFactory().newDeadline();
        taskDeadline.setDate(deadlineDate);
        logger.debug("Calculated date of execution is {} and current date {}", (Object)taskDeadline.getDate(), (Object)new Date());
        ArrayList<Escalation> escalations = new ArrayList<Escalation>();
        Escalation escalation = TaskModelProvider.getFactory().newEscalation();
        escalations.add(escalation);
        escalation.setName("Default escalation");
        taskDeadline.setEscalations(escalations);
        escalation.setReassignments(HumanTaskHandlerHelper.parseReassignment(actionComponent));
        escalation.setNotifications(HumanTaskHandlerHelper.parseNotifications(actionComponent, businessAdministrators));
        return taskDeadline;
    }

    protected static List<Notification> parseNotifications(String notificationString, List<OrganizationalEntity> businessAdministrators) {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        Map<String, String> parameters = HumanTaskHandlerHelper.asMap(notificationString);
        if (parameters.containsKey("tousers") || parameters.containsKey("togroups") || parameters.containsKey("toemails")) {
            String emailRecipients;
            String groupRecipients;
            String locale = parameters.get("locale");
            if (locale == null) {
                locale = "en-UK";
            }
            EmailNotification emailNotification = TaskModelProvider.getFactory().newEmialNotification();
            notifications.add((Notification)emailNotification);
            emailNotification.setBusinessAdministrators(new ArrayList<OrganizationalEntity>(businessAdministrators));
            HashMap<Language, EmailNotificationHeader> emailHeaders = new HashMap<Language, EmailNotificationHeader>();
            ArrayList<I18NText> subjects = new ArrayList<I18NText>();
            ArrayList<I18NText> names = new ArrayList<I18NText>();
            ArrayList<Object> notificationRecipients = new ArrayList<Object>();
            EmailNotificationHeader emailHeader = TaskModelProvider.getFactory().newEmailNotificationHeader();
            emailHeader.setBody(parameters.get("body"));
            emailHeader.setFrom(parameters.get("from"));
            emailHeader.setReplyTo(parameters.get("replyto"));
            emailHeader.setLanguage(locale);
            emailHeader.setSubject(parameters.get("subject"));
            Language lang = TaskModelProvider.getFactory().newLanguage();
            lang.setMapkey(locale);
            emailHeaders.put(lang, emailHeader);
            I18NText subject = TaskModelProvider.getFactory().newI18NText();
            ((InternalI18NText)subject).setLanguage(locale);
            ((InternalI18NText)subject).setText(emailHeader.getSubject());
            subjects.add(subject);
            names.add(subject);
            String recipients = parameters.get("tousers");
            if (recipients != null && recipients.trim().length() > 0) {
                String[] recipientsIds;
                for (String id : recipientsIds = recipients.split(ATTRIBUTES_ELEMENTS_SEPARATOR)) {
                    notificationRecipients.add(TaskModelProvider.getFactory().newUser(id.trim()));
                }
            }
            if ((groupRecipients = parameters.get("togroups")) != null && groupRecipients.trim().length() > 0) {
                String[] groupRecipientsIds;
                for (String id : groupRecipientsIds = groupRecipients.split(ATTRIBUTES_ELEMENTS_SEPARATOR)) {
                    notificationRecipients.add(TaskModelProvider.getFactory().newGroup(id.trim()));
                }
            }
            if ((emailRecipients = parameters.get("toemails")) != null && emailRecipients.trim().length() > 0) {
                String[] emailRecipientsIds;
                for (String id : emailRecipientsIds = emailRecipients.trim().split(ATTRIBUTES_ELEMENTS_SEPARATOR)) {
                    notificationRecipients.add(TaskModelProvider.getFactory().newEmail(id.trim()));
                }
            }
            emailNotification.setEmailHeaders(emailHeaders);
            emailNotification.setNames(names);
            emailNotification.setRecipients(notificationRecipients);
            emailNotification.setSubjects(subjects);
        }
        return notifications;
    }

    protected static int getDeadlineRepeatLimit(String deadlineStr) {
        String[] repeatableParts = DateTimeUtils.parseISORepeatable((String)deadlineStr);
        String repeatLimit = repeatableParts[0];
        if (!repeatLimit.isEmpty()) {
            return Integer.parseInt(repeatLimit);
        }
        return -1;
    }

    protected static Date getDeadlineDurationDate(String durationStr, int repeatCount) {
        if (durationStr.isEmpty()) {
            throw new IllegalArgumentException("Duration string is empty");
        }
        try {
            if (DateTimeUtils.isRepeatable((String)durationStr)) {
                Date deadlineDate;
                String[] repeatableParts = DateTimeUtils.parseISORepeatable((String)durationStr);
                String tempTimeDelay = repeatableParts[1];
                String tempDateTimeStr = repeatableParts[2];
                if (DateTimeUtils.isPeriod((String)tempDateTimeStr)) {
                    deadlineDate = new Date(DateTimeUtils.parseDateTime((String)tempTimeDelay) + DateTimeUtils.parseDuration((String)tempDateTimeStr) * (long)repeatCount);
                } else if (DateTimeUtils.isPeriod((String)tempTimeDelay)) {
                    long firstRet = DateTimeUtils.parseDateTime((String)tempDateTimeStr) - Duration.parse(tempTimeDelay).toMillis();
                    deadlineDate = new Date(firstRet + DateTimeUtils.parseDuration((String)tempTimeDelay) * (long)repeatCount);
                } else {
                    long duration = DateTimeUtils.parseDateTime((String)tempDateTimeStr) - DateTimeUtils.parseDateTime((String)tempTimeDelay);
                    deadlineDate = new Date(DateTimeUtils.parseDateTime((String)tempTimeDelay) + duration * (long)repeatCount);
                }
                return deadlineDate;
            }
            if (DateTimeUtils.isPeriod((String)durationStr)) {
                return new Date(System.currentTimeMillis() + Duration.parse(durationStr).toMillis());
            }
            return new Date(System.currentTimeMillis() + DateTimeUtils.parseDateAsDuration((String)durationStr));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse duration string: " + durationStr + " : " + e.getMessage(), e);
        }
    }

    protected static List<Reassignment> parseReassignment(String reassignString) {
        ArrayList<Reassignment> reassignments = new ArrayList<Reassignment>();
        Map<String, String> parameters = HumanTaskHandlerHelper.asMap(reassignString);
        if (parameters.containsKey("users") || parameters.containsKey("groups")) {
            String[] recipientsIds;
            Reassignment reassignment = TaskModelProvider.getFactory().newReassignment();
            ArrayList<Object> reassignmentUsers = new ArrayList<Object>();
            String recipients = parameters.get("users");
            if (recipients != null && recipients.trim().length() > 0) {
                for (String id : recipientsIds = recipients.split(ATTRIBUTES_ELEMENTS_SEPARATOR)) {
                    User user = TaskModelProvider.getFactory().newUser();
                    ((InternalOrganizationalEntity)user).setId(id.trim());
                    reassignmentUsers.add(user);
                }
            }
            if ((recipients = parameters.get("groups")) != null && recipients.trim().length() > 0) {
                for (String id : recipientsIds = recipients.split(ATTRIBUTES_ELEMENTS_SEPARATOR)) {
                    Group group = TaskModelProvider.getFactory().newGroup();
                    ((InternalOrganizationalEntity)group).setId(id.trim());
                    reassignmentUsers.add(group);
                }
            }
            reassignment.setPotentialOwners(reassignmentUsers);
            reassignments.add(reassignment);
        }
        return reassignments;
    }

    protected static Map<String, String> asMap(String parsableString) {
        String[] actionElements = parsableString.split(ATTRIBUTES_SEPARATOR);
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String actionElem : actionElements) {
            for (String knownKey : KNOWN_KEYS) {
                if (!actionElem.startsWith(knownKey)) continue;
                try {
                    parameters.put(knownKey, actionElem.substring(knownKey.length() + KEY_VALUE_SEPARATOR.length()));
                }
                catch (IndexOutOfBoundsException e) {
                    parameters.put(knownKey, "");
                }
            }
        }
        return parameters;
    }
}

