/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.listener.support;

import java.util.ArrayDeque;
import java.util.Collection;
import org.optaplanner.core.api.domain.variable.VariableListener;
import org.optaplanner.core.impl.domain.variable.listener.support.SmallScalingOrderedSet;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerNotification;

public class VariableListenerNotifiable
implements Comparable<VariableListenerNotifiable> {
    protected final VariableListener variableListener;
    protected final int globalOrder;
    protected final Collection<VariableListenerNotification> notificationQueue;

    public VariableListenerNotifiable(VariableListener variableListener, int globalOrder) {
        this.variableListener = variableListener;
        this.globalOrder = globalOrder;
        this.notificationQueue = variableListener.requiresUniqueEntityEvents() ? new SmallScalingOrderedSet<VariableListenerNotification>() : new ArrayDeque<VariableListenerNotification>();
    }

    public VariableListener getVariableListener() {
        return this.variableListener;
    }

    public int getGlobalOrder() {
        return this.globalOrder;
    }

    public Collection<VariableListenerNotification> getNotificationQueue() {
        return this.notificationQueue;
    }

    @Override
    public int compareTo(VariableListenerNotifiable other) {
        if (this.globalOrder < other.globalOrder) {
            return -1;
        }
        if (this.globalOrder > other.globalOrder) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "(" + this.globalOrder + ") " + this.variableListener;
    }
}

