/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.bpmn2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.core.Bpmn2Import;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.runtime.Cacheable;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="ServiceTaskDefinitions.wid", name="ServiceTask", displayName="ServiceTask", defaultHandler="mvel: new org.jbpm.process.workitem.bpmn2.ServiceTaskHandler()", documentation="jbpm-workitems-bpmn2/index.html", category="jbpm-workitems-bpmn2", icon="ServiceTask.png", parameters={@WidParameter(name="implementation"), @WidParameter(name="interfaceImplementationRef"), @WidParameter(name="operationImplementationRef"), @WidParameter(name="Parameter"), @WidParameter(name="mode")}, results={@WidResult(name="Result", runtimeType="java.lang.Object")}, mavenDepends={@WidMavenDepends(group="org.jbpm", artifact="jbpm-workitems-bpmn2", version="7.66.0-SNAPSHOT")}, serviceInfo=@WidService(category="BPMN2", description="Execute business rule or service tasks", keywords="service,task", action=@WidAction(title="Execute a service task")))
public class ServiceTaskHandler
extends AbstractLogOrThrowWorkItemHandler
implements Cacheable {
    public static final String WSDL_IMPORT_TYPE = "http://schemas.xmlsoap.org/wsdl/";
    private static final Logger logger = LoggerFactory.getLogger(ServiceTaskHandler.class);
    private static final String RESULTS = "Result";
    private ConcurrentHashMap<String, Client> clients = new ConcurrentHashMap();
    private JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
    private KieSession ksession;
    private int asyncTimeout = 10;
    private ClassLoader classLoader;

    public ServiceTaskHandler() {
    }

    public ServiceTaskHandler(KieSession ksession) {
        this.ksession = ksession;
    }

    public ServiceTaskHandler(KieSession ksession, ClassLoader classloader) {
        this.ksession = ksession;
        this.classLoader = classloader;
    }

    public ServiceTaskHandler(KieSession ksession, int timeout) {
        this.ksession = ksession;
        this.asyncTimeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        String implementation = (String)workItem.getParameter("implementation");
        if (!"##WebService".equalsIgnoreCase(implementation)) {
            this.executeJavaWorkItem(workItem, manager);
            return;
        }
        ClassLoader origClassloader = Thread.currentThread().getContextClassLoader();
        String interfaceRef = (String)workItem.getParameter("interfaceImplementationRef");
        String operationRef = (String)workItem.getParameter("operationImplementationRef");
        Object parameter = workItem.getParameter("Parameter");
        WSMode mode = WSMode.valueOf(workItem.getParameter("mode") == null ? "SYNC" : ((String)workItem.getParameter("mode")).toUpperCase());
        try {
            Client client = this.getWSClient(workItem, interfaceRef);
            if (client == null) {
                throw new IllegalStateException("Unable to create client for web service " + interfaceRef + " - " + operationRef);
            }
            switch (mode) {
                case SYNC: {
                    Object[] result = client.invoke(operationRef, new Object[]{parameter});
                    HashMap<String, Object> output = new HashMap<String, Object>();
                    if (result == null || result.length == 0) {
                        output.put(RESULTS, null);
                    } else {
                        output.put(RESULTS, result[0]);
                    }
                    manager.completeWorkItem(workItem.getId(), output);
                    return;
                }
                case ASYNC: {
                    final ClientCallback callback = new ClientCallback();
                    final long workItemId = workItem.getId();
                    final String deploymentId = this.nonNull(((WorkItemImpl)workItem).getDeploymentId());
                    final long processInstanceId = workItem.getProcessInstanceId();
                    client.invoke(callback, operationRef, new Object[]{parameter});
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                RuntimeManager manager;
                                Object[] result = callback.get((long)ServiceTaskHandler.this.asyncTimeout, TimeUnit.SECONDS);
                                HashMap<String, Object> output = new HashMap<String, Object>();
                                if (callback.isDone()) {
                                    if (result == null) {
                                        output.put(ServiceTaskHandler.RESULTS, null);
                                    } else {
                                        output.put(ServiceTaskHandler.RESULTS, result[0]);
                                    }
                                }
                                if ((manager = RuntimeManagerRegistry.get().getManager(deploymentId)) != null) {
                                    RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
                                    engine.getKieSession().getWorkItemManager().completeWorkItem(workItemId, output);
                                    manager.disposeRuntimeEngine(engine);
                                } else {
                                    ServiceTaskHandler.this.ksession.getWorkItemManager().completeWorkItem(workItemId, output);
                                }
                            }
                            catch (Exception e) {
                                logger.error("Error encountered while invoking ws operation asynchronously ", (Throwable)e);
                            }
                        }
                    }).start();
                    return;
                }
                case ONEWAY: {
                    ClientCallback callbackFF = new ClientCallback();
                    client.invoke(callbackFF, operationRef, new Object[]{parameter});
                    manager.completeWorkItem(workItem.getId(), new HashMap());
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            this.handleException(e, interfaceRef, "", operationRef, parameter.getClass().getName(), parameter);
            return;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassloader);
        }
    }

    protected synchronized Client getWSClient(WorkItem workItem, String interfaceRef) {
        if (this.clients.containsKey(interfaceRef)) {
            return this.clients.get(interfaceRef);
        }
        long processInstanceId = ((WorkItemImpl)workItem).getProcessInstanceId();
        WorkflowProcessImpl process = (WorkflowProcessImpl)this.ksession.getProcessInstance(processInstanceId).getProcess();
        List typedImports = (List)process.getMetaData("Bpmn2Imports");
        if (typedImports != null) {
            Client client = null;
            for (Bpmn2Import importObj : typedImports) {
                if (!WSDL_IMPORT_TYPE.equalsIgnoreCase(importObj.getType())) continue;
                try {
                    client = this.dcf.createClient(importObj.getLocation(), new QName(importObj.getNamespace(), interfaceRef), this.getInternalClassLoader(), null);
                    this.clients.put(interfaceRef, client);
                    logger.info("WS Client is created for {" + importObj.getNamespace() + "}" + interfaceRef);
                    return client;
                }
                catch (Exception e) {
                    logger.info("Error when creating WS Client. You can ignore this error as long as a client is eventually created", (Throwable)e);
                }
            }
        }
        return null;
    }

    private ClassLoader getInternalClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public void executeJavaWorkItem(WorkItem workItem, WorkItemManager manager) {
        String i = (String)workItem.getParameter("Interface");
        String iImplementationRef = (String)workItem.getParameter("interfaceImplementationRef");
        String operation = (String)workItem.getParameter("Operation");
        String parameterType = (String)workItem.getParameter("ParameterType");
        Object parameter = workItem.getParameter("Parameter");
        String[] interfaces = new String[]{i, iImplementationRef};
        Class<?> c = null;
        for (String interf : interfaces) {
            try {
                c = Class.forName(interf, true, this.getInternalClassLoader());
                break;
            }
            catch (ClassNotFoundException cnfe) {
                if (interf.compareTo(interfaces[interfaces.length - 1]) != 0) continue;
                this.handleException(cnfe, i, iImplementationRef, operation, parameterType, parameter);
            }
        }
        try {
            Object instance = c.newInstance();
            Class[] classes = null;
            Object[] params = null;
            if (parameterType != null) {
                classes = new Class[]{Class.forName(parameterType, true, this.getInternalClassLoader())};
                params = new Object[]{parameter};
            }
            Method method = c.getMethod(operation, classes);
            Object result = method.invoke(instance, params);
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put(RESULTS, result);
            manager.completeWorkItem(workItem.getId(), results);
        }
        catch (ClassNotFoundException e) {
            this.handleException(e, i, iImplementationRef, operation, parameterType, parameter);
        }
        catch (InstantiationException e) {
            this.handleException(e, i, iImplementationRef, operation, parameterType, parameter);
        }
        catch (IllegalAccessException e) {
            this.handleException(e, i, iImplementationRef, operation, parameterType, parameter);
        }
        catch (NoSuchMethodException e) {
            this.handleException(e, i, iImplementationRef, operation, parameterType, parameter);
        }
        catch (InvocationTargetException e) {
            this.handleException(e, i, iImplementationRef, operation, parameterType, parameter);
        }
    }

    private void handleException(Throwable cause, String service, String iImplementationRef, String operation, String paramType, Object param) {
        logger.debug("Handling exception {} inside service {} or {} and operation {} with param type {} and value {}", new Object[]{cause.getMessage(), service, operation, paramType, param});
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("Interface", service);
        data.put("InterfaceImplementationRef", iImplementationRef);
        data.put("Operation", operation);
        data.put("ParameterType", paramType);
        data.put("Parameter", param);
        this.handleException(cause, data);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected String nonNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public void close() {
        if (this.clients != null) {
            for (Client client : this.clients.values()) {
                client.destroy();
            }
        }
    }

    static enum WSMode {
        SYNC,
        ASYNC,
        ONEWAY;

    }
}

