/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.kie.server.api.model.taskassigning.PlanningExecutionResult;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.taskassigning.core.model.TaskAssigningSolution;
import org.kie.server.services.taskassigning.planning.SolutionProcessor;
import org.kie.server.services.taskassigning.planning.SolutionSynchronizer;
import org.kie.server.services.taskassigning.planning.SolverDef;
import org.kie.server.services.taskassigning.planning.SolverExecutor;
import org.kie.server.services.taskassigning.planning.SolverHandlerConfig;
import org.kie.server.services.taskassigning.planning.SolverHandlerContext;
import org.kie.server.services.taskassigning.planning.TaskAssigningRuntimeDelegate;
import org.kie.server.services.taskassigning.user.system.api.UserSystemService;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolverHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolverHandler.class);
    private static final long EXECUTOR_TERMINATION_TIMEOUT = 5L;
    private final SolverDef solverDef;
    private final KieServerRegistry registry;
    private final TaskAssigningRuntimeDelegate delegate;
    private final UserSystemService userSystemService;
    private final ScheduledExecutorService executorService;
    private final SolverHandlerConfig config;
    private final ReentrantLock lock = new ReentrantLock();
    private AtomicReference<TaskAssigningSolution> currentSolution = new AtomicReference<Object>(null);
    private AtomicReference<TaskAssigningSolution> lastBestSolution = new AtomicReference<Object>(null);
    private AtomicBoolean onBackgroundImprovedSolutionSent = new AtomicBoolean(false);
    private AtomicReference<ScheduledFuture<?>> scheduledFuture = new AtomicReference<Object>(null);
    private SolverExecutor solverExecutor;
    private SolverHandlerContext context;
    private SolutionSynchronizer solutionSynchronizer;
    private SolutionProcessor solutionProcessor;

    public SolverHandler(SolverDef solverDef, KieServerRegistry registry, TaskAssigningRuntimeDelegate delegate, UserSystemService userSystemService, ScheduledExecutorService executorService, SolverHandlerConfig config) {
        PortablePreconditions.checkNotNull((String)"solverDef", (Object)solverDef);
        PortablePreconditions.checkNotNull((String)"registry", (Object)registry);
        PortablePreconditions.checkNotNull((String)"delegate", (Object)delegate);
        PortablePreconditions.checkNotNull((String)"userSystemService", (Object)userSystemService);
        PortablePreconditions.checkNotNull((String)"executorService", (Object)executorService);
        PortablePreconditions.checkNotNull((String)"config", (Object)config);
        this.solverDef = solverDef;
        this.registry = registry;
        this.delegate = delegate;
        this.userSystemService = userSystemService;
        this.executorService = executorService;
        this.config = config;
        this.context = new SolverHandlerContext(config.getSyncQueriesShift());
    }

    public void start() {
        this.solverExecutor = this.createSolverExecutor(this.solverDef, this.registry, (SolverEventListener<TaskAssigningSolution>)((SolverEventListener)this::onBestSolutionChange));
        this.solutionSynchronizer = this.createSolutionSynchronizer(this.solverExecutor, this.delegate, this.userSystemService, this.config.getSyncInterval(), this.config.getUsersSyncInterval(), this.context, this::onSolutionSynchronized);
        this.solutionProcessor = this.createSolutionProcessor(this.delegate, this::onSolutionProcessed, this.config.getTargetUserId(), this.config.getPublishWindowSize());
        this.executorService.execute(this.solverExecutor);
        this.executorService.execute(this.solutionSynchronizer);
        this.executorService.execute(this.solutionProcessor);
        this.solutionSynchronizer.initSolverExecutor();
    }

    public void destroy() {
        this.solverExecutor.destroy();
        this.solutionSynchronizer.destroy();
        this.solutionProcessor.destroy();
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
            LOGGER.debug("ExecutorService was successfully shutted down.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.debug("An exception was thrown during executionService graceful termination.", (Throwable)e);
            this.executorService.shutdownNow();
        }
    }

    SolverExecutor createSolverExecutor(SolverDef solverDef, KieServerRegistry registry, SolverEventListener<TaskAssigningSolution> listener) {
        return new SolverExecutor(solverDef, registry, listener);
    }

    SolutionSynchronizer createSolutionSynchronizer(SolverExecutor solverExecutor, TaskAssigningRuntimeDelegate delegate, UserSystemService userSystemService, Duration syncInterval, Duration usersSyncInterval, SolverHandlerContext context, Consumer<SolutionSynchronizer.Result> resultConsumer) {
        return new SolutionSynchronizer(solverExecutor, delegate, userSystemService, syncInterval, usersSyncInterval, context, resultConsumer);
    }

    SolutionProcessor createSolutionProcessor(TaskAssigningRuntimeDelegate delegate, Consumer<SolutionProcessor.Result> resultConsumer, String targetUserId, int publishWindowSize) {
        return new SolutionProcessor(delegate, resultConsumer, targetUserId, publishWindowSize);
    }

    private void addProblemFactChanges(List<ProblemFactChange<TaskAssigningSolution>> changes) {
        PortablePreconditions.checkNotNull((String)"changes", changes);
        if (!this.solverExecutor.isStarted()) {
            LOGGER.info("SolverExecutor has not been started. Changes will be discarded {}", changes);
            return;
        }
        if (!changes.isEmpty()) {
            this.onBackgroundImprovedSolutionSent.set(false);
            this.solverExecutor.addProblemFactChanges(changes);
        } else {
            LOGGER.info("It looks like an empty change list was provided. Nothing will be done since it has no effect on the solution.");
        }
    }

    private void onBestSolutionChange(BestSolutionChangedEvent<TaskAssigningSolution> event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("onBestSolutionChange: isEveryProblemFactChangeProcessed: {}, currentChangeSetId: {}, isCurrentChangeSetProcessed: {}, newBestSolution: {}", new Object[]{event.isEveryProblemFactChangeProcessed(), this.context.getCurrentChangeSetId(), this.context.isCurrentChangeSetProcessed(), event.getNewBestSolution()});
        }
        TaskAssigningSolution newBestSolution = (TaskAssigningSolution)event.getNewBestSolution();
        if (event.isEveryProblemFactChangeProcessed() && newBestSolution.getScore().isSolutionInitialized()) {
            this.lastBestSolution.set(newBestSolution);
            if (this.hasWaitForImprovedSolutionDuration()) {
                this.scheduleOnBestSolutionChange(newBestSolution, this.config.getWaitForImprovedSolutionDuration().toMillis());
            } else {
                this.onBestSolutionChange(newBestSolution);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleOnBestSolutionChange(TaskAssigningSolution chBestSolution, long delay) {
        if (this.scheduledFuture.get() == null && !this.context.isCurrentChangeSetProcessed()) {
            this.lock.lock();
            LOGGER.debug("Schedule execute solution change with previous chBestSolution: {}", (Object)chBestSolution);
            try {
                Supplier<TaskAssigningSolution> solutionSupplier = () -> this.lastBestSolution.get();
                ScheduledFuture<?> future = this.executorService.schedule(() -> this.executeSolutionChange(chBestSolution, solutionSupplier), delay, TimeUnit.MILLISECONDS);
                this.scheduledFuture.set(future);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void onBestSolutionChange(TaskAssigningSolution newBestSolution) {
        if (!this.context.isCurrentChangeSetProcessed()) {
            this.executeSolutionChange(newBestSolution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSolutionChange(TaskAssigningSolution chBestSolution, Supplier<TaskAssigningSolution> solutionSupplier) {
        this.lock.lock();
        try {
            TaskAssigningSolution currentLastBestSolution = solutionSupplier.get();
            LOGGER.debug("Executing delayed solution change for currentChangeSetId: {}, lastBestSolution: {}, lastBestSolution: {}", new Object[]{this.context.getCurrentChangeSetId(), currentLastBestSolution.getScore(), currentLastBestSolution});
            if (chBestSolution == currentLastBestSolution) {
                LOGGER.debug("SAME SOLUTION: lastBestSolution is the same as the chBestSolution");
            } else if (chBestSolution.getScore().compareTo(currentLastBestSolution.getScore()) < 0) {
                LOGGER.debug("SCORE IMPROVEMENT: lastBestSolution has a better score than the chBestSolution: currentChangeSetId: {}, chBestSolution: {}, chBestSolution: {}", new Object[]{this.context.getCurrentChangeSetId(), chBestSolution.getScore(), chBestSolution});
            } else {
                LOGGER.debug("SAME SCORE: lastBestSolution is not the same as the chBestSolution BUT score has not improved, currentChangeSetId: {}, chBestSolution: {}, chBestSolution: {}", new Object[]{this.context.getCurrentChangeSetId(), chBestSolution.getScore(), chBestSolution});
            }
            this.executeSolutionChange(currentLastBestSolution);
        }
        finally {
            this.scheduledFuture.set(null);
            this.lock.unlock();
        }
    }

    private void executeSolutionChange(TaskAssigningSolution solution) {
        this.lock.lock();
        try {
            this.currentSolution.set(solution);
            this.context.setProcessedChangeSet(this.context.getCurrentChangeSetId());
            this.solutionProcessor.process(this.currentSolution.get());
        }
        finally {
            this.lock.unlock();
        }
    }

    private void onSolutionProcessed(SolutionProcessor.Result result) {
        this.lock.lock();
        try {
            if (result.hasException() || result.getExecutionResult().hasError() && !this.isRecoverableError(result.getExecutionResult().getError())) {
                LOGGER.error("An error was produced during the solution processing. The solver will be restarted with a recovered solution from the jBPM runtime.", (Object)(result.hasException() ? result.getException() : result.getExecutionResult().getError()));
                this.solverExecutor.stop();
                this.context.clearProcessedChangeSet();
                this.solutionSynchronizer.initSolverExecutor();
                this.currentSolution.set(null);
                this.lastBestSolution.set(null);
                this.onBackgroundImprovedSolutionSent.set(false);
            } else if (result.getExecutionResult().hasError()) {
                LOGGER.debug("A recoverable error was produced during solution processing. errorCode: {}, message: {} Solution will be properly updated on next refresh", (Object)result.getExecutionResult().getError(), (Object)result.getExecutionResult().getErrorMessage());
                LocalDateTime fromLastModificationDate = this.context.getPreviousQueryTime();
                this.solutionSynchronizer.synchronizeSolution(this.currentSolution.get(), fromLastModificationDate);
            } else {
                LocalDateTime fromLastModificationDate = this.context.getNextQueryTime();
                this.context.clearTaskChangeTimes(this.context.getPreviousQueryTime());
                if (this.hasImproveSolutionOnBackgroundDuration() && !this.onBackgroundImprovedSolutionSent.get()) {
                    this.solutionSynchronizer.synchronizeSolution(this.currentSolution.get(), fromLastModificationDate, this.config.getImproveSolutionOnBackgroundDuration());
                } else {
                    this.solutionSynchronizer.synchronizeSolution(this.currentSolution.get(), fromLastModificationDate);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSolutionSynchronized(SolutionSynchronizer.Result result) {
        this.lock.lock();
        try {
            if (result.hasChanges()) {
                this.addProblemFactChanges(result.getChanges());
            } else {
                LOGGER.debug("Processing synchronization unchanged period timeout. Checking if there is a lastBestSolution with an improved score to send");
                TaskAssigningSolution bestSolution = this.lastBestSolution.get();
                this.onBackgroundImprovedSolutionSent.set(true);
                if (bestSolution.getScore().compareTo(this.currentSolution.get().getScore()) > 0) {
                    LOGGER.debug("About to process lastBestSolution after improveSolutionOnBackgroundDuration timeout with score: {}, lastBestSolution: {}.", (Object)bestSolution.getScore(), (Object)bestSolution);
                    this.currentSolution.set(bestSolution);
                    this.solutionProcessor.process(this.currentSolution.get());
                } else {
                    LOGGER.debug("Looks like lastBestSolution is the same as the already sent currentSolution or has the same score, nothing to do. Restarting synchronization");
                    LocalDateTime fromLastModificationDate = this.context.getNextQueryTime();
                    this.context.clearTaskChangeTimes(this.context.getPreviousQueryTime());
                    this.solutionSynchronizer.synchronizeSolution(this.currentSolution.get(), fromLastModificationDate);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isRecoverableError(PlanningExecutionResult.ErrorCode errorCode) {
        return errorCode == PlanningExecutionResult.ErrorCode.TASK_MODIFIED_SINCE_PLAN_CALCULATION_ERROR;
    }

    protected boolean hasWaitForImprovedSolutionDuration() {
        return this.config.getWaitForImprovedSolutionDuration().toMillis() > 0L;
    }

    protected boolean hasImproveSolutionOnBackgroundDuration() {
        return this.config.getImproveSolutionOnBackgroundDuration().toMillis() > 0L;
    }
}

