/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiConsumer;
import org.kie.server.api.model.taskassigning.data.LabelValueExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelValueExtractorRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(LabelValueExtractorRegistry.class);
    private static final LabelValueExtractorRegistry INSTANCE = new LabelValueExtractorRegistry();
    private Map<Class<?>, Set<LabelValueExtractor<?>>> extractorsBySourceType = new HashMap();

    private LabelValueExtractorRegistry() {
        this.registerExtractors(this.getClass().getClassLoader());
    }

    public static LabelValueExtractorRegistry getInstance() {
        return INSTANCE;
    }

    public synchronized void registerExtractors(ClassLoader classLoader) {
        ServiceLoader<LabelValueExtractor> availableExtractors = ServiceLoader.load(LabelValueExtractor.class, classLoader);
        for (LabelValueExtractor extractor : availableExtractors) {
            Set typeExtractors = this.extractorsBySourceType.computeIfAbsent(extractor.getType(), key -> new HashSet());
            LabelValueExtractor previousExtractor = typeExtractors.stream().filter(previous -> previous.getLabelName().equals(extractor.getLabelName())).findFirst().orElse(null);
            if (previousExtractor != null) {
                if (previousExtractor.getPriority() >= extractor.getPriority()) continue;
                LOGGER.info("LabelValueExtractor with [previousType: {}, previousLabelName:{}, previousPriority: {}], will be replaced with -> [type:{}, labelName:{}, priority: {}]", new Object[]{previousExtractor.getType(), previousExtractor.getLabelName(), previousExtractor.getPriority(), extractor.getType(), extractor.getLabelName(), extractor.getPriority()});
                typeExtractors.remove(previousExtractor);
                typeExtractors.add(extractor);
                continue;
            }
            typeExtractors.add(extractor);
        }
    }

    public <T> Optional<Set<LabelValueExtractor<T>>> getLabelValueExtractors(Class<T> sourceType) {
        return Optional.ofNullable(this.extractorsBySourceType.get(sourceType));
    }

    public <T> void applyLabelValueExtractors(Class<T> sourceType, T source, BiConsumer<String, Set<Object>> extractedValuesConsumer) {
        Optional<Set<LabelValueExtractor<Set>>> extractorsSet = this.getLabelValueExtractors(sourceType);
        extractorsSet.ifPresent(extractors -> extractors.forEach(valueExtractor -> {
            Set values = valueExtractor.extract(source);
            if (values != null) {
                extractedValuesConsumer.accept(valueExtractor.getLabelName(), values);
            }
        }));
    }
}

