/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.migration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jbpm.runtime.manager.impl.migration.MigrationEntry;
import org.jbpm.runtime.manager.impl.migration.MigrationException;
import org.jbpm.runtime.manager.impl.migration.MigrationSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationReport
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(MigrationReport.class);
    private static final long serialVersionUID = -5992169359542031146L;
    private MigrationSpec migrationSpec;
    private boolean successful;
    private Date startDate;
    private Date endDate;
    private List<MigrationEntry> entries = new ArrayList<MigrationEntry>();

    public MigrationReport(MigrationSpec migrationSpec) {
        this.migrationSpec = migrationSpec;
        this.startDate = new Date();
    }

    public MigrationSpec getMigrationSpec() {
        return this.migrationSpec;
    }

    public void setMigrationSpec(MigrationSpec processData) {
        this.migrationSpec = processData;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public List<MigrationEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<MigrationEntry> entries) {
        this.entries = entries;
    }

    public void addEntry(MigrationEntry.Type type, String message) throws MigrationException {
        this.entries.add(new MigrationEntry(type, message));
        switch (type) {
            case INFO: {
                logger.debug(message);
                break;
            }
            case WARN: {
                logger.warn(message);
                break;
            }
            case ERROR: {
                logger.error(message);
                this.setSuccessful(false);
                this.setEndDate(new Date());
                throw new MigrationException(message, this);
            }
        }
    }
}

