/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jbpm.services.api.admin.UserTaskAdminService;
import org.kie.api.task.model.Email;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.User;
import org.kie.internal.runtime.error.ExecutionError;
import org.kie.internal.task.api.TaskModelFactory;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.Notification;
import org.kie.server.api.model.admin.EmailNotification;
import org.kie.server.api.model.admin.ExecutionErrorInstance;
import org.kie.server.api.model.admin.ExecutionErrorInstanceList;
import org.kie.server.api.model.admin.OrgEntities;
import org.kie.server.api.model.admin.TaskNotification;
import org.kie.server.api.model.admin.TaskNotificationList;
import org.kie.server.api.model.admin.TaskReassignment;
import org.kie.server.api.model.admin.TaskReassignmentList;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.kie.server.services.jbpm.ConvertUtils;
import org.kie.server.services.jbpm.locator.ByTaskIdContainerLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTaskAdminServiceBase {
    private static final Logger logger = LoggerFactory.getLogger(UserTaskAdminServiceBase.class);
    private UserTaskAdminService userTaskAdminService;
    private MarshallerHelper marshallerHelper;
    private KieServerRegistry context;
    private TaskModelFactory factory = TaskModelProvider.getFactory();
    private Function<String, OrganizationalEntity> mapToUser = id -> this.factory.newUser(id);
    private Function<String, OrganizationalEntity> mapToGroup = id -> this.factory.newGroup(id);
    private Function<String, OrganizationalEntity> mapToEmails = id -> this.factory.newEmail(id);
    private boolean bypassAuthUser;

    public UserTaskAdminServiceBase(UserTaskAdminService userTaskAdminService, KieServerRegistry context) {
        this.userTaskAdminService = userTaskAdminService;
        this.marshallerHelper = new MarshallerHelper(context);
        this.context = context;
        this.bypassAuthUser = Boolean.parseBoolean(context.getConfig().getConfigItemValue("org.kie.server.bypass.auth.user", "false"));
    }

    public void addPotentialOwners(String containerId, Number taskId, boolean removeExisting, String payload, String marshallingType) {
        this.addPotentialOwners(null, containerId, taskId, removeExisting, payload, marshallingType);
    }

    public void addPotentialOwners(String userId, String containerId, Number taskId, boolean removeExisting, String payload, String marshallingType) {
        logger.debug("About to unmarshall payload '{}' to map of task inputs", (Object)payload);
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        OrganizationalEntity[] entities = this.convert(containerId, taskId, payload, marshallingType);
        if (!this.bypassAuthUser || userId == null) {
            this.userTaskAdminService.addPotentialOwners(containerId, taskId.longValue(), removeExisting, entities);
        } else {
            this.userTaskAdminService.addPotentialOwners(userId, containerId, taskId.longValue(), removeExisting, entities);
        }
        logger.debug("Potential owners {} added to task {}", (Object)entities, (Object)taskId);
    }

    public void addExcludedOwners(String containerId, Number taskId, boolean removeExisting, String payload, String marshallingType) {
        this.addExcludedOwners(null, containerId, taskId, removeExisting, payload, marshallingType);
    }

    public void addExcludedOwners(String userId, String containerId, Number taskId, boolean removeExisting, String payload, String marshallingType) {
        logger.debug("About to unmarshall payload '{}' to map of task inputs", (Object)payload);
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        OrganizationalEntity[] entities = this.convert(containerId, taskId, payload, marshallingType);
        if (!this.bypassAuthUser || userId == null) {
            this.userTaskAdminService.addExcludedOwners(containerId, taskId.longValue(), removeExisting, entities);
        } else {
            this.userTaskAdminService.addExcludedOwners(userId, containerId, taskId.longValue(), removeExisting, entities);
        }
        logger.debug("Excluded owners {} added to task {}", (Object)entities, (Object)taskId);
    }

    public void addBusinessAdmins(String containerId, Number taskId, boolean removeExisting, String payload, String marshallingType) {
        this.addBusinessAdmins(null, containerId, taskId, removeExisting, payload, marshallingType);
    }

    public void addBusinessAdmins(String userId, String containerId, Number taskId, boolean removeExisting, String payload, String marshallingType) {
        logger.debug("About to unmarshall payload '{}' to map of task inputs", (Object)payload);
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        OrganizationalEntity[] entities = this.convert(containerId, taskId, payload, marshallingType);
        if (!this.bypassAuthUser || userId == null) {
            this.userTaskAdminService.addBusinessAdmins(containerId, taskId.longValue(), removeExisting, entities);
        } else {
            this.userTaskAdminService.addBusinessAdmins(userId, containerId, taskId.longValue(), removeExisting, entities);
        }
        logger.debug("Business admins {} added to task {}", (Object)entities, (Object)taskId);
    }

    public void removePotentialOwners(String containerId, Number taskId, List<String> orgEntities, boolean isUser) {
        this.removePotentialOwners(null, containerId, taskId, orgEntities, isUser);
    }

    public void removePotentialOwners(String userId, String containerId, Number taskId, List<String> orgEntities, boolean isUser) {
        logger.debug("About to remove {} from task {} as potential owners", orgEntities, (Object)taskId);
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        OrganizationalEntity[] entities = this.convert(orgEntities, isUser);
        if (!this.bypassAuthUser || userId == null) {
            this.userTaskAdminService.removePotentialOwners(containerId, taskId.longValue(), entities);
        } else {
            this.userTaskAdminService.removePotentialOwners(userId, containerId, taskId.longValue(), entities);
        }
        logger.debug("Potential owners {} removed task {}", (Object)entities, (Object)taskId);
    }

    public void removeExcludedOwners(String containerId, Number taskId, List<String> orgEntities, boolean isUser) {
        this.removeExcludedOwners(null, containerId, taskId, orgEntities, isUser);
    }

    public void removeExcludedOwners(String userId, String containerId, Number taskId, List<String> orgEntities, boolean isUser) {
        logger.debug("About to remove {} from task {} as excluded owners", orgEntities, (Object)taskId);
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        OrganizationalEntity[] entities = this.convert(orgEntities, isUser);
        if (!this.bypassAuthUser || userId == null) {
            this.userTaskAdminService.removeExcludedOwners(containerId, taskId.longValue(), entities);
        } else {
            this.userTaskAdminService.removeExcludedOwners(userId, containerId, taskId.longValue(), entities);
        }
        logger.debug("Excluded owners {} removed task {}", (Object)entities, (Object)taskId);
    }

    public void removeBusinessAdmins(String containerId, Number taskId, List<String> orgEntities, boolean isUser) {
        this.removeBusinessAdmins(null, containerId, taskId, orgEntities, isUser);
    }

    public void removeBusinessAdmins(String userId, String containerId, Number taskId, List<String> orgEntities, boolean isUser) {
        logger.debug("About to remove {} from task {} as business admins", orgEntities, (Object)taskId);
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        OrganizationalEntity[] entities = this.convert(orgEntities, isUser);
        if (!this.bypassAuthUser || userId == null) {
            this.userTaskAdminService.removeBusinessAdmins(containerId, taskId.longValue(), entities);
        } else {
            this.userTaskAdminService.removeBusinessAdmins(userId, containerId, taskId.longValue(), entities);
        }
        logger.debug("Business admins {} removed task {}", (Object)entities, (Object)taskId);
    }

    public void addTaskInputs(String containerId, Number taskId, String payload, String marshallingType) {
        logger.debug("About to unmarshall payload '{}' to map of task inputs", (Object)payload);
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        Map data = (Map)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, Map.class);
        logger.debug("Task input data to be added to a task {} is {}", (Object)taskId, (Object)data);
        this.userTaskAdminService.addTaskInputs(containerId, taskId.longValue(), data);
        logger.debug("Task inputs {} added successfully to task {}", (Object)data, (Object)taskId);
    }

    public void removeTaskInputs(String containerId, Number taskId, List<String> inputNames) {
        logger.debug("About to remove task inputs {} from task {}", inputNames, (Object)taskId);
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        this.userTaskAdminService.removeTaskInputs(containerId, taskId.longValue(), inputNames.toArray(new String[inputNames.size()]));
        logger.debug("Task inputs {} removed successfully from task {}", inputNames, (Object)taskId);
    }

    public void removeTaskOutputs(String containerId, Number taskId, List<String> outputNames) {
        logger.debug("About to remove task outputs {} from task {}", outputNames, (Object)taskId);
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        this.userTaskAdminService.removeTaskOutputs(containerId, taskId.longValue(), outputNames.toArray(new String[outputNames.size()]));
        logger.debug("Task outputs {} removed successfully from task {}", outputNames, (Object)taskId);
    }

    public String reassignWhenNotStarted(String containerId, Number taskId, String timeExpression, String payload, String marshallingType) {
        logger.debug("About to unmarshall payload '{}' to list of org entities (users/groups)", (Object)payload);
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        OrganizationalEntity[] entities = this.convert(containerId, taskId, payload, marshallingType);
        Long id = this.userTaskAdminService.reassignWhenNotStarted(containerId, taskId.longValue(), timeExpression, entities);
        logger.debug("Reassignment (when not started) to {} successfully created for task {} to fire at {}", new Object[]{entities, taskId, timeExpression});
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)id, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        return response;
    }

    public String reassignWhenNotCompleted(String containerId, Number taskId, String timeExpression, String payload, String marshallingType) {
        logger.debug("About to unmarshall payload '{}' to list of org entities (users/groups)", (Object)payload);
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        OrganizationalEntity[] entities = this.convert(containerId, taskId, payload, marshallingType);
        Long id = this.userTaskAdminService.reassignWhenNotCompleted(containerId, taskId.longValue(), timeExpression, entities);
        logger.debug("Reassignment (when not completed) to {} successfully created for task {} to fire at {}", new Object[]{entities, taskId, timeExpression});
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)id, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        return response;
    }

    public String notifyWhenNotStarted(String containerId, Number taskId, String timeExpression, String payload, String marshallingType) {
        logger.debug("About to unmarshall payload '{}' to EmailNotification (when not started) of task inputs", (Object)payload);
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        EmailNotification emailNotification = (EmailNotification)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, EmailNotification.class, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        logger.debug("Email notification to be added to a task {} is {}", (Object)taskId, (Object)emailNotification);
        org.kie.internal.task.api.model.EmailNotification email = this.buildEmail(emailNotification);
        Long id = this.userTaskAdminService.notifyWhenNotStarted(containerId, taskId.longValue(), timeExpression, (Notification)email);
        logger.debug("Email notification (when not started) {} added successfully to task {} to be fired after {}", new Object[]{emailNotification, taskId, timeExpression});
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)id, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        return response;
    }

    public String notifyWhenNotCompleted(String containerId, Number taskId, String timeExpression, String payload, String marshallingType) {
        logger.debug("About to unmarshall payload '{}' to EmailNotification (when not completed) of task inputs", (Object)payload);
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        EmailNotification emailNotification = (EmailNotification)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, EmailNotification.class, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        logger.debug("Email notification to be added to a task {} is {}", (Object)taskId, (Object)emailNotification);
        org.kie.internal.task.api.model.EmailNotification email = this.buildEmail(emailNotification);
        Long id = this.userTaskAdminService.notifyWhenNotCompleted(containerId, taskId.longValue(), timeExpression, (Notification)email);
        logger.debug("Email notification (when not completed) {} added successfully to task {} to be fired after {}", new Object[]{emailNotification, taskId, timeExpression});
        String response = this.marshallerHelper.marshal(containerId, marshallingType, (Object)id, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        return response;
    }

    public void cancelNotification(String containerId, Number taskId, Number notificationId) {
        logger.debug("About to cancel notification {} from task {}", (Object)notificationId, (Object)taskId);
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        this.userTaskAdminService.cancelNotification(containerId, taskId.longValue(), notificationId.longValue());
        logger.debug("Notification {} canceled successfully for task {}", (Object)notificationId, (Object)taskId);
    }

    public void cancelReassignment(String containerId, Number taskId, Number reassignmentId) {
        logger.debug("About to cancel reassignment {} from task {}", (Object)reassignmentId, (Object)taskId);
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        this.userTaskAdminService.cancelReassignment(containerId, taskId.longValue(), reassignmentId.longValue());
        logger.debug("Reassignment {} canceled successfully for task {}", (Object)reassignmentId, (Object)taskId);
    }

    public TaskReassignmentList getTaskReassignments(String containerId, Number taskId, boolean activeOnly) {
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        Collection reassignments = this.userTaskAdminService.getTaskReassignments(containerId, taskId.longValue(), activeOnly);
        List converted = reassignments.stream().map(r -> TaskReassignment.builder().id(r.getId()).active(Boolean.valueOf(r.isActive())).name(r.getName()).reassignAt(r.getDate()).users(r.getPotentialOwners().stream().filter(oe -> oe instanceof User).map(oe -> oe.getId()).collect(Collectors.toList())).groups(r.getPotentialOwners().stream().filter(oe -> oe instanceof Group).map(oe -> oe.getId()).collect(Collectors.toList())).build()).collect(Collectors.toList());
        return new TaskReassignmentList(converted);
    }

    public TaskNotificationList getTaskNotifications(String containerId, Number taskId, boolean activeOnly) {
        containerId = this.context.getContainerId(containerId, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        Collection notifications = this.userTaskAdminService.getTaskNotifications(containerId, taskId.longValue(), activeOnly);
        List converted = notifications.stream().map(r -> TaskNotification.builder().id(r.getId()).active(Boolean.valueOf(r.isActive())).name(r.getName()).subject(r.getSubject()).content(r.getContent()).notifyAt(r.getDate()).users(r.getRecipients().stream().filter(oe -> oe instanceof User).map(OrganizationalEntity::getId).collect(Collectors.toList())).groups(r.getRecipients().stream().filter(oe -> oe instanceof Group).map(OrganizationalEntity::getId).collect(Collectors.toList())).emails(r.getRecipients().stream().filter(oe -> oe instanceof Email).map(OrganizationalEntity::getId).collect(Collectors.toList())).build()).collect(Collectors.toList());
        return new TaskNotificationList(converted);
    }

    public ExecutionErrorInstanceList getExecutionErrorsByTaskId(String containerId, Number taskId, boolean includeAcknowledged, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        logger.debug("About to get execution errors for task id {}", (Object)taskId);
        List errors = this.userTaskAdminService.getErrorsByTaskId(taskId.longValue(), includeAcknowledged, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder));
        logger.debug("Found errors {}", (Object)errors);
        ExecutionErrorInstanceList errorInstanceList = ConvertUtils.convertToErrorInstanceList(errors);
        return errorInstanceList;
    }

    public ExecutionErrorInstanceList getExecutionErrorsByTaskName(String containerId, String processId, String taskName, boolean includeAcknowledged, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        logger.debug("About to get execution errors for task name {} in process {} and container {}", new Object[]{taskName, processId, containerId});
        List errors = null;
        errors = containerId != null && !containerId.isEmpty() ? this.userTaskAdminService.getErrorsByTaskName(containerId, processId, taskName, includeAcknowledged, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder)) : (processId != null && !processId.isEmpty() ? this.userTaskAdminService.getErrorsByTaskName(processId, taskName, includeAcknowledged, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder)) : (taskName != null && !taskName.isEmpty() ? this.userTaskAdminService.getErrorsByTaskName(taskName, includeAcknowledged, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder)) : this.userTaskAdminService.getErrors(includeAcknowledged, ConvertUtils.buildQueryContext(page, pageSize, sort, sortOrder))));
        logger.debug("Found errors {}", (Object)errors);
        ExecutionErrorInstanceList errorInstanceList = ConvertUtils.convertToErrorInstanceList(errors);
        return errorInstanceList;
    }

    public ExecutionErrorInstance getError(String errorId) {
        logger.debug("About to get execution error for {}", (Object)errorId);
        ExecutionError error = this.userTaskAdminService.getError(errorId);
        logger.debug("Found error {} for error id {}", (Object)error, (Object)errorId);
        return ConvertUtils.convertToErrorInstance(error);
    }

    public void acknowledgeError(List<String> errorIds) {
        logger.debug("About to acknowledge execution error with id {}", errorIds);
        String[] errors = errorIds.toArray(new String[errorIds.size()]);
        this.userTaskAdminService.acknowledgeError(errors);
        logger.debug("Error {} successfully acknowledged", errorIds);
    }

    protected OrganizationalEntity[] convert(List<String> orgEntities, boolean isUser) {
        return (OrganizationalEntity[])orgEntities.stream().map(isUser ? this.mapToUser : this.mapToGroup).toArray(OrganizationalEntity[]::new);
    }

    protected org.kie.internal.task.api.model.EmailNotification buildEmail(EmailNotification emailNotification) {
        ArrayList recipients = new ArrayList();
        if (emailNotification.getUsers() != null) {
            recipients.addAll(emailNotification.getUsers().stream().map(this.mapToUser).collect(Collectors.toList()));
        }
        if (emailNotification.getGroups() != null) {
            recipients.addAll(emailNotification.getGroups().stream().map(this.mapToGroup).collect(Collectors.toList()));
        }
        if (emailNotification.getEmails() != null) {
            recipients.addAll(emailNotification.getEmails().stream().map(this.mapToEmails).collect(Collectors.toList()));
        }
        org.kie.internal.task.api.model.EmailNotification email = this.userTaskAdminService.buildEmailNotification(emailNotification.getSubject(), recipients, emailNotification.getBody(), emailNotification.getFrom(), emailNotification.getReplyTo());
        return email;
    }

    protected OrganizationalEntity[] convert(String containerId, Number taskId, String payload, String marshallingType) {
        OrgEntities orgEntities = (OrgEntities)this.marshallerHelper.unmarshal(containerId, payload, marshallingType, OrgEntities.class, (ContainerLocator)new ByTaskIdContainerLocator(taskId.longValue()));
        ArrayList entities = new ArrayList();
        if (orgEntities.getUsers() != null) {
            entities.addAll(orgEntities.getUsers().stream().map(this.mapToUser).collect(Collectors.toList()));
        }
        if (orgEntities.getGroups() != null) {
            entities.addAll(orgEntities.getGroups().stream().map(this.mapToGroup).collect(Collectors.toList()));
        }
        return entities.toArray(new OrganizationalEntity[entities.size()]);
    }
}

