/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.simplelong;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class SimpleLongScoreHolder
extends AbstractScoreHolder<SimpleLongScore> {
    protected final Map<Rule, BiConsumer<RuleContext, Long>> matchExecutorByNumberMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, Long>>();
    protected long score;

    public SimpleLongScoreHolder(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled, SimpleLongScore.ZERO);
    }

    public long getScore() {
        return this.score;
    }

    @Override
    public void configureConstraintWeight(Rule rule, SimpleLongScore constraintWeight) {
        super.configureConstraintWeight(rule, constraintWeight);
        BiConsumer<RuleContext, Long> matchExecutor = constraintWeight.equals(SimpleLongScore.ZERO) ? (kcontext, matchWeight) -> {} : (kcontext, matchWeight) -> this.addConstraintMatch((RuleContext)kcontext, constraintWeight.getScore() * matchWeight);
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
    }

    public void penalize(RuleContext kcontext) {
        this.impactScore(kcontext, -1L);
    }

    public void penalize(RuleContext kcontext, long weightMultiplier) {
        this.impactScore(kcontext, -weightMultiplier);
    }

    public void reward(RuleContext kcontext) {
        this.impactScore(kcontext, 1L);
    }

    public void reward(RuleContext kcontext, long weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext) {
        this.impactScore(kcontext, 1L);
    }

    @Override
    public void impactScore(RuleContext kcontext, long weightMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, Long> matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier);
    }

    public void addConstraintMatch(RuleContext kcontext, long weight) {
        this.score += weight;
        this.registerConstraintMatch(kcontext, () -> this.score -= weight, () -> SimpleLongScore.of(weight));
    }

    @Override
    public SimpleLongScore extractScore(int initScore) {
        return SimpleLongScore.ofUninitialized(initScore, this.score);
    }
}

