/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.core.model.solver.realtime;

import java.util.ArrayList;
import org.kie.server.services.taskassigning.core.model.TaskAssigningSolution;
import org.kie.server.services.taskassigning.core.model.User;
import org.kie.server.services.taskassigning.core.model.solver.realtime.ProblemFactChangeUtil;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;

public class RemoveUserProblemFactChange
implements ProblemFactChange<TaskAssigningSolution> {
    private User user;

    public RemoveUserProblemFactChange(User user) {
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    public void doChange(ScoreDirector<TaskAssigningSolution> scoreDirector) {
        TaskAssigningSolution workingSolution = (TaskAssigningSolution)scoreDirector.getWorkingSolution();
        User workingUser = (User)scoreDirector.lookUpWorkingObjectOrReturnNull((Object)this.user);
        if (workingUser == null) {
            return;
        }
        if (workingUser.isEnabled()) {
            scoreDirector.beforeProblemPropertyChanged((Object)workingUser);
            workingUser.setEnabled(false);
            scoreDirector.afterProblemPropertyChanged((Object)workingUser);
        }
        ProblemFactChangeUtil.releaseAllTasks(workingUser, scoreDirector);
        workingSolution.setUserList(new ArrayList<User>(workingSolution.getUserList()));
        scoreDirector.beforeProblemFactRemoved((Object)workingUser);
        workingSolution.getUserList().remove(workingUser);
        scoreDirector.afterProblemFactRemoved((Object)workingUser);
        scoreDirector.triggerVariableListeners();
    }
}

