/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.impl.simulators;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jbpm.simulation.ActivitySimulator;
import org.jbpm.simulation.SimulationContext;
import org.jbpm.simulation.SimulationDataProvider;
import org.jbpm.simulation.SimulationEvent;
import org.jbpm.simulation.impl.events.GatewaySimulationEvent;
import org.kie.api.definition.process.Node;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;

public class GatewaySimulator
implements ActivitySimulator {
    @Override
    public SimulationEvent simulate(Object activity, SimulationContext context) {
        NodeInstance gateway = (NodeInstance)activity;
        long startTime = context.getClock().getCurrentTime();
        Map metadata = gateway.getNode().getMetaData();
        WorkflowProcessInstance pi = gateway.getProcessInstance();
        Node node = gateway.getNode();
        String bpmn2NodeId = (String)metadata.get("UniqueId");
        long duration = 0L;
        long endTime = startTime + duration;
        context.getClock().advanceTime(duration, TimeUnit.MILLISECONDS);
        context.setMaxEndTime(context.getClock().getCurrentTime());
        SimulationDataProvider provider = context.getDataProvider();
        String type = (String)provider.getProcessDataForNode(node).get("node.type");
        return new GatewaySimulationEvent(pi.getProcessId(), context.getProcessInstanceId(), startTime, endTime, bpmn2NodeId, node.getName(), type);
    }
}

