/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import java.io.IOException;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.spatial.prefix.AbstractVisitingPrefixTreeQuery;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.Bits;
import org.locationtech.spatial4j.shape.Shape;

public class PrefixTreeFacetCounter {
    private PrefixTreeFacetCounter() {
    }

    public static void compute(PrefixTreeStrategy strategy, IndexReaderContext context, final Bits topAcceptDocs, Shape queryShape, int facetLevel, FacetVisitor facetVisitor) throws IOException {
        for (final LeafReaderContext leafCtx : context.leaves()) {
            Bits leafAcceptDocs = topAcceptDocs == null ? leafCtx.reader().getLiveDocs() : new Bits(){

                public boolean get(int index) {
                    return topAcceptDocs.get(leafCtx.docBase + index);
                }

                public int length() {
                    return leafCtx.reader().maxDoc();
                }
            };
            PrefixTreeFacetCounter.compute(strategy, leafCtx, leafAcceptDocs, queryShape, facetLevel, facetVisitor);
        }
    }

    public static void compute(PrefixTreeStrategy strategy, final LeafReaderContext context, final Bits acceptDocs, Shape queryShape, final int facetLevel, final FacetVisitor facetVisitor) throws IOException {
        if (acceptDocs != null && acceptDocs.length() != context.reader().maxDoc()) {
            throw new IllegalArgumentException("acceptDocs bits length " + acceptDocs.length() + " != leaf maxdoc " + context.reader().maxDoc());
        }
        SpatialPrefixTree tree = strategy.getGrid();
        int scanLevel = tree.getMaxLevels();
        new AbstractVisitingPrefixTreeQuery(queryShape, strategy.getFieldName(), tree, facetLevel, scanLevel){

            public String toString(String field) {
                return "anonPrefixTreeQuery";
            }

            @Override
            public DocIdSet getDocIdSet(LeafReaderContext contexts) throws IOException {
                assert (facetLevel == this.detailLevel);
                return new AbstractVisitingPrefixTreeQuery.VisitorTemplate(context){

                    @Override
                    protected void start() throws IOException {
                        facetVisitor.startOfSegment();
                    }

                    @Override
                    protected DocIdSet finish() throws IOException {
                        return null;
                    }

                    @Override
                    protected boolean visitPrefix(Cell cell) throws IOException {
                        if (cell.getLevel() == facetLevel) {
                            this.visitLeaf(cell);
                            return false;
                        }
                        return cell.getLevel() != facetLevel - 1 && this.termsEnum.docFreq() != 1 || this.hasDocsAtThisTerm();
                    }

                    @Override
                    protected void visitLeaf(Cell cell) throws IOException {
                        int count = this.countDocsAtThisTerm();
                        if (count > 0) {
                            facetVisitor.visit(cell, count);
                        }
                    }

                    private int countDocsAtThisTerm() throws IOException {
                        if (acceptDocs == null) {
                            return this.termsEnum.docFreq();
                        }
                        int count = 0;
                        this.postingsEnum = this.termsEnum.postings(this.postingsEnum, 0);
                        while (this.postingsEnum.nextDoc() != Integer.MAX_VALUE) {
                            if (!acceptDocs.get(this.postingsEnum.docID())) continue;
                            ++count;
                        }
                        return count;
                    }

                    private boolean hasDocsAtThisTerm() throws IOException {
                        if (acceptDocs == null) {
                            return true;
                        }
                        this.postingsEnum = this.termsEnum.postings(this.postingsEnum, 0);
                        int nextDoc = this.postingsEnum.nextDoc();
                        while (nextDoc != Integer.MAX_VALUE && !acceptDocs.get(nextDoc)) {
                            nextDoc = this.postingsEnum.nextDoc();
                        }
                        return nextDoc != Integer.MAX_VALUE;
                    }
                }.getDocIdSet();
            }
        }.getDocIdSet(context);
    }

    public static abstract class FacetVisitor {
        public void startOfSegment() {
        }

        public abstract void visit(Cell var1, int var2);
    }
}

