/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLFactoryFactory {
    private static final String KIE_PMML_MODEL_FACTORY_TEMPLATE_JAVA = "KiePMMLModelFactoryTemplate.tmpl";
    private static final String KIE_PMML_MODEL_FACTORY_TEMPLATE = "KiePMMLModelFactoryTemplate";
    private static final String KIE_PMML_MODELS_FIELD = "KIE_PMML_MODELS";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLFactoryFactory.class.getName());

    private KiePMMLFactoryFactory() {
    }

    public static Map<String, String> getFactorySourceCode(String factoryClassName, String packageName, Map<String, PMML_MODEL> generatedClassesModelTypeMap) {
        logger.trace("getFactorySourceCode {} {} {}", new Object[]{factoryClassName, packageName, generatedClassesModelTypeMap});
        String fullClassName = packageName + "." + factoryClassName;
        HashMap<String, String> toReturn = new HashMap<String, String>();
        CompilationUnit templateCU = JavaParserUtils.getFromFileName(KIE_PMML_MODEL_FACTORY_TEMPLATE_JAVA);
        CompilationUnit cloneCU = templateCU.clone();
        cloneCU.setPackageDeclaration(packageName);
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_MODEL_FACTORY_TEMPLATE).orElseThrow(() -> new RuntimeException("Main class not found"));
        modelTemplate.setName(factoryClassName);
        FieldDeclaration fieldByName = (FieldDeclaration)modelTemplate.getFieldByName(KIE_PMML_MODELS_FIELD).orElseThrow(() -> new KiePMMLException(String.format("Failed to find FieldDeclaration %s in template %s", KIE_PMML_MODELS_FIELD, KIE_PMML_MODEL_FACTORY_TEMPLATE_JAVA)));
        KiePMMLFactoryFactory.populateKiePmmlFields(fieldByName, generatedClassesModelTypeMap);
        toReturn.put(fullClassName, cloneCU.toString());
        return toReturn;
    }

    static void populateKiePmmlFields(FieldDeclaration toPopulate, Map<String, PMML_MODEL> generatedClassesModelTypeMap) {
        VariableDeclarator variable = toPopulate.getVariable(0);
        Set methodCallExpressions = generatedClassesModelTypeMap.entrySet().stream().map(entry -> KiePMMLFactoryFactory.getInstantiationExpression((String)entry.getKey(), (PMML_MODEL)entry.getValue())).collect(Collectors.toSet());
        NodeList expressions = NodeList.nodeList(methodCallExpressions);
        MethodCallExpr initializer = new MethodCallExpr((Expression)new NameExpr("Arrays"), "asList", expressions);
        variable.setInitializer((Expression)initializer);
    }

    static Expression getInstantiationExpression(String kiePMMLModelClass, PMML_MODEL pmmlModel) {
        ClassOrInterfaceType classOrInterfaceType = StaticJavaParser.parseClassOrInterfaceType((String)kiePMMLModelClass);
        switch (pmmlModel) {
            case REGRESSION_MODEL: {
                MethodCallExpr methodCallExpr = new MethodCallExpr();
                methodCallExpr.setScope((Expression)new NameExpr(kiePMMLModelClass));
                methodCallExpr.setName("getModel");
                return methodCallExpr;
            }
        }
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(classOrInterfaceType);
        return objectCreationExpr;
    }
}

