/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.InitializerDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;

public class CommonCodegenUtils {
    static final String LAMBDA_PARAMETER_NAME = "lmbdParam";
    public static String OPTIONAL_FILTERED_KIEPMMLNAMEVALUE_NAME = "kiePMMLNameValue";

    private CommonCodegenUtils() {
    }

    public static void populateMethodDeclarations(ClassOrInterfaceDeclaration toPopulate, Collection<MethodDeclaration> methodDeclarations) {
        methodDeclarations.forEach(arg_0 -> ((ClassOrInterfaceDeclaration)toPopulate).addMember(arg_0));
    }

    public static ExpressionStmt getFilteredKiePMMLNameValueExpression(String kiePMMLNameValueListParam, String fieldNameToRef, boolean stringLiteralComparison) {
        MethodCallExpr argumentBodyExpressionArgument2 = new MethodCallExpr("getName", new Expression[0]);
        argumentBodyExpressionArgument2.setScope((Expression)new NameExpr(LAMBDA_PARAMETER_NAME));
        MethodCallExpr argumentBodyExpression = new MethodCallExpr("equals", new Expression[0]);
        Object equalsComparisonExpression = stringLiteralComparison ? new StringLiteralExpr(fieldNameToRef) : new NameExpr(fieldNameToRef);
        argumentBodyExpression.setArguments(NodeList.nodeList((Node[])new Expression[]{equalsComparisonExpression, argumentBodyExpressionArgument2}));
        argumentBodyExpression.setScope((Expression)new NameExpr(Objects.class.getName()));
        ExpressionStmt argumentBody = new ExpressionStmt((Expression)argumentBodyExpression);
        Parameter argumentParameter = new Parameter((Type)StaticJavaParser.parseClassOrInterfaceType((String)KiePMMLNameValue.class.getName()), LAMBDA_PARAMETER_NAME);
        LambdaExpr argument = new LambdaExpr();
        argument.setEnclosingParameters(true).setParameters(NodeList.nodeList((Node[])new Parameter[]{argumentParameter}));
        argument.setBody((Statement)argumentBody);
        MethodCallExpr initializerScopeScope = new MethodCallExpr("stream", new Expression[0]);
        initializerScopeScope.setScope((Expression)new NameExpr(kiePMMLNameValueListParam));
        MethodCallExpr initializerScope = new MethodCallExpr("filter", new Expression[0]);
        initializerScope.setScope((Expression)initializerScopeScope);
        initializerScope.setArguments(NodeList.nodeList((Node[])new Expression[]{argument}));
        MethodCallExpr initializer = new MethodCallExpr("findFirst", new Expression[0]);
        initializer.setScope((Expression)initializerScope);
        VariableDeclarator variableDeclarator = new VariableDeclarator((Type)CommonCodegenUtils.getTypedClassOrInterfaceTypeByTypeNames(Optional.class.getName(), Collections.singletonList(KiePMMLNameValue.class.getName())), OPTIONAL_FILTERED_KIEPMMLNAMEVALUE_NAME);
        variableDeclarator.setInitializer((Expression)initializer);
        VariableDeclarationExpr variableDeclarationExpr = new VariableDeclarationExpr(NodeList.nodeList((Node[])new VariableDeclarator[]{variableDeclarator}));
        ExpressionStmt toReturn = new ExpressionStmt();
        toReturn.setExpression((Expression)variableDeclarationExpr);
        return toReturn;
    }

    public static void addMapPopulation(Map<String, MethodDeclaration> toAdd, BlockStmt body, String mapName) {
        Map<String, Expression> toAddExpr = toAdd.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            MethodReferenceExpr methodReferenceExpr = new MethodReferenceExpr();
            methodReferenceExpr.setScope((Expression)new ThisExpr());
            methodReferenceExpr.setIdentifier(((MethodDeclaration)entry.getValue()).getNameAsString());
            return methodReferenceExpr;
        }));
        CommonCodegenUtils.addMapPopulationExpressions(toAddExpr, body, mapName);
    }

    public static void createHashMap(BlockStmt body, String mapName, List<String> mapTypes) {
        CommonCodegenUtils.createMap(body, mapName, mapTypes, HashMap.class);
    }

    public static void createLinkedHashMap(BlockStmt body, String mapName, List<String> mapTypes) {
        CommonCodegenUtils.createMap(body, mapName, mapTypes, LinkedHashMap.class);
    }

    public static void createPopulatedHashMap(BlockStmt body, String mapName, List<String> mapTypes, Map<String, Expression> toAdd) {
        CommonCodegenUtils.createHashMap(body, mapName, mapTypes);
        CommonCodegenUtils.addMapPopulationExpressions(toAdd, body, mapName);
    }

    public static void createPopulatedLinkedHashMap(BlockStmt body, String mapName, List<String> mapTypes, Map<String, Expression> toAdd) {
        CommonCodegenUtils.createLinkedHashMap(body, mapName, mapTypes);
        CommonCodegenUtils.addMapPopulationExpressions(toAdd, body, mapName);
    }

    public static void addMapPopulationExpressions(Map<String, Expression> toAdd, BlockStmt body, String mapName) {
        toAdd.forEach((key, value) -> {
            NodeList expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(key), value});
            body.addStatement((Expression)new MethodCallExpr((Expression)new NameExpr(mapName), "put", expressions));
        });
    }

    public static void addListPopulationByObjectCreationExpr(List<ObjectCreationExpr> toAdd, BlockStmt body, String listName) {
        toAdd.forEach(objectCreationExpr -> {
            NodeList arguments = NodeList.nodeList((Node[])new Expression[]{objectCreationExpr});
            MethodCallExpr methodCallExpr = new MethodCallExpr();
            methodCallExpr.setScope((Expression)new NameExpr(listName));
            methodCallExpr.setName("add");
            methodCallExpr.setArguments(arguments);
            ExpressionStmt expressionStmt = new ExpressionStmt();
            expressionStmt.setExpression((Expression)methodCallExpr);
            body.addStatement((Statement)expressionStmt);
        });
    }

    public static void populateListInListGetter(List<? extends Expression> toAdd, MethodDeclaration methodDeclaration, String listName) {
        BlockStmt body = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing expected body in method %s", methodDeclaration)));
        Optional<ReturnStmt> oldReturn = body.getStatements().parallelStream().filter(statement -> statement instanceof ReturnStmt).map(ReturnStmt.class::cast).findFirst();
        oldReturn.ifPresent(Node::remove);
        toAdd.forEach(expression -> {
            NodeList arguments = NodeList.nodeList((Node[])new Expression[]{expression});
            MethodCallExpr methodCallExpr = new MethodCallExpr();
            methodCallExpr.setScope((Expression)new NameExpr(listName));
            methodCallExpr.setName("add");
            methodCallExpr.setArguments(arguments);
            ExpressionStmt expressionStmt = new ExpressionStmt();
            expressionStmt.setExpression((Expression)methodCallExpr);
            body.addStatement((Statement)expressionStmt);
        });
        body.addStatement((Statement)CommonCodegenUtils.getReturnStmt(listName));
    }

    public static void addListPopulationByMethodCallExpr(List<MethodCallExpr> toAdd, BlockStmt body, String listName) {
        toAdd.forEach(methodCallExpr1 -> {
            NodeList arguments = NodeList.nodeList((Node[])new Expression[]{methodCallExpr1});
            MethodCallExpr methodCallExpr = new MethodCallExpr();
            methodCallExpr.setScope((Expression)new NameExpr(listName));
            methodCallExpr.setName("add");
            methodCallExpr.setArguments(arguments);
            ExpressionStmt expressionStmt = new ExpressionStmt();
            expressionStmt.setExpression((Expression)methodCallExpr);
            body.addStatement((Statement)expressionStmt);
        });
    }

    public static ExpressionStmt createArraysAsListExpression() {
        ExpressionStmt toReturn = new ExpressionStmt();
        MethodCallExpr arraysCallExpression = new MethodCallExpr();
        SimpleName arraysName = new SimpleName(Arrays.class.getName());
        arraysCallExpression.setScope((Expression)new NameExpr(arraysName));
        arraysCallExpression.setName(new SimpleName("asList"));
        toReturn.setExpression((Expression)arraysCallExpression);
        return toReturn;
    }

    public static ExpressionStmt createArraysAsListFromList(List<?> source) {
        ExpressionStmt toReturn = CommonCodegenUtils.createArraysAsListExpression();
        MethodCallExpr arraysCallExpression = toReturn.getExpression().asMethodCallExpr();
        NodeList arguments = new NodeList();
        source.forEach(value -> arguments.add((Node)CommonCodegenUtils.getExpressionForObject(value)));
        arraysCallExpression.setArguments(arguments);
        toReturn.setExpression((Expression)arraysCallExpression);
        return toReturn;
    }

    public static MethodDeclaration getMethodDeclaration(String methodName, Map<String, ClassOrInterfaceType> parameterNameTypeMap) {
        MethodDeclaration toReturn = CommonCodegenUtils.getMethodDeclaration(methodName);
        NodeList typeParameters = new NodeList();
        parameterNameTypeMap.forEach((parameterName, classOrInterfaceType) -> {
            Parameter toAdd = new Parameter();
            toAdd.setName(parameterName);
            toAdd.setType((Type)classOrInterfaceType);
            typeParameters.add((Node)toAdd);
        });
        toReturn.setParameters(typeParameters);
        return toReturn;
    }

    public static MethodDeclaration getMethodDeclaration(String methodName) {
        MethodDeclaration toReturn = new MethodDeclaration();
        toReturn.setName(methodName);
        return toReturn;
    }

    public static ReturnStmt getReturnStmt(String returnedVariableName) {
        ReturnStmt toReturn = new ReturnStmt();
        toReturn.setExpression((Expression)new NameExpr(returnedVariableName));
        return toReturn;
    }

    public static ClassOrInterfaceType getTypedClassOrInterfaceTypeByTypeNames(String className, List<String> typesName) {
        List<Type> types = typesName.stream().map(StaticJavaParser::parseClassOrInterfaceType).collect(Collectors.toList());
        return CommonCodegenUtils.getTypedClassOrInterfaceTypeByTypes(className, types);
    }

    public static ClassOrInterfaceType getTypedClassOrInterfaceTypeByTypes(String className, List<Type> types) {
        ClassOrInterfaceType toReturn = StaticJavaParser.parseClassOrInterfaceType((String)className);
        toReturn.setTypeArguments(NodeList.nodeList(types));
        return toReturn;
    }

    public static void setAssignExpressionValue(BlockStmt body, String assignExpressionName, Expression value) {
        AssignExpr assignExpr = CommonCodegenUtils.getAssignExpression(body, assignExpressionName).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", assignExpressionName, body)));
        assignExpr.setValue(value);
    }

    public static Optional<AssignExpr> getAssignExpression(BlockStmt body, String assignExpressionName) {
        List assignExprs = body.findAll(AssignExpr.class);
        return assignExprs.stream().filter(assignExpr -> assignExpressionName.equals(assignExpr.getTarget().asNameExpr().getNameAsString())).findFirst();
    }

    public static Optional<ExplicitConstructorInvocationStmt> getExplicitConstructorInvocationStmt(BlockStmt body) {
        return body.getStatements().stream().filter(ExplicitConstructorInvocationStmt.class::isInstance).map(ExplicitConstructorInvocationStmt.class::cast).findFirst();
    }

    public static void setConstructorDeclarationParameterArgument(ConstructorDeclaration constructorDeclaration, String parameterName, String value) {
        BlockStmt body = constructorDeclaration.getBody();
        ExplicitConstructorInvocationStmt superStatement = CommonCodegenUtils.getExplicitConstructorInvocationStmt(body).orElseThrow(() -> new KiePMMLException(String.format("Missing constructor invocation in body %s", body)));
        NameExpr parameterExpr = CommonCodegenUtils.getExplicitConstructorInvocationParameter(superStatement, parameterName).orElseThrow(() -> new KiePMMLException(String.format("Missing expected parameter %s in constructor invocation %s", parameterName, constructorDeclaration)));
        if (value != null) {
            parameterExpr.setName(value);
        } else {
            superStatement.getArguments().replace((Node)parameterExpr, (Node)new NullLiteralExpr());
        }
    }

    public static void setConstructorDeclarationReferenceArgument(ConstructorDeclaration constructorDeclaration, String referenceName, String value) {
        BlockStmt body = constructorDeclaration.getBody();
        ExplicitConstructorInvocationStmt superStatement = CommonCodegenUtils.getExplicitConstructorInvocationStmt(body).orElseThrow(() -> new KiePMMLException(String.format("Missing constructor invocation in body %s", body)));
        MethodReferenceExpr methodReferenceExpr = CommonCodegenUtils.getExplicitConstructorInvocationMethodReference(superStatement, referenceName).orElseThrow(() -> new KiePMMLException(String.format("Missing expected parameter %s in constructor invocation %s", referenceName, constructorDeclaration)));
        if (value != null) {
            methodReferenceExpr.setScope((Expression)new TypeExpr((Type)StaticJavaParser.parseClassOrInterfaceType((String)value)));
        } else {
            superStatement.getArguments().replace((Node)methodReferenceExpr, (Node)new NullLiteralExpr());
        }
    }

    public static void setExplicitConstructorInvocationStmtArgument(ExplicitConstructorInvocationStmt constructorInvocationStmt, String parameterName, String value) {
        NameExpr parameterExpr = CommonCodegenUtils.getExplicitConstructorInvocationParameter(constructorInvocationStmt, parameterName).orElseThrow(() -> new KiePMMLException(String.format("Missing expected parameter %s in constructor invocation %s", parameterName, constructorInvocationStmt)));
        parameterExpr.setName(value);
    }

    public static BlockStmt getInitializerBlockStmt(ClassOrInterfaceDeclaration classOrInterfaceDeclaration) {
        return CommonCodegenUtils.getInitializerDeclaration(classOrInterfaceDeclaration).getBody();
    }

    public static InitializerDeclaration getInitializerDeclaration(ClassOrInterfaceDeclaration classOrInterfaceDeclaration) {
        return classOrInterfaceDeclaration.getMembers().stream().filter(InitializerDeclaration.class::isInstance).map(InitializerDeclaration.class::cast).findFirst().orElseThrow(() -> new KiePMMLException(String.format("Missing expected static initializer in class %s", classOrInterfaceDeclaration)));
    }

    public static Optional<NameExpr> getExplicitConstructorInvocationParameter(ExplicitConstructorInvocationStmt constructorInvocationStmt, String parameterName) {
        return constructorInvocationStmt.getArguments().stream().filter(expression -> expression instanceof NameExpr && ((NameExpr)expression).getName().asString().equals(parameterName)).map(NameExpr.class::cast).findFirst();
    }

    public static Optional<MethodReferenceExpr> getExplicitConstructorInvocationMethodReference(ExplicitConstructorInvocationStmt constructorInvocationStmt, String typeName) {
        return constructorInvocationStmt.getArguments().stream().filter(expression -> expression instanceof MethodReferenceExpr && ((MethodReferenceExpr)expression).getScope().asTypeExpr().getType().asString().equals(typeName)).map(MethodReferenceExpr.class::cast).findFirst();
    }

    public static BlockStmt getMethodDeclarationBlockStmt(ClassOrInterfaceDeclaration classOrInterfaceDeclaration, String methodName) {
        return CommonCodegenUtils.getMethodDeclaration(classOrInterfaceDeclaration, methodName).map(MethodDeclaration::getBody).map(Optional::get).orElseThrow(() -> new KiePMMLInternalException(String.format("Missing expected body in method %s", methodName)));
    }

    public static Optional<MethodDeclaration> getMethodDeclaration(ClassOrInterfaceDeclaration classOrInterfaceDeclaration, String methodName) {
        List methodDeclarations = classOrInterfaceDeclaration.getMethodsByName(methodName);
        return methodDeclarations.isEmpty() ? Optional.empty() : Optional.of((MethodDeclaration)methodDeclarations.get(0));
    }

    public static MethodDeclaration addMethod(MethodDeclaration methodTemplate, ClassOrInterfaceDeclaration tableTemplate, String methodName) {
        BlockStmt body = (BlockStmt)methodTemplate.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", methodTemplate.getName())));
        MethodDeclaration toReturn = tableTemplate.addMethod(methodName, new Modifier.Keyword[0]).setBody(body);
        toReturn.setModifiers(methodTemplate.getModifiers());
        methodTemplate.getParameters().forEach(arg_0 -> ((MethodDeclaration)toReturn).addParameter(arg_0));
        toReturn.setType(methodTemplate.getType());
        return toReturn;
    }

    public static void setVariableDeclaratorValue(BlockStmt body, String variableDeclaratorName, Expression value) {
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(body, variableDeclaratorName).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", variableDeclaratorName, body)));
        variableDeclarator.setInitializer(value);
    }

    public static Optional<VariableDeclarator> getVariableDeclarator(MethodDeclaration methodDeclaration, String variableName) {
        BlockStmt body = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        return CommonCodegenUtils.getVariableDeclarator(body, variableName);
    }

    public static Optional<VariableDeclarator> getVariableDeclarator(BlockStmt body, String variableName) {
        return body.findAll(VariableDeclarator.class).stream().filter(variableDeclarator -> variableDeclarator.getName().asString().equals(variableName)).findFirst();
    }

    public static Expression getExpressionForDataType(DataType dataTypeParam) {
        NullLiteralExpr toReturn;
        if (dataTypeParam != null) {
            DATA_TYPE dataType = DATA_TYPE.byName((String)dataTypeParam.value());
            toReturn = new NameExpr(DATA_TYPE.class.getName() + "." + dataType.name());
        } else {
            toReturn = new NullLiteralExpr();
        }
        return toReturn;
    }

    public static Expression getExpressionForOpType(OpType opTypeParam) {
        NullLiteralExpr toReturn;
        if (opTypeParam != null) {
            OP_TYPE opType = OP_TYPE.byName((String)opTypeParam.value());
            toReturn = new NameExpr(OP_TYPE.class.getName() + "." + opType.name());
        } else {
            toReturn = new NullLiteralExpr();
        }
        return toReturn;
    }

    public static Expression getExpressionForObject(Object source) {
        String className;
        if (source == null) {
            return new NullLiteralExpr();
        }
        switch (className = source.getClass().getSimpleName()) {
            case "String": {
                return new StringLiteralExpr((String)source);
            }
            case "int": 
            case "Integer": {
                return new IntegerLiteralExpr(((Integer)source).intValue());
            }
            case "double": 
            case "Double": {
                return new DoubleLiteralExpr(((Double)source).doubleValue());
            }
            case "float": 
            case "Float": {
                return new DoubleLiteralExpr(((Float)source).doubleValue());
            }
            case "boolean": 
            case "Boolean": {
                return new BooleanLiteralExpr(((Boolean)source).booleanValue());
            }
        }
        return new NameExpr(source.toString());
    }

    public static List<NameExpr> getNameExprsFromBlock(BlockStmt toRead, String exprName) {
        return toRead.stream().filter(node -> node instanceof NameExpr && ((NameExpr)node).getName().asString().equals(exprName)).map(NameExpr.class::cast).collect(Collectors.toList());
    }

    public static AssignExpr assignExprFrom(String target, Expression value) {
        return new AssignExpr((Expression)new NameExpr(target), value, AssignExpr.Operator.ASSIGN);
    }

    public static AssignExpr assignExprFrom(String target, Enum<?> value) {
        return CommonCodegenUtils.assignExprFrom(target, CommonCodegenUtils.literalExprFrom(value));
    }

    public static AssignExpr assignExprFrom(String target, String value) {
        return CommonCodegenUtils.assignExprFrom(target, CommonCodegenUtils.literalExprFrom(value));
    }

    public static Expression literalExprFrom(Enum<?> input) {
        return input == null ? new NullLiteralExpr() : new NameExpr(input.getClass().getCanonicalName() + "." + input.name());
    }

    public static Expression literalExprFrom(String input) {
        return input == null ? new NullLiteralExpr() : new StringLiteralExpr(input);
    }

    public static Expression literalExprFrom(DATA_TYPE type, String value) {
        if (type == null) {
            throw new IllegalArgumentException("Invalid \"null\" data type");
        }
        if (value == null) {
            return new NullLiteralExpr();
        }
        switch (type) {
            case STRING: {
                return new StringLiteralExpr(value);
            }
            case INTEGER: {
                return new IntegerLiteralExpr(value);
            }
            case DOUBLE: 
            case FLOAT: {
                return new DoubleLiteralExpr(value);
            }
            case BOOLEAN: {
                return new BooleanLiteralExpr(Boolean.parseBoolean(value));
            }
            case DATE: {
                return new MethodCallExpr((Expression)new NameExpr(LocalDate.class.getName()), "parse", NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(value)}));
            }
            case TIME: {
                return new MethodCallExpr((Expression)new NameExpr(LocalTime.class.getName()), "parse", NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(value)}));
            }
            case DATE_TIME: {
                return new MethodCallExpr((Expression)new NameExpr(LocalDateTime.class.getName()), "parse", NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(value)}));
            }
            case DATE_DAYS_SINCE_0: 
            case DATE_DAYS_SINCE_1960: 
            case DATE_DAYS_SINCE_1970: 
            case DATE_DAYS_SINCE_1980: 
            case TIME_SECONDS: 
            case DATE_TIME_SECONDS_SINCE_0: 
            case DATE_TIME_SECONDS_SINCE_1960: 
            case DATE_TIME_SECONDS_SINCE_1970: 
            case DATE_TIME_SECONDS_SINCE_1980: {
                return new LongLiteralExpr(value);
            }
        }
        throw new IllegalArgumentException("Can't create literal from " + type.getName() + " data type");
    }

    public static MethodCallExpr methodCallExprFrom(String scope, String name, Expression ... arguments) {
        return new MethodCallExpr((Expression)new NameExpr(scope), name, new NodeList((Node[])arguments));
    }

    public static MethodCallExpr getChainedMethodCallExprFrom(String name, MethodCallExpr parent) {
        return parent.stream().filter(expr -> expr instanceof MethodCallExpr && ((MethodCallExpr)expr).getName().toString().equals(name)).map(MethodCallExpr.class::cast).findFirst().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' MethodDeclaration in %s", name, parent)));
    }

    public static void replaceStringLiteralExpressionInStatement(Statement container, String toReplace, String replacement) {
        StringLiteralExpr toReplaceExpr = new StringLiteralExpr(toReplace);
        StringLiteralExpr replacementExpr = new StringLiteralExpr(replacement);
        container.walk(node -> {
            if (node.equals((Object)toReplaceExpr)) {
                node.getParentNode().ifPresent(parentNode -> parentNode.replace(node, (Node)replacementExpr));
            }
        });
    }

    public static void replaceNodesInStatement(Statement container, List<ReplacementTupla> replacementTuplas) {
        replacementTuplas.forEach(replacementTupla -> CommonCodegenUtils.replaceNodeInStatement(container, replacementTupla));
    }

    public static void replaceNodeInStatement(Statement container, ReplacementTupla replacementTupla) {
        container.walk(node -> {
            if (node.equals((Object)replacementTupla.toReplace)) {
                node.getParentNode().ifPresent(parentNode -> parentNode.replace(replacementTupla.toReplace, replacementTupla.replacement));
            }
        });
    }

    public static void addMethodDeclarationsToClass(ClassOrInterfaceDeclaration classOrInterfaceDeclaration, List<MethodDeclaration> toAdd) {
        toAdd.forEach(methodDeclaration -> CommonCodegenUtils.addMethodDeclarationToClass(classOrInterfaceDeclaration, methodDeclaration));
    }

    public static void addMethodDeclarationToClass(ClassOrInterfaceDeclaration classOrInterfaceDeclaration, MethodDeclaration toAdd) {
        classOrInterfaceDeclaration.addMethod(toAdd.getName().asString(), new Modifier.Keyword[0]).setModifiers(toAdd.getModifiers()).setType(toAdd.getType()).setParameters(toAdd.getParameters()).setBody((BlockStmt)toAdd.getBody().get());
    }

    public static Expression getVariableInitializer(MethodDeclaration methodDeclaration, String variableName) {
        return CommonCodegenUtils.getOptionalVariableInitializer(methodDeclaration, variableName).orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", variableName, methodDeclaration)));
    }

    public static Optional<Expression> getOptionalVariableInitializer(MethodDeclaration methodDeclaration, String variableName) {
        BlockStmt blockStmt = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        return CommonCodegenUtils.getVariableInitializer(blockStmt, variableName);
    }

    public static Optional<Expression> getVariableInitializer(BlockStmt blockStmt, String variableName) {
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(blockStmt, variableName).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", variableName, blockStmt)));
        return variableDeclarator.getInitializer();
    }

    public static void replaceNameExprWithNullInStatement(Statement container, List<NameExpr> toReplace) {
        List<ReplacementTupla> replacementTuplas = toReplace.stream().map(nameExpr -> {
            NullLiteralExpr toAdd = new NullLiteralExpr();
            return new ReplacementTupla((Node)nameExpr, (Node)toAdd);
        }).collect(Collectors.toList());
        replacementTuplas.forEach(replacementTupla -> CommonCodegenUtils.replaceNodeInStatement(container, replacementTupla));
    }

    public static MethodCallExpr getArraysAsListInvocationMethodCall(NodeList<Expression> arguments) {
        MethodCallExpr methodCallExpr = new MethodCallExpr();
        methodCallExpr.setScope((Expression)new NameExpr(Arrays.class.getSimpleName()));
        methodCallExpr.setName("asList");
        methodCallExpr.setArguments(arguments);
        return methodCallExpr;
    }

    public static NodeList<Expression> getArraysAsListInvocation(NodeList<Expression> arguments) {
        return NodeList.nodeList((Node[])new Expression[]{CommonCodegenUtils.getArraysAsListInvocationMethodCall(arguments)});
    }

    private static void createMap(BlockStmt body, String mapName, List<String> mapTypes, Class<? extends Map> mapClass) {
        VariableDeclarator mapDeclarator = new VariableDeclarator((Type)CommonCodegenUtils.getTypedClassOrInterfaceTypeByTypeNames(Map.class.getName(), mapTypes), mapName);
        ObjectCreationExpr mapInitializer = new ObjectCreationExpr();
        mapInitializer.setType(CommonCodegenUtils.getTypedClassOrInterfaceTypeByTypeNames(mapClass.getName(), mapTypes));
        mapDeclarator.setInitializer((Expression)mapInitializer);
        VariableDeclarationExpr mapDeclarationExpr = new VariableDeclarationExpr(mapDeclarator);
        body.addStatement((Expression)mapDeclarationExpr);
    }

    public static class ReplacementTupla {
        final Node toReplace;
        final Node replacement;

        public ReplacementTupla(Node toReplace, Node replacement) {
            this.toReplace = toReplace;
            this.replacement = replacement;
        }
    }
}

