/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.prometheus;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServer;
import org.kie.server.services.api.KieServerEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusKieServerEventListener
implements KieServerEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusKieServerEventListener.class);
    protected static final Counter numberOfContainersStartedSinceBoot = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_server_container_started_since_boot")).help("Kie Server Started Containers since startup")).register();
    protected static final Gauge numberOfContainersStartedByContainerId = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("kie_server_container_started")).help("Kie Server Started Containers by ID")).labelNames(new String[]{"container_id"})).register();
    protected static final Gauge numberOfContainersStartedTotal = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("kie_server_container_started_total")).help("Total of Kie Server Started Containers")).register();
    protected static final Gauge runningContainersByContainerId = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("kie_server_container_running")).help("Total of Running Kie Containers by Container ID")).labelNames(new String[]{"container_id"})).register();
    protected static final Gauge runningContainersTotal = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("kie_server_container_running_total")).help("Total of Running Kie Containers")).register();
    protected static final Gauge kieServerStartTime = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("kie_server_start_time")).help("Kie Server Start Time")).labelNames(new String[]{"name", "server_id", "location", "version"})).register();

    public void beforeServerStarted(KieServer kieServer) {
    }

    public void afterServerStarted(KieServer kieServer) {
        LOGGER.debug("After Kie Server started: {}", (Object)kieServer);
        KieServerInfo info = (KieServerInfo)kieServer.getInfo().getResult();
        ((Gauge.Child)kieServerStartTime.labels(new String[]{info.getName(), info.getServerId(), info.getLocation(), info.getVersion()})).set((double)System.currentTimeMillis());
    }

    public void beforeServerStopped(KieServer kieServer) {
    }

    public void afterServerStopped(KieServer kieServer) {
    }

    public void beforeContainerStarted(KieServer kieServer, KieContainerInstance containerInstance) {
    }

    public void afterContainerStarted(KieServer kieServer, KieContainerInstance containerInstance) {
        LOGGER.debug("After container started: {}", (Object)containerInstance);
        ((Gauge.Child)numberOfContainersStartedByContainerId.labels(new String[]{containerInstance.getContainerId()})).inc();
        numberOfContainersStartedTotal.inc();
        ((Gauge.Child)runningContainersByContainerId.labels(new String[]{containerInstance.getContainerId()})).inc();
        runningContainersTotal.inc();
        numberOfContainersStartedSinceBoot.inc();
    }

    public void beforeContainerStopped(KieServer kieServer, KieContainerInstance containerInstance) {
    }

    public void afterContainerStopped(KieServer kieServer, KieContainerInstance containerInstance) {
        LOGGER.debug("After container stopped: {}", (Object)containerInstance);
        ((Gauge.Child)numberOfContainersStartedByContainerId.labels(new String[]{containerInstance.getContainerId()})).dec();
        numberOfContainersStartedTotal.dec();
        ((Gauge.Child)runningContainersByContainerId.labels(new String[]{containerInstance.getContainerId()})).dec();
        runningContainersTotal.dec();
    }

    public void beforeContainerActivated(KieServer kieServer, KieContainerInstance containerInstance) {
    }

    public void afterContainerActivated(KieServer kieServer, KieContainerInstance containerInstance) {
        LOGGER.debug("After container activated: {}", (Object)containerInstance);
        ((Gauge.Child)runningContainersByContainerId.labels(new String[]{containerInstance.getContainerId()})).inc();
        runningContainersTotal.inc();
    }

    public void beforeContainerDeactivated(KieServer kieServer, KieContainerInstance containerInstance) {
        LOGGER.debug("After container deactivated: {}", (Object)containerInstance);
        ((Gauge.Child)runningContainersByContainerId.labels(new String[]{containerInstance.getContainerId()})).dec();
        runningContainersTotal.dec();
    }

    public void afterContainerDeactivated(KieServer kieServer, KieContainerInstance containerInstance) {
    }
}

