/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.drools.core.command.impl.ContextImpl;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.api.runtime.PMMLListener;

public class PMMLContextImpl
extends ContextImpl
implements PMMLContext {
    private static final String PMML_REQUEST_DATA = "PMML_REQUEST_DATA";
    private final Map<String, Object> missingValueReplacedMap = new HashMap<String, Object>();
    private final Map<String, Object> commonTransformationMap = new HashMap<String, Object>();
    private final Map<String, Object> localTransformationMap = new HashMap<String, Object>();
    private final Map<String, Object> outputFieldsMap = new HashMap<String, Object>();
    private final Set<PMMLListener> pmmlListeners = new HashSet<PMMLListener>();
    private Object predictedDisplayValue;
    private Object entityId;
    private Object affinity;
    private LinkedHashMap<String, Double> probabilityResultMap;

    public PMMLContextImpl(PMMLRequestData pmmlRequestData) {
        this.set(PMML_REQUEST_DATA, pmmlRequestData);
    }

    public PMMLContextImpl(PMMLRequestData pmmlRequestData, Set<PMMLListener> pmmlListeners) {
        this(pmmlRequestData);
        this.pmmlListeners.addAll(pmmlListeners);
    }

    public PMMLRequestData getRequestData() {
        return (PMMLRequestData)this.get(PMML_REQUEST_DATA);
    }

    public void addMissingValueReplaced(String fieldName, Object missingValueReplaced) {
        this.missingValueReplacedMap.put(fieldName, missingValueReplaced);
    }

    public void addCommonTranformation(String fieldName, Object commonTranformation) {
        this.localTransformationMap.put(fieldName, commonTranformation);
    }

    public void addLocalTranformation(String fieldName, Object commonTranformation) {
        this.commonTransformationMap.put(fieldName, commonTranformation);
    }

    public Map<String, Object> getMissingValueReplacedMap() {
        return Collections.unmodifiableMap(this.missingValueReplacedMap);
    }

    public Map<String, Object> getCommonTransformationMap() {
        return Collections.unmodifiableMap(this.commonTransformationMap);
    }

    public Map<String, Object> getLocalTransformationMap() {
        return Collections.unmodifiableMap(this.localTransformationMap);
    }

    static LinkedHashMap<String, Double> getFixedProbabilityMap(LinkedHashMap<String, Double> probabilityResultMap) {
        LinkedHashMap<String, Double> toReturn = new LinkedHashMap<String, Double>();
        String[] resultMapKeys = probabilityResultMap.keySet().toArray(new String[0]);
        AtomicReference<Double> sumCounter = new AtomicReference<Double>(0.0);
        for (int i = 0; i < probabilityResultMap.size(); ++i) {
            String key = resultMapKeys[i];
            double value = probabilityResultMap.get(key);
            if (i < resultMapKeys.length - 1) {
                sumCounter.accumulateAndGet(value, Double::sum);
                toReturn.put(key, value);
                continue;
            }
            toReturn.put(key, 1.0 - sumCounter.get());
        }
        return toReturn;
    }

    public Object getPredictedDisplayValue() {
        return this.predictedDisplayValue;
    }

    public void setPredictedDisplayValue(Object predictedDisplayValue) {
        this.predictedDisplayValue = predictedDisplayValue;
    }

    public Object getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Object entityId) {
        this.entityId = entityId;
    }

    public Object getAffinity() {
        return this.affinity;
    }

    public void setAffinity(Object affinity) {
        this.affinity = affinity;
    }

    public Map<String, Double> getProbabilityMap() {
        LinkedHashMap<String, Double> probabilityResultMap = this.getProbabilityResultMap();
        return probabilityResultMap != null ? Collections.unmodifiableMap(PMMLContextImpl.getFixedProbabilityMap(probabilityResultMap)) : Collections.emptyMap();
    }

    public LinkedHashMap<String, Double> getProbabilityResultMap() {
        return this.probabilityResultMap;
    }

    public void setProbabilityResultMap(LinkedHashMap<String, Double> probabilityResultMap) {
        this.probabilityResultMap = probabilityResultMap;
    }

    public Map<String, Object> getOutputFieldsMap() {
        return this.outputFieldsMap;
    }

    public void addPMMLListener(PMMLListener toAdd) {
        this.pmmlListeners.add(toAdd);
    }

    public Set<PMMLListener> getPMMLListeners() {
        return Collections.unmodifiableSet(this.pmmlListeners);
    }
}

