/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.migration.legacy.model;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.kie.workbench.common.forms.migration.legacy.model.DataHolder;
import org.kie.workbench.common.forms.migration.legacy.model.Field;
import org.kie.workbench.common.forms.migration.legacy.model.FormDisplayInfo;

public class Form {
    public static final String DISPLAY_MODE_TEMPLATE = "template";
    private Long id;
    private String subject;
    private String name;
    private String displayMode;
    private String labelMode;
    private String showMode;
    private Long status;
    private Set<FormDisplayInfo> formDisplayInfos;
    private Set<Field> formFields = new TreeSet<Field>();
    private Set<DataHolder> holders;
    private int migrationStep = 0;

    public Form() {
        this.formDisplayInfos = new TreeSet<FormDisplayInfo>();
        this.holders = new TreeSet<DataHolder>();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(String displayMode) {
        this.displayMode = displayMode;
    }

    public String getLabelMode() {
        return this.labelMode;
    }

    public void setLabelMode(String labelMode) {
        this.labelMode = labelMode;
    }

    public String getShowMode() {
        return this.showMode;
    }

    public void setShowMode(String showMode) {
        this.showMode = showMode;
    }

    public Long getStatus() {
        return this.status;
    }

    public void setStatus(Long status) {
        this.status = status;
    }

    public Set<FormDisplayInfo> getFormDisplayInfos() {
        return this.formDisplayInfos;
    }

    public void setFormDisplayInfos(Set<FormDisplayInfo> formDisplayInfos) {
        this.formDisplayInfos = formDisplayInfos;
    }

    public Set<Field> getFormFields() {
        return this.formFields;
    }

    public void setFormFields(Set<Field> formFields) {
        this.formFields = formFields;
    }

    public Set<Field> getFieldsForDataHolder(DataHolder dataHolder) {
        return new TreeSet<Field>(this.formFields.stream().filter(field -> dataHolder.ownsField((Field)field)).collect(Collectors.toSet()));
    }

    public void setDataHolder(DataHolder holder) {
        if (holder == null) {
            return;
        }
        if (!(holder.getInputId() != null && holder.getInputId().trim().length() != 0 || holder.getOuputId() != null && holder.getOuputId().trim().length() != 0)) {
            return;
        }
        if (this.getDataHolderById(holder.getInputId()) != null || this.getDataHolderById(holder.getOuputId()) != null) {
            this.holders.remove(holder);
        }
        this.holders.add(holder);
    }

    public DataHolder getDataHolderById(String srcId) {
        if (srcId == null || srcId.trim().length() == 0) {
            return null;
        }
        if (this.getHolders() != null) {
            for (DataHolder dataHolder : this.holders) {
                if (!srcId.equals(dataHolder.getUniqeId())) continue;
                return dataHolder;
            }
        }
        return null;
    }

    public Field getField(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        if (this.getFormFields() != null) {
            for (Field field : this.formFields) {
                if (!name.equals(field.getFieldName())) continue;
                return field;
            }
        }
        return null;
    }

    protected String getDisplayModeText(String selector) {
        String text = null;
        if (this.getFormDisplayInfos() != null) {
            for (FormDisplayInfo dInfo : this.getFormDisplayInfos()) {
                if (!selector.equals(dInfo.getDisplayMode())) continue;
                text = dInfo.getDisplayData();
                break;
            }
        }
        return text;
    }

    protected void setDisplayModeText(String selector, String data) {
        if (this.getFormDisplayInfos() == null) {
            this.setFormDisplayInfos(new HashSet<FormDisplayInfo>());
        }
        FormDisplayInfo theTemplateInfo = null;
        for (FormDisplayInfo dInfo : this.getFormDisplayInfos()) {
            if (!selector.equals(dInfo.getDisplayMode())) continue;
            theTemplateInfo = dInfo;
            break;
        }
        if (theTemplateInfo == null) {
            theTemplateInfo = new FormDisplayInfo();
            this.getFormDisplayInfos().add(theTemplateInfo);
        }
        theTemplateInfo.setDisplayData(data);
        theTemplateInfo.setDisplayMode(selector);
    }

    public Set<DataHolder> getHolders() {
        return this.holders;
    }

    public String getFormTemplate() {
        return this.getDisplayModeText(DISPLAY_MODE_TEMPLATE);
    }

    public void setFormTemplate(String data) {
        this.setDisplayModeText(DISPLAY_MODE_TEMPLATE, data);
    }

    public int getMigrationStep() {
        return this.migrationStep;
    }

    public void setMigrationStep(int migrationStep) {
        this.migrationStep = migrationStep;
    }
}

