/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.kie.api.io.ResourceType;
import org.kie.workbench.common.forms.jbpm.model.authoring.JBPMFormModel;
import org.kie.workbench.common.forms.migration.legacy.model.DataHolder;
import org.kie.workbench.common.forms.migration.legacy.model.Field;
import org.kie.workbench.common.forms.migration.legacy.model.Form;
import org.kie.workbench.common.forms.migration.legacy.services.FieldTypeManager;
import org.kie.workbench.common.forms.migration.tool.FormMigrationSummary;
import org.kie.workbench.common.forms.migration.tool.Resource;
import org.kie.workbench.common.forms.migration.tool.bpmn.BPMNAnalyzer;
import org.kie.workbench.common.forms.migration.tool.bpmn.BPMNProcess;
import org.kie.workbench.common.forms.migration.tool.pipelines.MigrationContext;
import org.kie.workbench.common.forms.migration.tool.pipelines.basic.impl.AbstractFormAdapter;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.model.FormModel;
import org.kie.workbench.common.forms.services.backend.util.UIDGenerator;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;

public class BPMNFormAdapter
extends AbstractFormAdapter {
    protected List<JBPMFormModel> workspaceBPMNFormModels = new ArrayList<JBPMFormModel>();

    public BPMNFormAdapter(MigrationContext migrationContext) {
        super(migrationContext);
        this.readWorkspaceBPMNModels();
    }

    protected void readWorkspaceBPMNModels() {
        final BPMNAnalyzer analyzer = new BPMNAnalyzer();
        Files.walkFileTree((Path)Paths.convert((org.uberfire.backend.vfs.Path)this.migrationContext.getWorkspaceProject().getRootPath()), (FileVisitor)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path visitedPath, BasicFileAttributes attrs) throws IOException {
                org.uberfire.backend.vfs.Path visitedVFSPath = Paths.convert((Path)visitedPath);
                String fileName = visitedVFSPath.getFileName();
                File file = visitedPath.toFile();
                if (file.isFile() && BPMNFormAdapter.isBPMNFile(fileName)) {
                    try {
                        BPMNProcess process = analyzer.read(BPMNFormAdapter.this.migrationContext.getMigrationServicesCDIWrapper().getIOService().newInputStream(visitedPath, new OpenOption[0]));
                        if (process != null) {
                            BPMNFormAdapter.this.workspaceBPMNFormModels.addAll(process.getFormModels());
                        } else {
                            BPMNFormAdapter.this.migrationContext.getSystem().console().format("%s Cannot read process %s: something wrong happened reading the process file. The migration will continue but forms related to this process won't be migrated. If you want to migrate its forms please fix the process file and start the migration again\n", new Object[]{"[WARNING] ", fileName});
                        }
                    }
                    catch (Exception ex) {
                        BPMNFormAdapter.this.migrationContext.getSystem().console().format("%s Cannot read process %s: something wrong happened reading the process file. The migration will continue but forms related to this process won't be migrated. If you want to migrate its forms please fix the process file and start the migration again\n", new Object[]{"[WARNING] ", fileName});
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static boolean isBPMNFile(String fileName) {
        return ResourceType.getResourceType((String)"BPMN2").matchesExtension(fileName);
    }

    @Override
    protected void doCreateFormDefinition(FormModel formModel, FormMigrationSummary formSummary) {
        Form originalForm = formSummary.getOriginalForm().get();
        Set<DataHolder> objectDataHolders = originalForm.getHolders().stream().filter(dataHolder -> !dataHolder.getType().equals("basicType")).collect(Collectors.toSet());
        if (!objectDataHolders.isEmpty()) {
            FieldTypeManager fieldTypeManager = FieldTypeManager.get();
            objectDataHolders.forEach(dataHolder -> {
                Set<Field> dataHolderFields = originalForm.getFieldsForDataHolder((DataHolder)dataHolder);
                if (dataHolderFields.isEmpty()) {
                    return;
                }
                FormModel newFormModel = this.createModelForDO((DataHolder)dataHolder);
                String formName = formSummary.getBaseFormName() + "-" + dataHolder.getUniqeId();
                String formAssetName = formName + "." + "frm";
                FormDefinition newFormDefinition = new FormDefinition(newFormModel);
                newFormDefinition.setId(UIDGenerator.generateUID());
                newFormDefinition.setName(formName);
                this.migrateFields(dataHolderFields, newFormDefinition, formSummary);
                dataHolderFields.forEach(field -> field.setMovedToForm(formName));
                Path newFormPath = Paths.convert((org.uberfire.backend.vfs.Path)formSummary.getOriginalForm().getPath()).getParent().resolve(formAssetName);
                FormMigrationSummary extraSummary = new FormMigrationSummary(formSummary.getOriginalForm());
                extraSummary.setBaseFormName(formName);
                extraSummary.setNewFormResource(new Resource<FormDefinition>(newFormDefinition, Paths.convert((Path)newFormPath)));
                this.migrationContext.getExtraSummaries().add(extraSummary);
                Field field2 = new Field();
                field2.setFieldType(fieldTypeManager.getTypeByCode("Subform"));
                field2.setId(System.currentTimeMillis());
                field2.setFieldName(dataHolder.getUniqeId());
                field2.setInputBinding(dataHolder.getInputId());
                field2.setOutputBinding(dataHolder.getOuputId());
                field2.setLabel(new HashMap<String, String>());
                field2.getLabel().put("en", dataHolder.getUniqeId());
                field2.setPosition(originalForm.getFormFields().size() + 1000);
                field2.setDefaultSubform(newFormDefinition.getId());
                field2.setSourceLink(formName);
                field2.setBag(dataHolder.getClassName());
                field2.setForm(originalForm);
                originalForm.getFormFields().add(field2);
            });
        }
        super.doCreateFormDefinition(formModel, formSummary);
    }

    @Override
    protected Predicate<FormMigrationSummary> getFilter() {
        return summary -> summary.getBaseFormName().endsWith("-taskform");
    }

    @Override
    protected FormModel extractFormModel(FormMigrationSummary summary) {
        JBPMFormModel formModel = this.workspaceBPMNFormModels.stream().filter(bpmnFormModel -> bpmnFormModel.getFormName().equals(summary.getBaseFormName())).findAny().orElse(null);
        return formModel;
    }
}

