/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.Collections;
import java.util.Map;
import org.elasticsearch.ingest.TemplateService;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.template.CompiledTemplate;

public class InternalTemplateService
implements TemplateService {
    private final ScriptService scriptService;

    InternalTemplateService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    @Override
    public TemplateService.Template compile(final String template) {
        int mustacheStart = template.indexOf("{{");
        int mustacheEnd = template.indexOf("}}");
        if (mustacheStart != -1 && mustacheEnd != -1 && mustacheStart < mustacheEnd) {
            Script script = new Script(ScriptType.INLINE, "mustache", template, Collections.emptyMap());
            final CompiledTemplate compiledTemplate = this.scriptService.compileTemplate(script, ScriptContext.Standard.INGEST);
            return new TemplateService.Template(){

                @Override
                public String execute(Map<String, Object> model) {
                    return compiledTemplate.run(model).utf8ToString();
                }

                @Override
                public String getKey() {
                    return template;
                }
            };
        }
        return new StringTemplate(template);
    }

    class StringTemplate
    implements TemplateService.Template {
        private final String value;

        StringTemplate(String value) {
            this.value = value;
        }

        @Override
        public String execute(Map<String, Object> model) {
            return this.value;
        }

        @Override
        public String getKey() {
            return this.value;
        }
    }
}

