/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.lucene.search.spell.LevensteinDistance;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;

public abstract class BaseRestHandler
extends AbstractComponent
implements RestHandler {
    public static final Setting<Boolean> MULTI_ALLOW_EXPLICIT_INDEX = Setting.boolSetting("rest.action.multi.allow_explicit_index", true, Setting.Property.NodeScope);

    protected BaseRestHandler(Settings settings) {
        super(settings);
    }

    @Override
    public final void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        RestChannelConsumer action = this.prepareRequest(request, client);
        SortedSet unconsumedParams = request.unconsumedParams().stream().filter(p -> !this.responseParams().contains(p)).collect(Collectors.toCollection(TreeSet::new));
        if (!unconsumedParams.isEmpty()) {
            HashSet<String> candidateParams = new HashSet<String>();
            candidateParams.addAll(request.consumedParams());
            candidateParams.addAll(this.responseParams());
            throw new IllegalArgumentException(this.unrecognized(request, unconsumedParams, candidateParams, "parameter"));
        }
        action.accept(channel);
    }

    protected final String unrecognized(RestRequest request, Set<String> invalids, Set<String> candidates, String detail) {
        String message = String.format(Locale.ROOT, "request [%s] contains unrecognized %s%s: ", request.path(), detail, invalids.size() > 1 ? "s" : "");
        boolean first = true;
        for (String invalid : invalids) {
            LevensteinDistance ld = new LevensteinDistance();
            ArrayList<Tuple<Float, String>> scoredParams = new ArrayList<Tuple<Float, String>>();
            for (String candidate : candidates) {
                float distance = ld.getDistance(invalid, candidate);
                if (!(distance > 0.5f)) continue;
                scoredParams.add(new Tuple<Float, String>(Float.valueOf(distance), candidate));
            }
            CollectionUtil.timSort(scoredParams, (a, b) -> {
                int compare = ((Float)a.v1()).compareTo((Float)b.v1());
                if (compare != 0) {
                    return -compare;
                }
                return ((String)a.v2()).compareTo((String)b.v2());
            });
            if (!first) {
                message = message + ", ";
            }
            message = message + "[" + invalid + "]";
            List keys = scoredParams.stream().map(Tuple::v2).collect(Collectors.toList());
            if (!keys.isEmpty()) {
                message = message + " -> did you mean " + (keys.size() == 1 ? "[" + (String)keys.get(0) + "]" : "any of " + keys.toString()) + "?";
            }
            first = false;
        }
        return message;
    }

    protected abstract RestChannelConsumer prepareRequest(RestRequest var1, NodeClient var2) throws IOException;

    protected Set<String> responseParams() {
        return Collections.emptySet();
    }

    @FunctionalInterface
    protected static interface RestChannelConsumer
    extends CheckedConsumer<RestChannel, Exception> {
    }
}

