/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.search.lookup.CachedPositionIterator;
import org.elasticsearch.search.lookup.LeafIndexLookup;
import org.elasticsearch.search.lookup.PositionIterator;
import org.elasticsearch.search.lookup.TermPosition;

public class IndexFieldTerm
implements Iterable<TermPosition> {
    PostingsEnum postings;
    private final int flags;
    private final String fieldName;
    private final String term;
    private final PositionIterator iterator;
    private final Term identifier;
    private final TermStatistics termStats;
    private int freq = 0;

    public long df() throws IOException {
        return this.termStats.docFreq();
    }

    public long ttf() throws IOException {
        return this.termStats.totalTermFreq();
    }

    private void setReader(LeafReader reader) {
        try {
            this.postings = this.getPostings(this.convertToLuceneFlags(this.flags), reader);
            if (this.postings == null) {
                final DocIdSetIterator empty = DocIdSetIterator.empty();
                this.postings = new PostingsEnum(){

                    public int docID() {
                        return empty.docID();
                    }

                    public int nextDoc() throws IOException {
                        return empty.nextDoc();
                    }

                    public int advance(int target) throws IOException {
                        return empty.advance(target);
                    }

                    public long cost() {
                        return empty.cost();
                    }

                    public int freq() throws IOException {
                        return 1;
                    }

                    public int nextPosition() throws IOException {
                        return -1;
                    }

                    public int startOffset() throws IOException {
                        return -1;
                    }

                    public int endOffset() throws IOException {
                        return -1;
                    }

                    public BytesRef getPayload() throws IOException {
                        return null;
                    }
                };
            }
        }
        catch (IOException e) {
            throw new ElasticsearchException("Unable to get postings for field " + this.fieldName + " and term " + this.term, (Throwable)e, new Object[0]);
        }
    }

    private int convertToLuceneFlags(int flags) {
        int lucenePositionsFlags = 0;
        lucenePositionsFlags |= (flags & 8) > 0 ? 8 : 0;
        lucenePositionsFlags |= (flags & 0x10) > 0 ? 24 : 0;
        lucenePositionsFlags |= (flags & 4) > 0 ? 88 : 0;
        return lucenePositionsFlags |= (flags & 2) > 0 ? 56 : 0;
    }

    private PostingsEnum getPostings(int luceneFlags, LeafReader reader) throws IOException {
        TermsEnum termsEnum;
        Terms terms;
        assert (this.identifier.field() != null);
        assert (this.identifier.bytes() != null);
        Fields fields = reader.fields();
        Object newPostings = null;
        if (fields != null && (terms = fields.terms(this.identifier.field())) != null && (termsEnum = terms.iterator()).seekExact(this.identifier.bytes())) {
            newPostings = termsEnum.postings(this.postings, luceneFlags);
            final Bits liveDocs = reader.getLiveDocs();
            if (liveDocs != null) {
                newPostings = new FilterLeafReader.FilterPostingsEnum((PostingsEnum)newPostings){

                    private int doNext(int d) throws IOException {
                        while (d != Integer.MAX_VALUE) {
                            if (liveDocs.get(d)) {
                                return d;
                            }
                            d = super.nextDoc();
                        }
                        return Integer.MAX_VALUE;
                    }

                    public int nextDoc() throws IOException {
                        return this.doNext(super.nextDoc());
                    }

                    public int advance(int target) throws IOException {
                        return this.doNext(super.advance(target));
                    }
                };
            }
        }
        return newPostings;
    }

    public void setDocument(int docId) {
        assert (this.postings != null);
        try {
            int currentDocPos = this.postings.docID();
            if (currentDocPos < docId) {
                currentDocPos = this.postings.advance(docId);
            }
            this.freq = currentDocPos == docId ? this.postings.freq() : 0;
            this.iterator.nextDoc();
        }
        catch (IOException e) {
            throw new ElasticsearchException("While trying to initialize term positions in IndexFieldTerm.setNextDoc() ", (Throwable)e, new Object[0]);
        }
    }

    public IndexFieldTerm(String term, String fieldName, LeafIndexLookup indexLookup, int flags) {
        assert (fieldName != null);
        this.fieldName = fieldName;
        assert (term != null);
        this.term = term;
        assert (indexLookup != null);
        this.identifier = new Term(fieldName, term);
        this.flags = flags;
        boolean doRecord = (flags & 0x20) > 0;
        this.iterator = !doRecord ? new PositionIterator(this) : new CachedPositionIterator(this);
        this.setReader(indexLookup.getReader());
        this.setDocument(indexLookup.getDocId());
        try {
            this.termStats = indexLookup.getIndexSearcher().termStatistics(this.identifier, TermContext.build((IndexReaderContext)indexLookup.getReaderContext(), (Term)this.identifier));
        }
        catch (IOException e) {
            throw new ElasticsearchException("Cannot get term statistics: ", (Throwable)e, new Object[0]);
        }
    }

    public int tf() throws IOException {
        return this.freq;
    }

    @Override
    public Iterator<TermPosition> iterator() {
        return this.iterator.reset();
    }

    public void validateFlags(int flags2) {
        if ((this.flags & flags2) < flags2) {
            throw new ElasticsearchException("You must call get with all required flags! Instead of " + this.getCalledStatement(flags2) + "call " + this.getCallStatement(flags2 | this.flags) + " once", new Object[0]);
        }
    }

    private String getCalledStatement(int flags2) {
        String calledFlagsCall1 = this.getFlagsString(this.flags);
        String calledFlagsCall2 = this.getFlagsString(flags2);
        String callStatement1 = this.getCallStatement(calledFlagsCall1);
        String callStatement2 = this.getCallStatement(calledFlagsCall2);
        return " " + callStatement1 + " and " + callStatement2 + " ";
    }

    private String getCallStatement(String calledFlags) {
        return "_index['" + this.fieldName + "'].get('" + this.term + "', " + calledFlags + ")";
    }

    private String getFlagsString(int flags2) {
        String flagsString = null;
        if ((flags2 & 8) != 0) {
            flagsString = this.anddToFlagsString(flagsString, "_FREQUENCIES");
        }
        if ((flags2 & 0x10) != 0) {
            flagsString = this.anddToFlagsString(flagsString, "_POSITIONS");
        }
        if ((flags2 & 2) != 0) {
            flagsString = this.anddToFlagsString(flagsString, "_OFFSETS");
        }
        if ((flags2 & 4) != 0) {
            flagsString = this.anddToFlagsString(flagsString, "_PAYLOADS");
        }
        if ((flags2 & 0x20) != 0) {
            flagsString = this.anddToFlagsString(flagsString, "_CACHE");
        }
        return flagsString;
    }

    private String anddToFlagsString(String flagsString, String flag) {
        flagsString = flagsString != null ? flagsString + " | " : "";
        flagsString = flagsString + flag;
        return flagsString;
    }

    private String getCallStatement(int flags2) {
        String calledFlags = this.getFlagsString(flags2);
        String callStatement = this.getCallStatement(calledFlags);
        return " " + callStatement + " ";
    }
}

