/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.uberfire.annotations.processors.AbstractGenerator;
import org.uberfire.annotations.processors.GeneratorUtils;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.annotations.processors.facades.ClientAPIModule;

public class ExperimentalFeatureDefinitionProviderGenerator
extends AbstractGenerator {
    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public StringBuffer generate(String packageName, PackageElement packageElement, String className, Element element, ProcessingEnvironment processingEnvironment) throws GenerationException {
        Messager messager = processingEnvironment.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, "Starting code generation for [" + className + "]");
        HashMap<String, String> root = new HashMap<String, String>();
        TypeElement typeElement = (TypeElement)element;
        String featureId = typeElement.getQualifiedName().toString();
        String group = ClientAPIModule.getExperimentalFeatureGroup(typeElement);
        Boolean global = ClientAPIModule.isExperimentalFeatureGlobal(typeElement);
        String nameKey = this.getNameKey(typeElement);
        String descriptionKey = this.getDescriptionKey(typeElement);
        if (GeneratorUtils.debugLoggingEnabled()) {
            messager.printMessage(Diagnostic.Kind.NOTE, "Package name: " + packageName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Class name: " + className);
            messager.printMessage(Diagnostic.Kind.NOTE, "Feature Id: " + featureId);
            messager.printMessage(Diagnostic.Kind.NOTE, "Scope: " + (global != false ? "global" : "user"));
            messager.printMessage(Diagnostic.Kind.NOTE, "Group: " + className);
            messager.printMessage(Diagnostic.Kind.NOTE, "Name key: " + nameKey);
            messager.printMessage(Diagnostic.Kind.NOTE, "Description key: " + descriptionKey);
        }
        root.put("packageName", packageName);
        root.put("className", className);
        root.put("featureId", featureId);
        root.put("global", String.valueOf(global));
        root.put("group", group);
        root.put("nameKey", nameKey);
        root.put("descriptionKey", descriptionKey);
        try (StringWriter sw = new StringWriter();){
            StringBuffer stringBuffer;
            try (BufferedWriter bw = new BufferedWriter(sw);){
                Template template = config.getTemplate("experimentalFeatureDefinitionProvider.ftl");
                template.process(root, (Writer)bw);
                messager.printMessage(Diagnostic.Kind.NOTE, "Successfully generated code for [" + className + "]");
                stringBuffer = sw.getBuffer();
            }
            return stringBuffer;
        }
        catch (Exception te) {
            throw new GenerationException(te);
        }
    }

    private String getNameKey(TypeElement typeElement) {
        String nameKey = ClientAPIModule.getExperimentalFeatureNameKey(typeElement);
        if (nameKey.isEmpty()) {
            nameKey = typeElement.getQualifiedName().toString();
        }
        return nameKey;
    }

    private String getDescriptionKey(TypeElement typeElement) {
        return ClientAPIModule.getExperimentalFeatureDescriptionKey(typeElement);
    }
}

