/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.lucene;

import org.apache.lucene.analysis.Analyzer;
import org.uberfire.commons.lifecycle.PriorityDisposable;
import org.uberfire.commons.lifecycle.PriorityDisposableRegistry;
import org.uberfire.ext.metadata.MetadataConfig;
import org.uberfire.ext.metadata.backend.lucene.fields.FieldFactory;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndexManager;
import org.uberfire.ext.metadata.backend.lucene.provider.LuceneIndexProvider;
import org.uberfire.ext.metadata.backend.lucene.search.LuceneSearchIndex;
import org.uberfire.ext.metadata.engine.IndexManager;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.engine.MetaModelStore;
import org.uberfire.ext.metadata.provider.IndexProvider;
import org.uberfire.ext.metadata.search.SearchIndex;

public class LuceneConfig
implements MetadataConfig {
    private final MetaModelStore metaModelStore;
    private final FieldFactory fieldFactory;
    private final LuceneIndexManager indexManager;
    private final Analyzer analyzer;
    private final LuceneSearchIndex searchIndex;
    private final MetaIndexEngine indexEngine;
    private final LuceneIndexProvider indexProvider;

    public LuceneConfig(MetaModelStore metaModelStore, FieldFactory fieldFactory, LuceneIndexManager indexManager, MetaIndexEngine metaIndexEngine, Analyzer analyzer) {
        this.metaModelStore = metaModelStore;
        this.fieldFactory = fieldFactory;
        this.analyzer = analyzer;
        this.indexManager = indexManager;
        this.searchIndex = new LuceneSearchIndex(this.indexManager, this.analyzer);
        this.indexEngine = metaIndexEngine;
        this.indexProvider = new LuceneIndexProvider(indexManager, fieldFactory);
        PriorityDisposableRegistry.register((PriorityDisposable)this);
    }

    public IndexProvider getIndexProvider() {
        return this.indexProvider;
    }

    public SearchIndex getSearchIndex() {
        return this.searchIndex;
    }

    public MetaIndexEngine getIndexEngine() {
        return this.indexEngine;
    }

    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    public MetaModelStore getMetaModelStore() {
        return this.metaModelStore;
    }

    public void dispose() {
        this.indexEngine.dispose();
        this.indexManager.dispose();
        this.metaModelStore.dispose();
        this.analyzer.close();
    }

    public int priority() {
        return -20;
    }
}

