/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.library.api;

import java.util.List;
import java.util.Optional;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.library.api.AssetInfo;

public class AssetQueryResult {
    private final List<AssetInfo> assets;
    private final ResultType resultType;

    public static AssetQueryResult nonexistent() {
        return new AssetQueryResult(null, ResultType.DoesNotExist);
    }

    public static AssetQueryResult unindexed() {
        return new AssetQueryResult(null, ResultType.Unindexed);
    }

    public static AssetQueryResult normal(List<AssetInfo> assets) {
        PortablePreconditions.checkNotNull((String)"assets", assets);
        return new AssetQueryResult(assets, ResultType.Normal);
    }

    public AssetQueryResult(@MapsTo(value="assets") List<AssetInfo> assets, @MapsTo(value="resultType") ResultType resultType) {
        this.assets = assets;
        this.resultType = resultType;
    }

    public Optional<List<AssetInfo>> getAssetInfos() {
        return Optional.ofNullable(this.assets);
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public static enum ResultType {
        Normal,
        Unindexed,
        DoesNotExist;

    }
}

