/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.service.impact;

import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValuePartReferenceIndexTerm;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.kie.workbench.common.services.refactoring.service.impact.AbstractOperationRequest;
import org.kie.workbench.common.services.refactoring.service.impact.OperationType;

public class RefactorOperationBuilder<R extends AbstractOperationRequest>
extends AbstractOperationRequest {
    private R request;

    RefactorOperationBuilder(OperationType operation, R request) {
        this.changeType = operation;
        this.request = request;
    }

    private R internalBuild() {
        ((AbstractOperationRequest)((Object)this.request)).setChangeType(this.changeType);
        ((AbstractOperationRequest)((Object)this.request)).queryTerms = this.queryTerms;
        this.request.setStartRowIndex(this.startRowIndex);
        this.request.setPageSize(this.pageSize);
        ((AbstractOperationRequest)((Object)this.request)).setModuleName(this.moduleName);
        ((AbstractOperationRequest)((Object)this.request)).setModuleRootPathURI(this.moduleRootPathURI);
        ((AbstractOperationRequest)((Object)this.request)).setBranchName(this.branchName);
        return this.request;
    }

    RequiresPart requiresPart(RefactorOperationBuilder<R> builder) {
        return new RequiresPart(builder);
    }

    PossiblyRequiresPart possiblyRequiresPart(RefactorOperationBuilder<R> builder) {
        return new PossiblyRequiresPart(builder);
    }

    RequiresModule requiresModule(RefactorOperationBuilder<R> builder) {
        return new RequiresModule(builder);
    }

    public class RequiresBranch
    extends Requires<RequiresBranch> {
        RequiresBranch(RefactorOperationBuilder<R> delegate) {
            super(delegate);
        }

        public R onBranch(String branchName) {
            this.delegate.branchName = branchName;
            return (Object)this.delegate.internalBuild();
        }

        public R onAllBranches() {
            this.delegate.branchName = AbstractOperationRequest.ALL;
            return (Object)this.delegate.internalBuild();
        }
    }

    public class RequiresModule
    extends Requires<RequiresModule> {
        RequiresModule(RefactorOperationBuilder<R> delegate) {
            super(delegate);
        }

        public RequiresBranch inModule(String moduleName) {
            this.delegate.moduleName = moduleName;
            return new RequiresBranch(this.delegate);
        }

        public RequiresBranch inModuleRootPathURI(String moduleRootPathURI) {
            this.delegate.moduleRootPathURI = moduleRootPathURI;
            return new RequiresBranch(this.delegate);
        }

        public RequiresBranch inAllModules() {
            this.delegate.moduleName = AbstractOperationRequest.ALL;
            this.delegate.moduleRootPathURI = AbstractOperationRequest.ALL;
            return new RequiresBranch(this.delegate);
        }
    }

    abstract class Requires<N extends Requires> {
        protected final RefactorOperationBuilder<R> delegate;

        Requires(RefactorOperationBuilder<R> delegate) {
            this.delegate = delegate;
        }

        RefactorOperationBuilder getDelegate() {
            return this.delegate;
        }
    }

    public class PossiblyRequiresPart
    extends RequiresModule {
        PossiblyRequiresPart(RefactorOperationBuilder<R> delegate) {
            super(delegate);
        }

        public RequiresModule referencesSharedPart(String resourceFQN, String partName, PartType partType) {
            this.delegate.queryTerms.add(new ValuePartReferenceIndexTerm(resourceFQN, partName, partType));
            return new RequiresModule(this.delegate);
        }

        public RequiresModule referencesPart(String resourceFQN, String partName, PartType partType, ValueIndexTerm.TermSearchType searchType) {
            this.delegate.queryTerms.add(new ValuePartReferenceIndexTerm(resourceFQN, partName, partType, searchType));
            return new RequiresModule(this.delegate);
        }

        public PossiblyRequiresPart pageSize(int pageSize) {
            this.delegate.setPageSize(pageSize);
            return this;
        }

        public PossiblyRequiresPart startRowIndex(int startRowIndex) {
            this.delegate.setStartRowIndex(startRowIndex);
            return this;
        }
    }

    public class RequiresPart
    extends Requires {
        RequiresPart(RefactorOperationBuilder<R> delegate) {
            super(delegate);
        }

        public RequiresModule referencesPart(String resourceFQN, ResourceType resourceType, String partName, PartType partType) {
            this.delegate.queryTerms.add(new ValuePartReferenceIndexTerm(resourceFQN, partName, partType));
            return new RequiresModule(this.delegate);
        }

        public RequiresPart pageSize(int pageSize) {
            this.delegate.setPageSize(pageSize);
            return this;
        }

        public RequiresPart startRowIndex(int startRowIndex) {
            this.delegate.setStartRowIndex(startRowIndex);
            return this;
        }
    }
}

