/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories.git;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GitPathUtil {
    private static final Pattern branchNameExtractorFromPath = Pattern.compile("^[A-Za-z]+://([^@]+)@.*");
    private static final Pattern branchNameExtractorFromRef = Pattern.compile("^refs/(?:heads|remotes/[^/]+)/(.*)");

    public static Optional<String> extractBranch(String uri) {
        Matcher matcher = branchNameExtractorFromPath.matcher(uri);
        if (matcher.matches()) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    public static Optional<String> extractBranchFromRef(String refName) {
        Matcher matcher = branchNameExtractorFromRef.matcher(refName);
        if (matcher.matches()) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }
}

