/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.multiscreen;

import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLDocument;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLLIElement;
import elemental2.dom.Node;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.elemental2.IsElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.views.pfly.widgets.Button;
import org.uberfire.client.views.pfly.widgets.KebabMenu;
import org.uberfire.client.views.pfly.widgets.KebabMenuItem;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;

@Dependent
public class MultiScreenMenuBuilder
implements Function<MenuItem, Optional<HTMLElement>> {
    @Inject
    private AuthorizationManager authManager;
    @Inject
    private User identity;
    @Inject
    private ManagedInstance<KebabMenu> kebabMenus;
    @Inject
    private ManagedInstance<Button> buttons;
    @Inject
    private ManagedInstance<KebabMenuItem> kebabMenuItems;
    @Inject
    private HTMLDocument document;

    @Override
    public Optional<HTMLElement> apply(MenuItem menuItem) {
        return Optional.ofNullable(this.makeItem(menuItem, true));
    }

    protected HTMLElement makeItem(MenuItem item, boolean isRoot) {
        if (!this.authManager.authorize((Resource)item, this.identity)) {
            return null;
        }
        if (item instanceof MenuItemCommand) {
            MenuItemCommand cmdItem = (MenuItemCommand)item;
            return isRoot ? new RootMenuItemCommandMapper().apply(cmdItem) : new MenuItemCommandMapper().apply(cmdItem);
        }
        if (item instanceof MenuGroup) {
            MenuGroup groups = (MenuGroup)item;
            List<HTMLElement> subMenus = groups.getItems().stream().map(i -> this.makeItem((MenuItem)i, false)).collect(Collectors.toList());
            return isRoot ? new RootMenuGroupMapper().apply(groups, subMenus) : new MenuGroupMapper().apply(groups, subMenus);
        }
        if (item instanceof MenuCustom) {
            return new MenuCustomMapper().apply((MenuCustom)item);
        }
        return null;
    }

    private class MenuGroupMapper
    implements BiFunction<MenuGroup, List<HTMLElement>, HTMLElement> {
        private MenuGroupMapper() {
        }

        @Override
        public HTMLElement apply(MenuGroup menuItem, List<HTMLElement> subMenus) {
            HTMLDivElement div = (HTMLDivElement)MultiScreenMenuBuilder.this.document.createElement("div");
            div.classList.add(new String[]{"form-group"});
            subMenus.forEach(e -> div.appendChild((Node)e));
            return div;
        }
    }

    private class RootMenuGroupMapper
    implements BiFunction<MenuGroup, List<HTMLElement>, HTMLElement> {
        private RootMenuGroupMapper() {
        }

        @Override
        public HTMLElement apply(MenuGroup menuItem, List<HTMLElement> subMenus) {
            KebabMenu menu = (KebabMenu)MultiScreenMenuBuilder.this.kebabMenus.get();
            menu.setItemsAlignment(KebabMenu.ItemsAlignment.RIGHT);
            subMenus.forEach(m -> {
                if (m instanceof HTMLLIElement) {
                    menu.addKebabItem((HTMLLIElement)m);
                }
            });
            return menu.getElement();
        }
    }

    private class MenuItemCommandMapper
    implements Function<MenuItemCommand, HTMLElement> {
        private MenuItemCommandMapper() {
        }

        @Override
        public HTMLElement apply(MenuItemCommand menuItem) {
            KebabMenuItem item = (KebabMenuItem)MultiScreenMenuBuilder.this.kebabMenuItems.get();
            item.setText(menuItem.getCaption());
            item.setClickHandler(menuItem.getCommand());
            return item.getElement();
        }
    }

    private class RootMenuItemCommandMapper
    implements Function<MenuItemCommand, HTMLElement> {
        private RootMenuItemCommandMapper() {
        }

        @Override
        public HTMLElement apply(MenuItemCommand menuItem) {
            Button button = (Button)MultiScreenMenuBuilder.this.buttons.get();
            button.setType(Button.ButtonType.BUTTON);
            button.setButtonStyleType(Button.ButtonStyleType.DEFAULT);
            button.setText(menuItem.getCaption());
            button.setEnabled(menuItem.isEnabled());
            button.setClickHandler(menuItem.getCommand());
            menuItem.addEnabledStateChangeListener(button::setEnabled);
            return button.getElement();
        }
    }

    private class MenuCustomMapper
    implements Function<MenuCustom, HTMLElement> {
        private MenuCustomMapper() {
        }

        @Override
        public HTMLElement apply(MenuCustom menuCustom) {
            Object result = menuCustom.build();
            if (result instanceof HTMLElement) {
                return (HTMLElement)result;
            }
            if (result instanceof IsElement) {
                return ((IsElement)result).getElement();
            }
            throw new RuntimeException("Unsupported custom menu type");
        }
    }
}

