/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.factories;

import java.util.List;
import java.util.StringJoiner;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ResultFeature;
import org.drools.compiler.lang.api.RuleDescrBuilder;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.tuples.KiePMMLReasonCodeAndValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLDescrRhsFactory {
    public static final String SET_PMML4_RESULT_CODE = "\r\n$pmml4Result.setResultCode(\"%s\");";
    public static final String ADD_PMML4_RESULT_VARIABLE = "\r\n$pmml4Result.addResultVariable($pmml4Result.getResultObjectName(), %s);";
    public static final String ADD_PMML4_OUTPUT_FIELD = "\r\n$pmml4Result.addResultVariable(\"%s\", %s);";
    public static final String ADD_OUTPUTFIELD_VALUE = "\r\n$outputFieldsMap.put(\"%s\", %s);";
    public static final String UPDATE_STATUS_HOLDER_STATUS = "\r\n$statusHolder.setStatus(\"%s\");";
    public static final String UPDATE_STATUS_HOLDER_ACCUMULATE = "\r\n$statusHolder.accumulate(%s);";
    public static final String UPDATE_STATUS_HOLDER = "\r\nupdate($statusHolder);";
    public static final String RETURN_ACCUMULATION = "\r\n$pmml4Result.addResultVariable($pmml4Result.getResultObjectName(), $statusHolder.getAccumulator());";
    public static final String FOCUS_AGENDA_GROUP = "\r\nkcontext.getKieRuntime().getAgenda().getAgendaGroup( \"%s\" ).setFocus();";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLDescrRhsFactory.class.getName());
    final RuleDescrBuilder builder;

    private KiePMMLDescrRhsFactory(RuleDescrBuilder builder) {
        this.builder = builder;
    }

    public static KiePMMLDescrRhsFactory factory(RuleDescrBuilder builder) {
        return new KiePMMLDescrRhsFactory(builder);
    }

    public void declareRhs(KiePMMLDroolsRule rule) {
        logger.trace("declareRhs {}", (Object)rule);
        if (rule.getIfBreakField() != null) {
            this.declareIfThen(rule);
        } else {
            this.declareDefaultThen(rule);
        }
    }

    protected void declareDefaultThen(KiePMMLDroolsRule rule) {
        StringJoiner joiner = new StringJoiner("");
        if (rule.getStatusToSet() != null) {
            joiner.add(String.format(UPDATE_STATUS_HOLDER_STATUS, rule.getStatusToSet()));
        }
        if (rule.getStatusToSet() != null || rule.getToAccumulate() != null) {
            joiner.add(UPDATE_STATUS_HOLDER);
        }
        this.commonDeclareThen(rule, joiner);
        this.builder.rhs(joiner.toString());
    }

    protected void declareIfThen(KiePMMLDroolsRule rule) {
        this.builder.rhs(String.format(UPDATE_STATUS_HOLDER_STATUS, rule.getStatusToSet()));
        StringJoiner joiner = new StringJoiner("");
        joiner.add(String.format(UPDATE_STATUS_HOLDER_STATUS, "DONE"));
        this.commonDeclareThen(rule, joiner);
        this.builder.namedRhs("match", joiner.toString());
    }

    protected void commonDeclareThen(KiePMMLDroolsRule rule, StringJoiner joiner) {
        if (rule.getFocusedAgendaGroup() != null) {
            joiner.add(String.format(FOCUS_AGENDA_GROUP, rule.getFocusedAgendaGroup()));
        }
        if (rule.getToAccumulate() != null) {
            joiner.add(String.format(UPDATE_STATUS_HOLDER_ACCUMULATE, rule.getToAccumulate()));
        }
        if (rule.isAccumulationResult()) {
            joiner.add(RETURN_ACCUMULATION);
        }
        if (rule.getResultCode() != null) {
            joiner.add(String.format(SET_PMML4_RESULT_CODE, rule.getResultCode()));
        }
        if (rule.getResult() != null) {
            joiner.add(String.format(ADD_PMML4_RESULT_VARIABLE, rule.getResult()));
        }
        if (rule.getReasonCodeAndValue() != null) {
            KiePMMLReasonCodeAndValue reasonCodeAndValue = rule.getReasonCodeAndValue();
            joiner.add(String.format(ADD_OUTPUTFIELD_VALUE, reasonCodeAndValue.getReasonCode(), reasonCodeAndValue.getValue()));
        }
        if (rule.getOutputFields() != null) {
            if (rule.getResult() != null) {
                this.commonDeclareOutputFields(rule.getOutputFields(), rule.getResult(), joiner);
            } else if (rule.isAccumulationResult()) {
                this.commonDeclareOutputFields(rule.getOutputFields(), "$statusHolder.getAccumulator()", joiner);
            }
        }
    }

    protected void commonDeclareOutputFields(List<OutputField> outputFields, Object result, StringJoiner joiner) {
        outputFields.forEach(kiePMMLOutputField -> {
            if (ResultFeature.PREDICTED_VALUE.equals((Object)kiePMMLOutputField.getResultFeature())) {
                joiner.add(String.format(ADD_PMML4_OUTPUT_FIELD, kiePMMLOutputField.getName(), result));
            }
        });
    }
}

