/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeModifier;
import com.fasterxml.jackson.databind.type.TypeParser;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.LookupCache;

public class FallbackableTypeFactory
extends TypeFactory {
    private static final long serialVersionUID = 1L;
    protected final transient ClassLoader fallbackClassLoader;
    protected static final FallbackableTypeFactory instance = new FallbackableTypeFactory();

    private FallbackableTypeFactory() {
        super((LookupCache)null);
        this.fallbackClassLoader = null;
    }

    protected FallbackableTypeFactory(LookupCache<Object, JavaType> typeCache) {
        super(typeCache);
        this.fallbackClassLoader = null;
    }

    protected FallbackableTypeFactory(LookupCache<Object, JavaType> typeCache, TypeParser p, TypeModifier[] mods, ClassLoader classLoader) {
        super(typeCache, p, mods, classLoader);
        this.fallbackClassLoader = null;
    }

    protected FallbackableTypeFactory(LookupCache<Object, JavaType> typeCache, TypeParser p, TypeModifier[] mods, ClassLoader classLoader, ClassLoader fallbackClassLoader) {
        super(typeCache, p, mods, classLoader);
        this.fallbackClassLoader = fallbackClassLoader;
    }

    public FallbackableTypeFactory withFallbackClassLoader(ClassLoader fallbackClassLoader) {
        return new FallbackableTypeFactory((LookupCache<Object, JavaType>)this._typeCache, this._parser, this._modifiers, this._classLoader, fallbackClassLoader);
    }

    public FallbackableTypeFactory withModifier(TypeModifier mod) {
        TypeModifier[] mods;
        LookupCache typeCache = this._typeCache;
        if (mod == null) {
            mods = null;
            typeCache = null;
        } else if (this._modifiers == null) {
            mods = new TypeModifier[]{mod};
            typeCache = null;
        } else {
            mods = (TypeModifier[])ArrayBuilders.insertInListNoDup((Object[])this._modifiers, (Object)mod);
        }
        return new FallbackableTypeFactory((LookupCache<Object, JavaType>)typeCache, this._parser, mods, this._classLoader, this.fallbackClassLoader);
    }

    public FallbackableTypeFactory withClassLoader(ClassLoader classLoader) {
        return new FallbackableTypeFactory((LookupCache<Object, JavaType>)this._typeCache, this._parser, this._modifiers, classLoader, this.fallbackClassLoader);
    }

    public FallbackableTypeFactory withCache(LookupCache<Object, JavaType> cache) {
        return new FallbackableTypeFactory(cache, this._parser, this._modifiers, this._classLoader, this.fallbackClassLoader);
    }

    public static FallbackableTypeFactory defaultInstance() {
        return instance;
    }

    public ClassLoader getFallbackClassLoader() {
        return this.fallbackClassLoader;
    }

    public Class<?> findClass(String className) throws ClassNotFoundException {
        try {
            return super.findClass(className);
        }
        catch (ClassNotFoundException e) {
            if (this.fallbackClassLoader != null) {
                Throwable prob = null;
                try {
                    return this.classForName(className, true, this.fallbackClassLoader);
                }
                catch (Exception e1) {
                    prob = ClassUtil.getRootCause((Throwable)e1);
                    throw new ClassNotFoundException(prob.getMessage(), prob);
                }
            }
            throw e;
        }
    }
}

