/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql.dialect;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.dashbuilder.dataprovider.sql.dialect.DefaultDialect;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataprovider.sql.model.Select;

public class SybaseASEDialect
extends DefaultDialect {
    SimpleDateFormat sybaseDateFormat = new SimpleDateFormat("yyyyMMdd HH:mm:ss");

    @Override
    public String getColumnTypeSQL(Column column) {
        switch (column.getType()) {
            case NUMBER: {
                return "NUMERIC(28,3)";
            }
            case DATE: {
                return "DATETIME";
            }
        }
        return "VARCHAR(" + column.getLength() + ")";
    }

    @Override
    public Date convertToDate(Object value) {
        if (value == null) {
            return null;
        }
        Long time = (Long)this.invokeMethod(value, "getTime", null);
        return new Date(time);
    }

    @Override
    public String getDateParameterSQL(Date param) {
        return "'" + this.sybaseDateFormat.format(param) + "'";
    }

    @Override
    public String getColumnCastSQL(Column column) {
        String columnSQL = this.getColumnSQL(column);
        return "CONVERT(VARCHAR, " + columnSQL + ")";
    }

    @Override
    public String getDatePartFunctionSQL(String part, Column column) {
        String columnSQL = this.getColumnSQL(column);
        return "DATEPART(" + part + "," + columnSQL + ")";
    }

    @Override
    public String getConcatFunctionSQL(Column[] columns, String begin, String end, String separator) {
        return super.getConcatFunctionSQL(columns, begin, end, separator);
    }

    @Override
    public String getSelectStatement(Select select) {
        int offset = select.getOffset();
        int limit = select.getLimit();
        if (limit >= 0) {
            if (offset > 0) {
                select.setOffsetPostProcessing(true);
                return "SELECT TOP " + (offset + limit);
            }
            return "SELECT TOP " + limit;
        }
        if (offset > 0) {
            select.setOffsetPostProcessing(true);
        }
        return "SELECT";
    }

    @Override
    public String getOffsetLimitSQL(Select select) {
        return null;
    }
}

