/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.balancer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.balancer.BalancerStrategy;
import org.kie.server.client.balancer.impl.AbstractBalancerStrategy;
import org.kie.server.client.balancer.impl.RandomBalancerStrategy;
import org.kie.server.client.balancer.impl.RoundRobinBalancerStrategy;
import org.kie.server.common.rest.KieServerHttpRequest;
import org.kie.server.common.rest.KieServerHttpRequestException;
import org.kie.server.common.rest.NoEndpointFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancer {
    private static final Logger logger = LoggerFactory.getLogger(LoadBalancer.class);
    private static final String URL_SEP = "\\|";
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final BalancerStrategy balancerStrategy;
    private CopyOnWriteArraySet<String> failedEndpoints = new CopyOnWriteArraySet();
    private String userName;
    private String password;

    protected LoadBalancer(BalancerStrategy balancerStrategy) {
        this.balancerStrategy = balancerStrategy;
    }

    public String getUrl() throws KieServerHttpRequestException {
        try {
            String selectedUrl = this.balancerStrategy.next();
            logger.debug("Load balancer {} selected url '{}'", (Object)this.balancerStrategy, (Object)selectedUrl);
            return selectedUrl;
        }
        catch (NoEndpointFoundException e) {
            this.checkFailedEndpoints();
            throw e;
        }
    }

    public String markAsFailed(String url) {
        String baseUrl = this.balancerStrategy.markAsOffline(url);
        this.failedEndpoints.add(baseUrl);
        logger.debug("Url '{}' is marked as failed and will be considered offline by {}", (Object)url, (Object)this.balancerStrategy);
        return baseUrl;
    }

    public void activate(String url) {
        String baseUrl = this.balancerStrategy.markAsOnline(url);
        this.failedEndpoints.remove(baseUrl);
        logger.debug("Url '{}' is marked as activated and will be considered online by {}", (Object)url, (Object)this.balancerStrategy);
    }

    public void close() {
        try {
            this.executorService.shutdownNow();
        }
        catch (Exception e) {
            logger.debug("Error when shutting down load balancer executor service");
        }
    }

    public List<String> getAvailableEndpoints() {
        return this.balancerStrategy.getAvailableEndpoints();
    }

    public List<String> getFailedEndpoints() {
        return new ArrayList<String>(this.failedEndpoints);
    }

    public Future<?> checkFailedEndpoints() {
        return this.executorService.submit(new CheckFailedEndpoints());
    }

    public static LoadBalancer getDefault(KieServicesConfiguration config) {
        LoadBalancer loadBalancer = LoadBalancer.getDefault(config.getServerUrl());
        loadBalancer.userName = config.getUserName();
        loadBalancer.password = config.getPassword();
        return loadBalancer;
    }

    public static LoadBalancer getDefault(String urls) {
        String[] endpoints = new String[]{};
        if (urls != null) {
            endpoints = urls.split(URL_SEP);
        }
        return LoadBalancer.getDefault(Arrays.asList(endpoints));
    }

    public static LoadBalancer getDefault(List<String> urls) {
        RoundRobinBalancerStrategy strategy = new RoundRobinBalancerStrategy(urls);
        return new LoadBalancer(strategy);
    }

    public static LoadBalancer forStrategy(String urls, BalancerStrategy.Type type) {
        String[] endpoints = urls.split(URL_SEP);
        return LoadBalancer.forStrategy(Arrays.asList(endpoints), type);
    }

    public static LoadBalancer forStrategy(List<String> urls, BalancerStrategy.Type type) {
        AbstractBalancerStrategy strategy = null;
        switch (type) {
            case RANDOM_STRATEGY: {
                strategy = new RandomBalancerStrategy(urls);
                break;
            }
            case ROUND_ROBIN_STRATEGY: {
                strategy = new RoundRobinBalancerStrategy(urls);
            }
        }
        if (strategy == null) {
            throw new IllegalArgumentException("Unknown strategy type " + (Object)((Object)type));
        }
        return new LoadBalancer(strategy);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private class CheckFailedEndpoints
    implements Runnable {
        private CheckFailedEndpoints() {
        }

        @Override
        public void run() {
            if (LoadBalancer.this.failedEndpoints == null || LoadBalancer.this.failedEndpoints.isEmpty()) {
                return;
            }
            logger.debug("Starting to scan if any of the failed endpoints is back online");
            for (String failedEndpoint : LoadBalancer.this.failedEndpoints) {
                try {
                    KieServerHttpRequest httpRequest = KieServerHttpRequest.newRequest((String)failedEndpoint, (String)LoadBalancer.this.userName, (String)LoadBalancer.this.password).followRedirects(true).timeout(1000L);
                    httpRequest.get();
                    logger.debug("Url '{}' is back online, adding it to load balancer", (Object)failedEndpoint);
                    LoadBalancer.this.activate(failedEndpoint);
                }
                catch (Exception e) {
                    logger.debug("Url '{}' is still offline due to {}", (Object)failedEndpoint, (Object)(e.getCause() == null ? e.getMessage() : e.getCause().getMessage()));
                }
            }
        }
    }
}

