/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.spi.FactHandleFactory;

public abstract class AbstractFactHandleFactory
implements FactHandleFactory {
    private IdsGenerator idGen;
    private AtomicLong counter;

    public AbstractFactHandleFactory() {
        this.idGen = new IdsGenerator(0L);
        this.counter = new AtomicLong(0L);
    }

    public AbstractFactHandleFactory(long id, long counter) {
        this.idGen = new IdsGenerator(id);
        this.counter = new AtomicLong(counter);
    }

    @Override
    public final InternalFactHandle newFactHandle(Object object, ObjectTypeConf conf, InternalWorkingMemory workingMemory, WorkingMemoryEntryPoint wmEntryPoint) {
        return this.newFactHandle(this.getNextId(), object, conf, workingMemory, wmEntryPoint);
    }

    public final InternalFactHandle newFactHandle(long id, Object object, ObjectTypeConf conf, InternalWorkingMemory workingMemory, WorkingMemoryEntryPoint wmEntryPoint) {
        return this.newFactHandle(id, object, this.getNextRecency(), conf, workingMemory, wmEntryPoint);
    }

    @Override
    public abstract InternalFactHandle newFactHandle(long var1, Object var3, long var4, ObjectTypeConf var6, InternalWorkingMemory var7, WorkingMemoryEntryPoint var8);

    @Override
    public final void increaseFactHandleRecency(InternalFactHandle factHandle) {
        factHandle.setRecency(this.getNextRecency());
    }

    @Override
    public void destroyFactHandle(InternalFactHandle factHandle) {
        factHandle.invalidate();
    }

    @Override
    public abstract FactHandleFactory newInstance();

    @Override
    public long getNextId() {
        return this.idGen.getNextId();
    }

    @Override
    public long getNextRecency() {
        return this.counter.incrementAndGet();
    }

    @Override
    public long getId() {
        return this.idGen.getId();
    }

    @Override
    public long getRecency() {
        return this.counter.get();
    }

    @Override
    public void clear(long id, long counter) {
        this.idGen = new IdsGenerator(id);
        this.counter = new AtomicLong(counter);
    }

    @Override
    public void doRecycleIds(Collection<Long> usedIds) {
        this.idGen.doRecycle(usedIds);
    }

    @Override
    public void stopRecycleIds() {
        this.idGen.stopRecycle();
    }

    private static class IdsGenerator {
        private AtomicLong id;
        private Queue<Long> usedIds;
        private long recycledId;

        private IdsGenerator(long startId) {
            this.id = new AtomicLong(startId);
        }

        public long getNextId() {
            long l;
            if (this.hasRecycledId()) {
                long l2 = this.recycledId;
                l = l2;
                this.recycledId = l2 + 1L;
            } else {
                l = this.id.incrementAndGet();
            }
            return l;
        }

        private boolean hasRecycledId() {
            if (this.usedIds != null) {
                while (!this.usedIds.isEmpty()) {
                    long firstUsedId = this.usedIds.peek();
                    if (this.recycledId < firstUsedId) {
                        return true;
                    }
                    if (this.recycledId == firstUsedId) {
                        ++this.recycledId;
                    }
                    this.usedIds.poll();
                }
                this.usedIds = null;
            }
            return false;
        }

        public long getId() {
            return this.id.get();
        }

        public void doRecycle(Collection<Long> usedIds) {
            this.usedIds = usedIds.stream().sorted().collect(Collectors.toCollection(ArrayDeque::new));
            this.usedIds.add(this.id.get() + 1L);
            this.recycledId = 1L;
        }

        public void stopRecycle() {
            this.usedIds = null;
        }
    }
}

