/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.jms;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.jbpm.casemgmt.api.audit.CaseFileData;
import org.jbpm.casemgmt.api.event.CaseDataEvent;
import org.jbpm.casemgmt.api.event.CaseEvent;
import org.jbpm.casemgmt.api.event.CaseEventListener;
import org.jbpm.casemgmt.api.event.CaseReopenEvent;
import org.jbpm.casemgmt.api.event.CaseRoleAssignmentEvent;
import org.jbpm.casemgmt.api.event.CaseStartEvent;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseRoleInstance;
import org.jbpm.casemgmt.impl.audit.CaseFileDataLog;
import org.jbpm.casemgmt.impl.audit.CaseIndexerManager;
import org.jbpm.casemgmt.impl.audit.CaseRoleAssignmentLog;
import org.jbpm.casemgmt.impl.model.AuditCaseInstanceData;
import org.jbpm.casemgmt.impl.model.instance.CaseFileInstanceImpl;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.internal.runtime.Cacheable;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.soup.xstream.XStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncCaseInstanceAuditEventProducer
implements CaseEventListener,
Cacheable {
    private static final Logger logger = LoggerFactory.getLogger(AsyncCaseInstanceAuditEventProducer.class);
    private ConnectionFactory connectionFactory;
    private Queue queue;
    private boolean transacted = true;
    private XStream xstream;
    private CaseIndexerManager indexManager = CaseIndexerManager.get();

    public AsyncCaseInstanceAuditEventProducer() {
        this.initXStream();
    }

    private void initXStream() {
        if (this.xstream == null) {
            this.xstream = XStreamUtils.createTrustingXStream();
            String[] voidDeny = new String[]{"void.class", "Void.class"};
            this.xstream.denyTypes(voidDeny);
        }
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public void afterCaseStarted(CaseStartEvent event) {
        CaseFileInstance caseFile = event.getCaseFile();
        if (caseFile == null) {
            return;
        }
        ArrayList<CaseRoleAssignmentLog> caseRoleAssignmentsLogs = new ArrayList<CaseRoleAssignmentLog>();
        Collection<CaseRoleInstance> caseRoleAssignments = ((CaseFileInstanceImpl)caseFile).getAssignments();
        if (caseRoleAssignments != null && !caseRoleAssignments.isEmpty()) {
            for (CaseRoleInstance roleAssignment : caseRoleAssignments) {
                logger.debug("Role {} has following assignments {}", (Object)roleAssignment.getRoleName(), (Object)roleAssignment.getRoleAssignments());
                if (roleAssignment.getRoleAssignments() == null || roleAssignment.getRoleAssignments().isEmpty()) continue;
                roleAssignment.getRoleAssignments().forEach(entity -> {
                    CaseRoleAssignmentLog assignmentLog = new CaseRoleAssignmentLog(event.getProcessInstanceId(), event.getCaseId(), roleAssignment.getRoleName(), (OrganizationalEntity)entity);
                    caseRoleAssignmentsLogs.add(assignmentLog);
                });
            }
        } else {
            CaseRoleAssignmentLog assignmentLog = new CaseRoleAssignmentLog(event.getProcessInstanceId(), event.getCaseId(), "*", (OrganizationalEntity)TaskModelProvider.getFactory().newGroup("_public_"));
            caseRoleAssignmentsLogs.add(assignmentLog);
        }
        Map initialData = caseFile.getData();
        ArrayList<CaseFileData> caseFileDataLogs = new ArrayList<CaseFileData>();
        if (!initialData.isEmpty()) {
            initialData.forEach((name, value) -> {
                if (value != null) {
                    List<CaseFileData> indexedValues = this.indexManager.index((CaseEvent)event, (String)name, value);
                    caseFileDataLogs.addAll(indexedValues);
                }
            });
        }
        this.sendMessage(0, new AuditCaseInstanceData(event.getCaseId(), caseFileDataLogs, caseRoleAssignmentsLogs), 8);
    }

    public void afterCaseReopen(CaseReopenEvent event) {
        List<CaseFileData> logs = this.updateCaseFileItems((CaseEvent)event, event.getData(), event.getCaseId(), event.getCaseDefinitionId(), event.getUser());
        this.sendMessage(1, new AuditCaseInstanceData(event.getProcessInstanceId(), event.getCaseId(), logs, null), 4);
    }

    public void afterCaseRoleAssignmentAdded(CaseRoleAssignmentEvent event) {
        CaseRoleAssignmentLog assignmentLog = new CaseRoleAssignmentLog(-1L, event.getCaseId(), event.getRole(), event.getEntity());
        this.sendMessage(2, new AuditCaseInstanceData(event.getCaseId(), null, Collections.singletonList(assignmentLog)), 4);
    }

    public void afterCaseRoleAssignmentRemoved(CaseRoleAssignmentEvent event) {
        CaseRoleAssignmentLog assignmentLog = new CaseRoleAssignmentLog(-1L, event.getCaseId(), event.getRole(), event.getEntity());
        this.sendMessage(3, new AuditCaseInstanceData(event.getCaseId(), null, Collections.singletonList(assignmentLog)), 4);
    }

    public void afterCaseDataAdded(CaseDataEvent event) {
        List<CaseFileData> logs = this.updateCaseFileItems((CaseEvent)event, event.getData(), event.getCaseId(), event.getDefinitionId(), event.getUser());
        if (logs != null && !logs.isEmpty()) {
            this.sendMessage(4, new AuditCaseInstanceData(event.getCaseId(), logs, null), 4);
        }
    }

    public void afterCaseDataRemoved(CaseDataEvent event) {
        List<CaseFileData> logs = event.getData().keySet().stream().map(name -> new CaseFileDataLog(event.getCaseId(), event.getDefinitionId(), (String)name)).collect(Collectors.toList());
        if (logs != null && !logs.isEmpty()) {
            this.sendMessage(5, new AuditCaseInstanceData(event.getCaseId(), logs, null), 4);
        }
    }

    public void close() {
    }

    protected void sendMessage(Integer eventType, AuditCaseInstanceData eventData, int priority) {
        if (this.connectionFactory == null && this.queue == null) {
            throw new IllegalStateException("ConnectionFactory and Queue cannot be null");
        }
        Connection queueConnection = null;
        Session queueSession = null;
        MessageProducer producer = null;
        try {
            queueConnection = this.connectionFactory.createConnection();
            queueSession = queueConnection.createSession(this.transacted, 1);
            String eventXml = this.xstream.toXML((Object)eventData);
            TextMessage message = queueSession.createTextMessage(eventXml);
            message.setStringProperty("LogType", "Case");
            message.setIntProperty("EventType", eventType.intValue());
            producer = queueSession.createProducer((Destination)this.queue);
            producer.setPriority(priority);
            producer.send((Message)message);
        }
        catch (Exception e) {
            throw new RuntimeException("Error when sending JMS message with working memory event", e);
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (JMSException e) {
                    logger.warn("Error when closing producer", (Throwable)e);
                }
            }
            if (queueSession != null) {
                try {
                    queueSession.close();
                }
                catch (JMSException e) {
                    logger.warn("Error when closing queue session", (Throwable)e);
                }
            }
            if (queueConnection != null) {
                try {
                    queueConnection.close();
                }
                catch (JMSException e) {
                    logger.warn("Error when closing queue connection", (Throwable)e);
                }
            }
        }
    }

    protected List<CaseFileData> updateCaseFileItems(CaseEvent event, Map<String, Object> addedData, String caseId, String caseDefinitionId, String user) {
        if (addedData.isEmpty()) {
            return null;
        }
        ArrayList<CaseFileData> logs = new ArrayList<CaseFileData>();
        addedData.forEach((name, value) -> {
            if (value != null) {
                List<CaseFileData> indexedValues = this.indexManager.index(event, (String)name, value);
                logs.addAll(indexedValues);
            }
        });
        return logs;
    }
}

