/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.Collection;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.plugin.PluginUtil;
import org.uberfire.security.Contributor;
import org.uberfire.security.ContributorResource;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCheck;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.authz.ResourceCheck;
import org.uberfire.security.authz.VotingStrategy;
import org.uberfire.security.impl.authz.PermissionCheckImpl;
import org.uberfire.security.impl.authz.ResourceCheckImpl;

@ApplicationScoped
public class DefaultAuthorizationManager
implements AuthorizationManager {
    private PermissionManager permissionManager;

    public DefaultAuthorizationManager() {
    }

    @Inject
    public DefaultAuthorizationManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Override
    public boolean authorize(Resource resource, User user) {
        return this.authorize(resource, null, user, null);
    }

    @Override
    public boolean authorize(Resource resource, ResourceAction action, User user) {
        return this.authorize(resource, action, user, null);
    }

    @Override
    public boolean authorize(Resource resource, Collection<Contributor> contributors, ResourceAction action, User user) {
        boolean contributorAccess = false;
        if (resource instanceof ContributorResource) {
            ContributorResource contributorResource = (ContributorResource)resource;
            contributorAccess = this.checkContributor(contributorResource, user);
        }
        return this.authorize(resource, action, user, null) || contributorAccess;
    }

    private boolean checkContributor(ContributorResource contributorResource, User user) {
        return contributorResource.getContributors().stream().anyMatch(c -> c.getUsername().equals(user.getIdentifier()));
    }

    @Override
    public boolean authorize(ResourceType resourceType, ResourceAction action, User user) {
        return this.authorize(resourceType, action, user, null);
    }

    @Override
    public boolean authorize(Resource resource, User user, VotingStrategy votingStrategy) {
        return this.authorize(resource, null, user, votingStrategy);
    }

    @Override
    public boolean authorize(Resource resource, ResourceAction action, User user, VotingStrategy votingStrategy) {
        PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
        PortablePreconditions.checkNotNull((String)"subject", (Object)user);
        List deps = resource.getDependencies();
        if (deps != null && !deps.isEmpty()) {
            for (Resource dep : PluginUtil.ensureIterable((List)deps)) {
                boolean itemAccess = this.authorize(dep, action, user);
                if (!itemAccess) continue;
                return true;
            }
            return false;
        }
        Permission p = this.permissionManager.createPermission(resource, action, true);
        return this.authorize(p, user, votingStrategy);
    }

    @Override
    public boolean authorize(ResourceType resourceType, ResourceAction action, User user, VotingStrategy votingStrategy) {
        Permission p = this.permissionManager.createPermission(resourceType, action, true);
        return this.authorize(p, user, votingStrategy);
    }

    @Override
    public boolean authorize(String permission, User user) {
        return this.authorize(permission, user, null);
    }

    @Override
    public boolean authorize(Permission permission, User user) {
        return this.authorize(permission, user, null);
    }

    @Override
    public boolean authorize(String permission, User user, VotingStrategy votingStrategy) {
        Permission p = this.permissionManager.createPermission(permission, true);
        return this.authorize(p, user, votingStrategy);
    }

    @Override
    public boolean authorize(Permission permission, User user, VotingStrategy votingStrategy) {
        AuthorizationResult result = this.permissionManager.checkPermission(permission, user, votingStrategy);
        return !AuthorizationResult.ACCESS_DENIED.equals((Object)result);
    }

    @Override
    public ResourceCheck check(Resource target, User user) {
        return this.check(target, user, null);
    }

    @Override
    public ResourceCheck check(Resource target, User user, VotingStrategy votingStrategy) {
        return new ResourceCheckImpl((AuthorizationManager)this, target, user, votingStrategy);
    }

    @Override
    public ResourceCheck check(ResourceType target, User user) {
        return this.check(target, user, null);
    }

    @Override
    public ResourceCheck check(ResourceType target, User user, VotingStrategy votingStrategy) {
        return new ResourceCheckImpl((AuthorizationManager)this, target, user, votingStrategy);
    }

    @Override
    public PermissionCheck check(String permission, User user) {
        return this.check(permission, user, null);
    }

    @Override
    public PermissionCheck check(String permission, User user, VotingStrategy votingStrategy) {
        return new PermissionCheckImpl(this.permissionManager, permission, user, votingStrategy);
    }

    @Override
    public void invalidate(User user) {
        this.permissionManager.invalidate(user);
    }
}

