/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.prometheus;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Summary;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.executor.AsynchronousJobEvent;
import org.jbpm.executor.AsynchronousJobListener;
import org.kie.api.executor.RequestInfo;
import org.kie.api.executor.STATUS;
import org.kie.server.services.prometheus.PrometheusMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusJobListener
implements AsynchronousJobListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusJobListener.class);
    protected static final Gauge numberOfRunningJobs = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("kie_server_job_running_total")).help("Kie Server Running Jobs")).labelNames(new String[]{"container_id", "command_name"})).register();
    protected static final Counter numberOfJobsScheduled = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_server_job_scheduled_total")).help("Kie Server Started Jobs")).labelNames(new String[]{"container_id", "command_name"})).register();
    protected static final Counter numberOfJobsExecuted = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_server_job_executed_total")).help("Kie Server Executed Jobs")).labelNames(new String[]{"container_id", "failed", "command_name"})).register();
    protected static final Counter numberOfJobsCancelled = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_server_job_cancelled_total")).help("Kie Server Cancelled Jobs")).labelNames(new String[]{"container_id", "command_name"})).register();
    protected static final Summary jobDuration = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("kie_server_job_duration_seconds")).help("Kie Server Job Duration")).labelNames(new String[]{"container_id", "command_name"})).register();
    protected static final Gauge numberOfJobsRetrying = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("kie_server_job_in_retry_total")).help("Kie Server Retrying Jobs")).labelNames(new String[]{"container_id", "failed", "command_name"})).register();
    protected static final Counter numberOfJobsErrored = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_server_job_error_total")).help("Kie Server Errored Jobs")).labelNames(new String[]{"container_id", "failed", "command_name"})).register();

    public void beforeJobScheduled(AsynchronousJobEvent event) {
    }

    public void afterJobScheduled(AsynchronousJobEvent event) {
        LOGGER.debug("After job scheduled event: {}", (Object)event);
        RequestInfo job = event.getJob();
        ((Counter.Child)numberOfJobsScheduled.labels(new String[]{StringUtils.defaultString((String)job.getDeploymentId()), job.getCommandName()})).inc();
    }

    public void beforeJobExecuted(AsynchronousJobEvent event) {
        LOGGER.debug("Before job executed event: {}", (Object)event);
        RequestInfo job = event.getJob();
        ((Gauge.Child)numberOfRunningJobs.labels(new String[]{StringUtils.defaultString((String)job.getDeploymentId()), job.getCommandName()})).inc();
    }

    public void afterJobExecuted(AsynchronousJobEvent event) {
        LOGGER.debug("After job executed event: {}", (Object)event);
        RequestInfo job = event.getJob();
        ((Counter.Child)numberOfJobsExecuted.labels(new String[]{StringUtils.defaultString((String)job.getDeploymentId()), String.valueOf(event.failed()), job.getCommandName()})).inc();
        ((Gauge.Child)numberOfRunningJobs.labels(new String[]{StringUtils.defaultString((String)job.getDeploymentId()), job.getCommandName()})).dec();
        if (job.getRetries() >= 0 && job.getStatus().equals((Object)STATUS.RETRYING) && job.getExecutions() <= 2) {
            ((Gauge.Child)numberOfJobsRetrying.labels(new String[]{StringUtils.defaultString((String)job.getDeploymentId()), String.valueOf(event.failed()), job.getCommandName()})).inc();
        } else if (job.getRetries() == 0 && job.getStatus().equals((Object)STATUS.ERROR)) {
            ((Counter.Child)numberOfJobsErrored.labels(new String[]{StringUtils.defaultString((String)job.getDeploymentId()), String.valueOf(event.failed()), job.getCommandName()})).inc();
            if (job.getExecutions() > 2) {
                ((Gauge.Child)numberOfJobsRetrying.labels(new String[]{StringUtils.defaultString((String)job.getDeploymentId()), String.valueOf(event.failed()), job.getCommandName()})).dec();
            }
        }
        if (job.getTime() != null) {
            double duration = PrometheusMetrics.millisToSeconds(System.currentTimeMillis() - job.getTime().getTime());
            LOGGER.debug("Job duration: {}s", (Object)duration);
            ((Summary.Child)jobDuration.labels(new String[]{StringUtils.defaultString((String)job.getDeploymentId()), job.getCommandName()})).observe(duration);
        }
    }

    public void beforeJobCancelled(AsynchronousJobEvent event) {
    }

    public void afterJobCancelled(AsynchronousJobEvent event) {
        LOGGER.debug("After job cancelled event: {}", (Object)event);
        RequestInfo job = event.getJob();
        ((Counter.Child)numberOfJobsCancelled.labels(new String[]{StringUtils.defaultString((String)job.getDeploymentId()), job.getCommandName()})).inc();
    }
}

