/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.locator;

import java.util.List;
import javax.persistence.EntityManager;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.jbpm.locator.ByContextMappingInfoContainerLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessContainerLocator
implements ContainerLocator {
    private static final Logger logger = LoggerFactory.getLogger(ByContextMappingInfoContainerLocator.class);
    private final Long processInstanceId;
    private String containerId;

    protected ProcessContainerLocator(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String locateContainer(String alias, List<? extends KieContainerInstance> containerInstances) {
        if (this.containerId != null) {
            logger.debug("Container id has already be found for process instance {} and is {}", (Object)this.processInstanceId, (Object)this.containerId);
            return this.containerId;
        }
        logger.debug("Searching for container id for process instance id {} and alias {}", (Object)this.processInstanceId, (Object)alias);
        try (EntityManager em = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.domain").createEntityManager();){
            this.containerId = this.invokeQuery(em, this.processInstanceId);
            logger.debug("Found container id '{}' for process instance id {}", (Object)this.containerId, (Object)this.processInstanceId);
            String string = this.containerId;
            return string;
        }
    }

    protected abstract String invokeQuery(EntityManager var1, Long var2);
}

