/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.jpa;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;

public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    private String persistenceUnitName;
    private String persistenceProviderClassName;
    private String transactionType = "JTA";
    private String jtaDataSource;
    private String nonJtaDataSource;
    private List<String> mappingFileNames = new ArrayList<String>();
    private List<URL> jarFileUrls = new ArrayList<URL>();
    private URL persistenceUnitRootUrl;
    private List<String> managedClassNames = new ArrayList<String>();
    private boolean excludeUnlistedClasses;
    private String sharedCacheMode = SharedCacheMode.NONE.toString();
    private String validationMode = ValidationMode.NONE.toString();
    private Properties properties = new Properties();
    private String persistenceXMLSchemaVersion;
    private Set<ClassTransformer> classTransformers = new HashSet<ClassTransformer>();
    private ClassLoader classLoader;
    private ClassLoader tmpClassLoader;
    private InitialContext initialContext;

    public PersistenceUnitInfoImpl(InitialContext initialContext, ClassLoader classLoader) {
        this.initialContext = initialContext;
        this.classLoader = classLoader;
        this.tmpClassLoader = classLoader;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceProviderClassName;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return PersistenceUnitTransactionType.valueOf((String)this.transactionType);
    }

    public DataSource getJtaDataSource() {
        if (this.jtaDataSource == null) {
            return null;
        }
        try {
            return (DataSource)this.initialContext.lookup(this.jtaDataSource);
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to find jta data source under name " + this.jtaDataSource);
        }
    }

    public DataSource getNonJtaDataSource() {
        if (this.nonJtaDataSource == null) {
            return null;
        }
        try {
            return (DataSource)this.initialContext.lookup(this.nonJtaDataSource);
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to find non jta data source under name " + this.nonJtaDataSource);
        }
    }

    public List<String> getMappingFileNames() {
        return this.mappingFileNames;
    }

    public List<URL> getJarFileUrls() {
        return this.jarFileUrls;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitRootUrl;
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public SharedCacheMode getSharedCacheMode() {
        return SharedCacheMode.valueOf((String)this.sharedCacheMode);
    }

    public ValidationMode getValidationMode() {
        return ValidationMode.valueOf((String)this.validationMode);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getPersistenceXMLSchemaVersion() {
        return this.persistenceXMLSchemaVersion;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void addTransformer(ClassTransformer transformer) {
        this.classTransformers.add(transformer);
    }

    public ClassLoader getNewTempClassLoader() {
        return this.tmpClassLoader;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public void setPersistenceProviderClassName(String persistenceProviderClassName) {
        this.persistenceProviderClassName = persistenceProviderClassName;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public void setJtaDataSource(String jtaDataSource) {
        this.jtaDataSource = jtaDataSource;
    }

    public void setNonJtaDataSource(String nonJtaDataSource) {
        this.nonJtaDataSource = nonJtaDataSource;
    }

    public void setMappingFileNames(List<String> mappingFileNames) {
        this.mappingFileNames = mappingFileNames;
    }

    public void setJarFileUrls(List<URL> jarFileUrls) {
        this.jarFileUrls = jarFileUrls;
    }

    public void setPersistenceUnitRootUrl(URL persistenceUnitRootUrl) {
        this.persistenceUnitRootUrl = persistenceUnitRootUrl;
    }

    public void setManagedClassNames(List<String> managedClassNames) {
        this.managedClassNames = managedClassNames;
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.excludeUnlistedClasses = excludeUnlistedClasses;
    }

    public void setSharedCacheMode(String sharedCacheMode) {
        this.sharedCacheMode = sharedCacheMode;
    }

    public void setValidationMode(String validationMode) {
        this.validationMode = validationMode;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setPersistenceXMLSchemaVersion(String persistenceXMLSchemaVersion) {
        this.persistenceXMLSchemaVersion = persistenceXMLSchemaVersion;
    }

    public void setClassTransformers(Set<ClassTransformer> classTransformers) {
        this.classTransformers = classTransformers;
    }

    public void addProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public void addMappingFile(String mappingFileName) {
        this.mappingFileNames.add(mappingFileName);
    }

    public void addJarFileUrl(String jarFileUrl) {
        try {
            this.jarFileUrls.add(new URL(jarFileUrl));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void addManagedClassName(String managedClassName) {
        this.managedClassNames.add(managedClassName);
    }

    public String toString() {
        return "PersistenceUnitInfoImpl{persistenceUnitName='" + this.persistenceUnitName + '\'' + ", persistenceProviderClassName='" + this.persistenceProviderClassName + '\'' + '}';
    }
}

