/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.constraintweight.descriptor;

import java.util.Objects;
import java.util.function.Function;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.constraintweight.descriptor.ConstraintConfigurationDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;

public class ConstraintWeightDescriptor<Solution_> {
    private final ConstraintConfigurationDescriptor<Solution_> constraintConfigurationDescriptor;
    private final String constraintPackage;
    private final String constraintName;
    private final MemberAccessor memberAccessor;

    public ConstraintWeightDescriptor(ConstraintConfigurationDescriptor<Solution_> constraintConfigurationDescriptor, MemberAccessor memberAccessor) {
        this.constraintConfigurationDescriptor = constraintConfigurationDescriptor;
        ConstraintWeight constraintWeightAnnotation = memberAccessor.getAnnotation(ConstraintWeight.class);
        String constraintPackage = constraintWeightAnnotation.constraintPackage();
        if (constraintPackage.isEmpty()) {
            ConstraintConfiguration constraintConfigurationAnnotation = memberAccessor.getDeclaringClass().getAnnotation(ConstraintConfiguration.class);
            if (constraintConfigurationAnnotation == null) {
                throw new IllegalStateException("Impossible state: " + ConstraintConfigurationDescriptor.class.getSimpleName() + " only reflects over members with a " + ConstraintConfiguration.class.getSimpleName() + " annotation.");
            }
            constraintPackage = constraintConfigurationAnnotation.constraintPackage();
            if (constraintPackage.isEmpty()) {
                Package pack = memberAccessor.getDeclaringClass().getPackage();
                constraintPackage = pack == null ? "" : pack.getName();
            }
        }
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintWeightAnnotation.value();
        this.memberAccessor = memberAccessor;
    }

    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public MemberAccessor getMemberAccessor() {
        return this.memberAccessor;
    }

    public Function<Solution_, Score<?>> createExtractor() {
        SolutionDescriptor<Solution_> solutionDescriptor = this.constraintConfigurationDescriptor.getSolutionDescriptor();
        MemberAccessor constraintConfigurationMemberAccessor = solutionDescriptor.getConstraintConfigurationMemberAccessor();
        return solution -> {
            Object constraintConfiguration = Objects.requireNonNull(constraintConfigurationMemberAccessor.executeGetter(solution), "Constraint configuration provider (" + constraintConfigurationMemberAccessor + ") returns null.");
            return (Score)this.memberAccessor.executeGetter(constraintConfiguration);
        };
    }

    public String toString() {
        return this.constraintPackage + ":" + this.constraintName;
    }
}

