/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui.form.render.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.kie.server.services.jbpm.ui.form.render.model.FormField;
import org.kie.server.services.jbpm.ui.form.render.model.FormLayout;
import org.kie.server.services.jbpm.ui.form.render.model.FormModel;

public class FormInstance {
    private String id;
    private String name;
    private FormModel model;
    private List<FormField> fields;
    @JsonProperty(value="layoutTemplate")
    private FormLayout layout;
    private Map<String, FormInstance> nestedForms = new HashMap<String, FormInstance>();
    private Function<String, FormInstance> nestedFormsLookup = formId -> null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<FormField> getFields() {
        return this.fields;
    }

    public void setFields(List<FormField> fields) {
        this.fields = fields;
    }

    public FormLayout getLayout() {
        return this.layout;
    }

    public void setLayout(FormLayout layout) {
        this.layout = layout;
    }

    public FormField getField(String fieldId) {
        return this.fields.stream().filter(f -> f.getId().equals(fieldId)).findFirst().get();
    }

    public FormField getFieldByBinding(String binding) {
        return this.fields.stream().filter(f -> f.getBinding().equals(binding)).findFirst().get();
    }

    public FormModel getModel() {
        return this.model;
    }

    public void setModel(FormModel model) {
        this.model = model;
    }

    public void addNestedForm(FormInstance nestedForm) {
        this.nestedForms.put(nestedForm.getId(), nestedForm);
    }

    public FormInstance getNestedForm(String formId) {
        FormInstance nestedForm = this.nestedForms.get(formId);
        if (nestedForm != null) {
            return nestedForm;
        }
        return this.nestedFormsLookup.apply(formId);
    }

    public void setNestedFormsLookup(Function<String, FormInstance> nestedFormsLookup) {
        this.nestedFormsLookup = nestedFormsLookup;
    }
}

