/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.kafka;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.server.services.jbpm.kafka.CloudEventReader;
import org.kie.server.services.jbpm.kafka.CloudEventWriter;
import org.kie.server.services.jbpm.kafka.KafkaEventProcessorFactory;
import org.kie.server.services.jbpm.kafka.KafkaEventReader;
import org.kie.server.services.jbpm.kafka.KafkaEventWriter;
import org.kie.server.services.jbpm.kafka.KafkaServerUtils;

class DefaultEventProcessorFactory
implements KafkaEventProcessorFactory {
    private Map<ReaderKey, ReaderValue> topicReaderMap = new HashMap<ReaderKey, ReaderValue>();
    private Map<String, KafkaEventWriter> topicWriterMap = new ConcurrentHashMap<String, KafkaEventWriter>();

    DefaultEventProcessorFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KafkaEventReader getEventReader(String topic, ClassLoader cl) {
        ReaderValue value;
        String className = KafkaServerUtils.getTopicProperty(topic, "eventReaderClass", CloudEventReader.class.getName());
        Map<ReaderKey, ReaderValue> map = this.topicReaderMap;
        synchronized (map) {
            value = this.topicReaderMap.computeIfAbsent(new ReaderKey(cl, className), k -> new ReaderValue(this.newReaderInstance(className, cl)));
            value.addReference(topic);
        }
        return value.getInstance();
    }

    @Override
    public KafkaEventWriter getEventWriter(String topic) {
        return this.topicWriterMap.computeIfAbsent(KafkaServerUtils.getTopicProperty(topic, "eventWriterClass", CloudEventWriter.class.getName()), this::newWriterInstance);
    }

    private KafkaEventReader newReaderInstance(String className, ClassLoader cl) {
        try {
            return Class.forName(className).asSubclass(KafkaEventReader.class).getConstructor(ClassLoader.class).newInstance(cl);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalArgumentException("Cannot instantiate KafkaEventReader class " + className + ". Please review system property configuration and make sure class has a public constructor that accepts a ClassLoaderInstance", ex);
        }
    }

    private KafkaEventWriter newWriterInstance(String className) {
        try {
            return Class.forName(className).asSubclass(KafkaEventWriter.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalArgumentException("Cannot instantiate KafkaEventWriter class " + className + ". Please review system property configuration and make sure class has a default public constructor ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readerUndeployed(String topic, ClassLoader cl) {
        String className = KafkaServerUtils.getTopicProperty(topic, "eventReaderClass", CloudEventReader.class.getName());
        ReaderKey key = new ReaderKey(cl, className);
        Map<ReaderKey, ReaderValue> map = this.topicReaderMap;
        synchronized (map) {
            ReaderValue value = this.topicReaderMap.get(key);
            if (value != null && value.removeReference(topic)) {
                this.topicReaderMap.remove(key);
            }
        }
    }

    @Override
    public void close() {
        this.topicReaderMap.clear();
        this.topicWriterMap.clear();
    }

    private static class ReaderValue {
        private KafkaEventReader instance;
        private Collection<String> topics;

        public ReaderValue(KafkaEventReader instance) {
            this.instance = instance;
            this.topics = new HashSet<String>();
        }

        public KafkaEventReader getInstance() {
            return this.instance;
        }

        public void addReference(String topic) {
            this.topics.add(topic);
        }

        public boolean removeReference(String topic) {
            this.topics.remove(topic);
            return this.topics.isEmpty();
        }
    }

    private static class ReaderKey {
        private ClassLoader cl;
        private String className;

        public ReaderKey(ClassLoader cl, String className) {
            this.cl = cl;
            this.className = className;
        }

        public int hashCode() {
            return this.className.hashCode() + this.cl.hashCode();
        }

        public boolean equals(Object obj) {
            boolean result;
            boolean bl = result = this == obj;
            if (!result && obj instanceof ReaderKey) {
                ReaderKey other = (ReaderKey)obj;
                result = this.cl.equals(other.cl) && this.className.equals(other.className);
            }
            return result;
        }
    }
}

